/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.FieldTypePair;
import de.bild.codec.TypeCodec;
import de.bild.codec.TypeCodecRegistry;
import de.bild.codec.TypeMismatchException;
import de.bild.codec.annotations.CodecToBeUsed;
import de.bild.codec.annotations.Id;
import de.bild.codec.annotations.LockingVersion;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedField {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappedField.class);
    public static final String ID_KEY = "_id";
    private static final List<Class<? extends Annotation>> ANNOTATIONS_TO_BE_HANDLED = new ArrayList<Class<? extends Annotation>>();
    final Field field;
    final Class persistedClass;
    private Codec codec;
    private PrimitiveType primitiveType;
    final FieldTypePair fieldTypePair;
    private final Map<Class<? extends Annotation>, Annotation> foundAnnotations;

    public MappedField(FieldTypePair fieldTypePair, Class<?> persistedClass, TypeCodecRegistry typeCodecRegistry) {
        this.field = fieldTypePair.getField();
        this.field.setAccessible(true);
        this.fieldTypePair = fieldTypePair;
        this.persistedClass = persistedClass;
        this.foundAnnotations = MappedField.buildAnnotationMap(this.field);
        if (this.field.getType().isPrimitive()) {
            this.primitiveType = PrimitiveType.get(this.field.getType());
        } else {
            CodecToBeUsed codecToBeUsed = fieldTypePair.getField().getDeclaredAnnotation(CodecToBeUsed.class);
            if (codecToBeUsed != null) {
                Class<Codec<?>> clazz = codecToBeUsed.value();
                try {
                    Constructor<Codec<?>> declaredConstructor = clazz.getDeclaredConstructor(TypeCodecRegistry.class);
                    declaredConstructor.setAccessible(true);
                    try {
                        this.codec = declaredConstructor.newInstance(typeCodecRegistry);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        LOGGER.warn("Unable to instantiate codec for {} ", clazz, (Object)e);
                    }
                }
                catch (NoSuchMethodException e) {
                    LOGGER.warn("Unable to find constructor {}(TypeCodecRegistry.class)", clazz, (Object)e);
                }
            } else {
                this.codec = typeCodecRegistry.getCodec(fieldTypePair.getRealType());
            }
        }
    }

    private static Map<Class<? extends Annotation>, Annotation> buildAnnotationMap(Field field) {
        HashMap<Class<? extends Annotation>, Annotation> foundAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Class<? extends Annotation> annotationClass : ANNOTATIONS_TO_BE_HANDLED) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            foundAnnotations.put(annotationClass, field.getAnnotation(annotationClass));
        }
        return Collections.unmodifiableMap(foundAnnotations);
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return (T)this.foundAnnotations.get(clazz);
    }

    public Map<Class<? extends Annotation>, Annotation> getAnnotations() {
        return this.foundAnnotations;
    }

    public boolean hasAnnotation(Class ann) {
        return this.foundAnnotations.containsKey(ann);
    }

    public String getMappedFieldName() {
        if (this.isIdField()) {
            return ID_KEY;
        }
        return this.field.getName();
    }

    public Class getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public Field getField() {
        return this.field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedField that = (MappedField)o;
        return this.field.equals(that.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean setFieldValue(Object instance, Object value) {
        try {
            this.field.set(instance, value);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Class<?> valueType = value != null ? value.getClass() : null;
            LOGGER.warn("Could not set field {} of instance {} to value {} of type", new Object[]{this.field, instance, value, e});
            throw new TypeMismatchException("Could not set field " + this.field + " of instance " + instance + " to value " + value + " of type " + valueType, e);
        }
    }

    public Object getFieldValue(Object instance) {
        try {
            return this.field.get(instance);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Could not get field value.", new Object[]{this.field, instance, e});
            return null;
        }
    }

    public <T> void encode(BsonWriter writer, T instance, EncoderContext encoderContext) {
        LOGGER.debug("Encode field : " + this.getMappedFieldName());
        if (this.field.getType().isPrimitive()) {
            if (this.isLockingVersionField()) {
                this.writeLockingVersion(writer, instance);
            } else {
                this.primitiveType.encode(writer, instance, encoderContext, this);
            }
        } else if (this.codec != null) {
            Object fieldValue = this.getFieldValue(instance);
            if (fieldValue == null && this.codec instanceof TypeCodec) {
                TypeCodec typeCodec = (TypeCodec)this.codec;
                fieldValue = typeCodec.defaultInstance();
            }
            if (fieldValue != null) {
                writer.writeName(this.getMappedFieldName());
                this.codec.encode(writer, fieldValue, encoderContext);
            }
        }
    }

    private <T> void writeLockingVersion(BsonWriter writer, T instance) {
        try {
            writer.writeName(this.getMappedFieldName());
            int lockingVersion = this.field.getInt(instance) + 1;
            writer.writeInt32(lockingVersion);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("IllegalAccessException while writeLockingVersion field " + this.field.getName(), (Throwable)e);
        }
    }

    public <T> void decode(BsonReader reader, T instance, DecoderContext decoderContext) {
        LOGGER.debug("Decode field : " + this.getMappedFieldName() + " Signature: " + this.fieldTypePair.getRealType());
        if (this.field.getType().isPrimitive()) {
            if (reader.getCurrentBsonType() == BsonType.NULL || reader.getCurrentBsonType() == BsonType.UNDEFINED) {
                reader.skipValue();
            } else {
                this.primitiveType.decode(reader, instance, decoderContext, this);
            }
        } else if (this.codec != null) {
            if (reader.getCurrentBsonType() == BsonType.NULL) {
                reader.readNull();
                this.setFieldValue(instance, null);
            } else if (reader.getCurrentBsonType() == BsonType.UNDEFINED) {
                reader.skipValue();
            } else {
                Object decoded = this.codec.decode(reader, decoderContext);
                if (decoded != null) {
                    this.setFieldValue(instance, decoded);
                }
            }
        }
    }

    public boolean isIdField() {
        return this.hasAnnotation(Id.class);
    }

    public boolean isLockingVersionField() {
        return this.hasAnnotation(LockingVersion.class) && Integer.TYPE.equals(this.field.getType());
    }

    public Codec getCodec() {
        return this.codec;
    }

    public <T> boolean initializeDefault(T instance) {
        if (this.field.getType().isPrimitive()) {
            return false;
        }
        if (this.codec != null && this.codec instanceof TypeCodec) {
            Object defaultValue;
            TypeCodec typeCodec = (TypeCodec)this.codec;
            if (this.getFieldValue(instance) == null && (defaultValue = typeCodec.defaultInstance()) != null) {
                this.setFieldValue(instance, defaultValue);
                return true;
            }
        }
        return false;
    }

    static {
        ANNOTATIONS_TO_BE_HANDLED.add(Id.class);
        ANNOTATIONS_TO_BE_HANDLED.add(LockingVersion.class);
    }

    private static enum PrimitiveType implements DefaultPrimitiveType
    {
        BYTE((Class)Byte.TYPE, BsonType.INT32){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setByte(instance, (byte)reader.readInt32());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeInt32((int)field.getByte(instance));
            }
        }
        ,
        BOOLEAN((Class)Boolean.TYPE, BsonType.BOOLEAN){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setBoolean(instance, reader.readBoolean());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeBoolean(field.getBoolean(instance));
            }
        }
        ,
        CHARACTER((Class)Character.TYPE, BsonType.INT32){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setChar(instance, (char)reader.readInt32());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeInt32((int)field.getChar(instance));
            }
        }
        ,
        FLOAT((Class)Float.TYPE, BsonType.DOUBLE){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setFloat(instance, (float)reader.readDouble());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeDouble((double)field.getFloat(instance));
            }
        }
        ,
        INTEGER((Class)Integer.TYPE, BsonType.INT32){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setInt(instance, reader.readInt32());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeInt32(field.getInt(instance));
            }
        }
        ,
        LONG((Class)Long.TYPE, BsonType.INT64){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setLong(instance, reader.readInt64());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeInt64(field.getLong(instance));
            }
        }
        ,
        SHORT((Class)Short.TYPE, BsonType.INT32){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setShort(instance, (short)reader.readInt32());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeInt32((int)field.getShort(instance));
            }
        }
        ,
        DOUBLE((Class)Double.TYPE, BsonType.DOUBLE){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setDouble(instance, reader.readDouble());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeDouble(field.getDouble(instance));
            }
        };

        final Class<?> primitiveClass;
        static final Map<Class<?>, PrimitiveType> PRIMITIVE_CLASS_TO_PRIMITIVE_TYPE;
        protected BsonType bsonType;

        private PrimitiveType(Class<?> primitiveClass, BsonType bsonType) {
            this.primitiveClass = primitiveClass;
            this.bsonType = bsonType;
        }

        @Override
        public BsonType getBsonType() {
            return this.bsonType;
        }

        public static PrimitiveType get(Class type) {
            return PRIMITIVE_CLASS_TO_PRIMITIVE_TYPE.get(type);
        }

        static {
            PRIMITIVE_CLASS_TO_PRIMITIVE_TYPE = new HashMap();
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                PRIMITIVE_CLASS_TO_PRIMITIVE_TYPE.put(primitiveType.primitiveClass, primitiveType);
            }
        }
    }

    private static interface DefaultPrimitiveType {
        public <T> void decodeInternal(BsonReader var1, T var2, Field var3) throws IllegalAccessException;

        public <T> void encodeInternal(BsonWriter var1, T var2, Field var3) throws IllegalAccessException;

        default public <T> void encode(BsonWriter writer, T instance, EncoderContext encoderContext, MappedField mappedField) {
            try {
                writer.writeName(mappedField.getMappedFieldName());
                this.encodeInternal(writer, instance, mappedField.getField());
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("Cannot access mappedField. ", (Object)mappedField, (Object)e);
            }
        }

        default public <T> void decode(BsonReader reader, T instance, DecoderContext decoderContext, MappedField mappedField) {
            try {
                if (this.checkBsonTypeAndSkipOnMisMatch(reader)) {
                    this.decodeInternal(reader, instance, mappedField.getField());
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("Could not decode mappedField.", (Object)mappedField, (Object)e);
            }
        }

        public BsonType getBsonType();

        default public boolean checkBsonTypeAndSkipOnMisMatch(BsonReader reader) {
            if (this.getBsonType().equals((Object)reader.getCurrentBsonType())) {
                return true;
            }
            LOGGER.warn("Expected {} from reader but got {}. Skipping value.", (Object)this.getBsonType(), (Object)reader.getCurrentBsonType());
            reader.skipValue();
            return false;
        }
    }
}

