/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.AbstractTypeCodec;
import de.bild.codec.TypeCodecRegistry;
import java.lang.reflect.Type;
import java.util.Collection;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CollectionTypeCodec<C extends Collection<V>, V>
extends AbstractTypeCodec<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionTypeCodec.class);
    Codec<V> typeCodec;

    public CollectionTypeCodec(Class<C> collectionClass, Type valueType, TypeCodecRegistry typeCodecRegistry) {
        super(collectionClass, typeCodecRegistry);
        this.typeCodec = typeCodecRegistry.getCodec(valueType);
    }

    public C decode(BsonReader reader, DecoderContext decoderContext) {
        Collection collection = null;
        if (BsonType.NULL.equals((Object)reader.getCurrentBsonType())) {
            reader.skipValue();
        } else if (BsonType.ARRAY.equals((Object)reader.getCurrentBsonType())) {
            collection = (Collection)this.newInstance();
            reader.readStartArray();
            while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                Object decode = this.typeCodec.decode(reader, decoderContext);
                collection.add(decode);
            }
            reader.readEndArray();
        } else {
            LOGGER.warn("Expected {} from reader but got {}. Skipping value.", (Object)BsonType.ARRAY, (Object)reader.getCurrentBsonType());
            reader.skipValue();
        }
        return (C)collection;
    }

    public void encode(BsonWriter writer, C values, EncoderContext encoderContext) {
        writer.writeStartArray();
        for (Object value : values) {
            if (value != null) {
                this.typeCodec.encode(writer, value, encoderContext);
                continue;
            }
            writer.writeNull();
        }
        writer.writeEndArray();
    }

    @Override
    public C defaultInstance() {
        return (C)((Collection)this.newInstance());
    }
}

