/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import com.mongodb.DBObjectCodecProvider;
import com.mongodb.DBRefCodecProvider;
import com.mongodb.client.gridfs.codecs.GridFSFileCodecProvider;
import com.mongodb.client.model.geojson.codecs.GeoJsonCodecProvider;
import de.bild.codec.CodecConfiguration;
import de.bild.codec.CodecResolver;
import de.bild.codec.DelegatingCodec;
import de.bild.codec.PojoContext;
import de.bild.codec.TypeCodec;
import de.bild.codec.TypeCodecProvider;
import de.bild.codec.TypesModel;
import de.bild.codec.annotations.DecodeUndefinedHandlingStrategy;
import de.bild.codec.annotations.EncodeNullHandlingStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.AtomicBooleanCodec;
import org.bson.codecs.AtomicIntegerCodec;
import org.bson.codecs.AtomicLongCodec;
import org.bson.codecs.BinaryCodec;
import org.bson.codecs.BooleanCodec;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.ByteArrayCodec;
import org.bson.codecs.CharacterCodec;
import org.bson.codecs.CodeCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DateCodec;
import org.bson.codecs.Decimal128Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.DoubleCodec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.IntegerCodec;
import org.bson.codecs.LongCodec;
import org.bson.codecs.MaxKeyCodec;
import org.bson.codecs.MinKeyCodec;
import org.bson.codecs.ObjectIdCodec;
import org.bson.codecs.PatternCodec;
import org.bson.codecs.StringCodec;
import org.bson.codecs.SymbolCodec;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoCodecProvider
implements CodecProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PojoCodecProvider.class);
    private final TypesModel typesModel;
    private final PojoContext pojoContext;
    private static final CodecRegistry DEFAULT_CODEC_REGISTRY = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new BinaryCodec(), new BooleanCodec(), new DateCodec(), new DoubleCodec(), new IntegerCodec(), new LongCodec(), new MinKeyCodec(), new MaxKeyCodec(), new CodeCodec(), new Decimal128Codec(), new ObjectIdCodec(), new CharacterCodec(), new StringCodec(), new SymbolCodec(), new UuidCodec(), new PatternCodec(), new ByteArrayCodec(), new AtomicBooleanCodec(), new AtomicIntegerCodec(), new AtomicLongCodec()}), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new DBRefCodecProvider(), new DocumentCodecProvider(), new DBObjectCodecProvider(), new BsonValueCodecProvider(), new GeoJsonCodecProvider(), new GridFSFileCodecProvider()})});

    public static CodecRegistry getDefaultCodecRegistry() {
        return DEFAULT_CODEC_REGISTRY;
    }

    PojoCodecProvider(Set<Class<?>> classes, Set<String> packages, Set<Class<? extends Annotation>> ignoreAnnotations, List<TypeCodecProvider> typeCodecProviders, List<CodecResolver> codecResolvers, CodecConfiguration codecConfiguration) {
        this.typesModel = new TypesModel(classes, packages, ignoreAnnotations);
        this.pojoContext = new PojoContext(this.typesModel, codecResolvers, typeCodecProviders, codecConfiguration);
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        Codec<T> codec = this.pojoContext.get(clazz, registry);
        if (codec instanceof TypeCodec) {
            TypeCodec typeCodec;
            if (clazz != null && clazz.getTypeParameters().length > 0) {
                LOGGER.warn("Generic classes will only be encoded/decoded with their upper bounds! We could prohibit handling of the pojo codec for those generic classes, but then user would loose flexibility when subclassing such classes. Class: " + clazz.toGenericString());
            }
            if ((typeCodec = (TypeCodec)codec).isCollectible()) {
                LOGGER.debug("Enhancing {} to be collectible codec.", (Object)typeCodec);
                ArrayList proxyInterfaceList = new ArrayList(Arrays.asList(typeCodec.getClass().getInterfaces()));
                proxyInterfaceList.add(CollectibleCodec.class);
                proxyInterfaceList.add(DelegatingCodec.class);
                CollectibleCodec collectibleCodec = (CollectibleCodec)Proxy.newProxyInstance(PojoCodecProvider.class.getClassLoader(), proxyInterfaceList.toArray(new Class[1]), new CollectibleCodecDelegator(typeCodec));
                return collectibleCodec;
            }
        }
        return codec;
    }

    public static class Builder {
        private Set<String> packages = new HashSet<String>();
        private Set<Class<?>> classes = new HashSet();
        private List<CodecResolver> codecResolvers = new ArrayList<CodecResolver>();
        private Set<Class<? extends Annotation>> ignoreAnnotations = new HashSet<Class<? extends Annotation>>();
        private List<TypeCodecProvider> typeCodecProviders = new ArrayList<TypeCodecProvider>();
        private EncodeNullHandlingStrategy.Strategy encodeNullHandlingStrategy = EncodeNullHandlingStrategy.Strategy.CODEC;
        private DecodeUndefinedHandlingStrategy.Strategy decodeUndefinedHandlingStrategy = DecodeUndefinedHandlingStrategy.Strategy.KEEP_POJO_DEFAULT;
        private boolean encodeNulls = false;

        public Builder setPackages(Set<String> packages) {
            this.packages = packages;
            return this;
        }

        public Builder register(String ... packages) {
            this.packages.addAll(Arrays.asList(packages));
            return this;
        }

        public Builder register(Class<?> ... classes) {
            this.classes.addAll(Arrays.asList(classes));
            return this;
        }

        public Builder ignoreTypesAnnotatedWith(Class<? extends Annotation> ... annotations) {
            this.ignoreAnnotations.addAll(Arrays.asList(annotations));
            return this;
        }

        public Builder register(TypeCodecProvider ... typeCodecProviders) {
            this.typeCodecProviders.addAll(Arrays.asList(typeCodecProviders));
            return this;
        }

        public Builder encodeNullHandlingStrategy(EncodeNullHandlingStrategy.Strategy encodeNullHandlingStrategy) {
            if (encodeNullHandlingStrategy != null) {
                this.encodeNullHandlingStrategy = encodeNullHandlingStrategy;
            }
            return this;
        }

        public Builder decodeUndefinedHandlingStrategy(DecodeUndefinedHandlingStrategy.Strategy decodeUndefinedHandlingStrategy) {
            if (decodeUndefinedHandlingStrategy != null) {
                this.decodeUndefinedHandlingStrategy = decodeUndefinedHandlingStrategy;
            }
            return this;
        }

        public Builder encodeNulls(boolean encodeNulls) {
            this.encodeNulls = encodeNulls;
            return this;
        }

        public Builder registerCodecResolver(CodecResolver ... codecResolvers) {
            this.codecResolvers.addAll(Arrays.asList(codecResolvers));
            return this;
        }

        public PojoCodecProvider build() {
            CodecConfiguration codecConfiguration = CodecConfiguration.builder().decodeUndefinedHandlingStrategy(this.decodeUndefinedHandlingStrategy).encodeNullHandlingStrategy(this.encodeNullHandlingStrategy).encodeNulls(this.encodeNulls).build();
            return new PojoCodecProvider(this.classes, this.packages, this.ignoreAnnotations, this.typeCodecProviders, this.codecResolvers, codecConfiguration);
        }
    }

    private static class CollectibleCodecDelegator<T>
    implements InvocationHandler,
    CollectibleCodec<T>,
    DelegatingCodec<T> {
        private final TypeCodec<T> delegatingCodec;
        private static final Object[] NO_ARGS = new Object[0];

        public CollectibleCodecDelegator(TypeCodec<T> delegatingCodec) {
            this.delegatingCodec = delegatingCodec;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (method.getDeclaringClass() == CollectibleCodec.class || method.getDeclaringClass() == DelegatingCodec.class) {
                    return method.invoke((Object)this, args);
                }
                return method.invoke(this.delegatingCodec, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warn("An exception was caught while invoking the delegate {} with args {}", (Object)method, (Object)args);
                LOGGER.debug("Original exception when invoking target.", (Throwable)e);
                throw e.getCause();
            }
        }

        public T generateIdIfAbsentFromDocument(T document) {
            return this.delegatingCodec.generateIdIfAbsentFromDocument(document);
        }

        public boolean documentHasId(T document) {
            return this.delegatingCodec.documentHasId(document);
        }

        public BsonValue getDocumentId(T document) {
            return this.delegatingCodec.getDocumentId(document);
        }

        public T decode(BsonReader reader, DecoderContext decoderContext) {
            return (T)this.delegatingCodec.decode(reader, decoderContext);
        }

        public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
            this.delegatingCodec.encode(writer, value, encoderContext);
        }

        public Class<T> getEncoderClass() {
            return this.delegatingCodec.getEncoderClass();
        }

        @Override
        public TypeCodec<T> getDelegate() {
            return this.delegatingCodec;
        }
    }
}

