/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.TypeCodec;
import java.util.Set;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PolymorphicCodec<T>
extends TypeCodec<T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(PolymorphicCodec.class);

    public T decodeFields(BsonReader var1, DecoderContext var2, T var3);

    public void encodeFields(BsonWriter var1, T var2, EncoderContext var3);

    public T newInstance();

    default public T decode(BsonReader reader, DecoderContext decoderContext) {
        if (reader.getCurrentBsonType() == null || reader.getCurrentBsonType() == BsonType.DOCUMENT) {
            reader.readStartDocument();
            T newInstance = this.decodeFields(reader, decoderContext, this.newInstance());
            reader.readEndDocument();
            return newInstance;
        }
        LOGGER.error("Expected to read document but reader is in state {}. Skipping value!", (Object)reader.getCurrentBsonType());
        reader.skipValue();
        return null;
    }

    default public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        if (value == null) {
            writer.writeNull();
        } else {
            writer.writeStartDocument();
            this.encodeFields(writer, value, encoderContext);
            writer.writeEndDocument();
        }
    }

    public void verifyFieldsNotNamedLikeAnyDiscriminatorKey(Set<String> var1) throws IllegalArgumentException;
}

