/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.ReflectionHelper;
import de.bild.codec.TypeCodec;
import de.bild.codec.TypeCodecRegistry;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.bson.BsonBinary;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayCodec
implements TypeCodec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrayCodec.class);
    final Codec arrayElementCodec;
    final Class<?> arrayClazz;

    public ArrayCodec(Type type, TypeCodecRegistry typeCodecRegistry) {
        if (TypeUtils.isArrayType((Type)type)) {
            this.arrayClazz = ReflectionHelper.extractRawClass(type);
            if (type instanceof GenericArrayType) {
                GenericArrayType genericArrayType = (GenericArrayType)type;
                this.arrayElementCodec = typeCodecRegistry.getCodec(genericArrayType.getGenericComponentType());
            } else {
                this.arrayElementCodec = typeCodecRegistry.getCodec(this.arrayClazz.getComponentType());
            }
        } else {
            throw new IllegalArgumentException("Unknown array type?!" + type);
        }
    }

    public void encode(BsonWriter writer, Object array, EncoderContext encoderContext) {
        writer.writeStartArray();
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object value = Array.get(array, i);
            if (value != null) {
                this.arrayElementCodec.encode(writer, value, encoderContext);
                continue;
            }
            writer.writeNull();
        }
        writer.writeEndArray();
    }

    public Object decode(BsonReader reader, DecoderContext decoderContext) {
        Object array = null;
        if (BsonType.ARRAY.equals((Object)reader.getCurrentBsonType())) {
            ArrayList<Object> list = new ArrayList<Object>();
            reader.readStartArray();
            while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                if (BsonType.NULL.equals((Object)reader.getCurrentBsonType())) {
                    reader.skipValue();
                    list.add(null);
                    continue;
                }
                list.add(this.arrayElementCodec.decode(reader, decoderContext));
            }
            reader.readEndArray();
            array = Array.newInstance(this.arrayClazz.getComponentType(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(array, i, list.get(i));
            }
        } else {
            LOGGER.warn("Expected {} from reader but got {}. Skipping value.", (Object)BsonType.ARRAY, (Object)reader.getCurrentBsonType());
            reader.skipValue();
        }
        return array;
    }

    public Class getEncoderClass() {
        return this.arrayClazz;
    }

    public static enum PrimitiveArrayCodec implements Codec
    {
        BYTE((Class)Byte.TYPE){

            @Override
            public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
                writer.writeBinaryData(new BsonBinary((byte[])value));
            }

            @Override
            public Object decode(BsonReader reader, DecoderContext decoderContext) {
                return reader.readBinaryData().getData();
            }

            @Override
            public void encodeInternal(BsonWriter writer, Object value, EncoderContext encoderContext) {
                throw new IllegalStateException("This method 'encodeInternal' on BYTE must never be called");
            }

            @Override
            public Object decodeInternal(BsonReader reader, DecoderContext decoderContext) {
                throw new IllegalStateException("This method 'decodeInternal' on BYTE must never be called");
            }
        }
        ,
        BOOLEAN((Class)Boolean.TYPE){

            @Override
            public void encodeInternal(BsonWriter writer, Object value, EncoderContext encoderContext) {
                for (boolean i : (boolean[])value) {
                    writer.writeBoolean(i);
                }
            }

            @Override
            public Object decodeInternal(BsonReader reader, DecoderContext decoderContext) {
                ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    arrayList.add(reader.readBoolean());
                }
                boolean[] booleans = new boolean[arrayList.size()];
                int i = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    boolean aPrimitiveBoolean = (Boolean)iterator.next();
                    booleans[i++] = aPrimitiveBoolean;
                }
                return booleans;
            }
        }
        ,
        CHARACTER((Class)Character.TYPE){

            @Override
            public void encodeInternal(BsonWriter writer, Object value, EncoderContext encoderContext) {
                for (char i : (char[])value) {
                    writer.writeInt32((int)i);
                }
            }

            @Override
            public Object decodeInternal(BsonReader reader, DecoderContext decoderContext) {
                ArrayList<Character> arrayList = new ArrayList<Character>();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    arrayList.add(Character.valueOf((char)reader.readInt32()));
                }
                char[] chars = new char[arrayList.size()];
                int i = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    char aPrimitive = ((Character)iterator.next()).charValue();
                    chars[i++] = aPrimitive;
                }
                return chars;
            }
        }
        ,
        FLOAT((Class)Float.TYPE){

            @Override
            public void encodeInternal(BsonWriter writer, Object value, EncoderContext encoderContext) {
                for (float i : (float[])value) {
                    writer.writeDouble((double)i);
                }
            }

            @Override
            public Object decodeInternal(BsonReader reader, DecoderContext decoderContext) {
                ArrayList<Float> arrayList = new ArrayList<Float>();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    arrayList.add(Float.valueOf((float)reader.readDouble()));
                }
                float[] floats = new float[arrayList.size()];
                int i = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    float aPrimitive = ((Float)iterator.next()).floatValue();
                    floats[i++] = aPrimitive;
                }
                return floats;
            }
        }
        ,
        INTEGER((Class)Integer.TYPE){

            @Override
            public void encodeInternal(BsonWriter writer, Object value, EncoderContext encoderContext) {
                for (int i : (int[])value) {
                    writer.writeInt32(i);
                }
            }

            @Override
            public Object decodeInternal(BsonReader reader, DecoderContext decoderContext) {
                IntStream.Builder builder = IntStream.builder();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    builder.add(reader.readInt32());
                }
                return builder.build().toArray();
            }
        }
        ,
        LONG((Class)Long.TYPE){

            @Override
            public void encodeInternal(BsonWriter writer, Object value, EncoderContext encoderContext) {
                for (long i : (long[])value) {
                    writer.writeInt64(i);
                }
            }

            @Override
            public Object decodeInternal(BsonReader reader, DecoderContext decoderContext) {
                LongStream.Builder builder = LongStream.builder();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    builder.add(reader.readInt64());
                }
                return builder.build().toArray();
            }
        }
        ,
        SHORT((Class)Short.TYPE){

            @Override
            public void encodeInternal(BsonWriter writer, Object value, EncoderContext encoderContext) {
                for (short i : (short[])value) {
                    writer.writeInt32((int)i);
                }
            }

            @Override
            public Object decodeInternal(BsonReader reader, DecoderContext decoderContext) {
                ArrayList<Short> arrayList = new ArrayList<Short>();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    arrayList.add((short)reader.readInt32());
                }
                short[] shorts = new short[arrayList.size()];
                int i = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    short aPrimitive = (Short)iterator.next();
                    shorts[i++] = aPrimitive;
                }
                return shorts;
            }
        }
        ,
        DOUBLE((Class)Double.TYPE){

            @Override
            public void encodeInternal(BsonWriter writer, Object value, EncoderContext encoderContext) {
                for (double i : (double[])value) {
                    writer.writeDouble(i);
                }
            }

            @Override
            public Object decodeInternal(BsonReader reader, DecoderContext decoderContext) {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    arrayList.add(reader.readDouble());
                }
                double[] doubles = new double[arrayList.size()];
                int i = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    double aPrimitive = (Double)iterator.next();
                    doubles[i++] = aPrimitive;
                }
                return doubles;
            }
        };

        final Class<?> primitiveClass;
        static final Map<Class<?>, PrimitiveArrayCodec> PRIMITIVE_CLASS_TO_TYPE;

        private PrimitiveArrayCodec(Class<?> primitiveClass) {
            this.primitiveClass = primitiveClass;
        }

        public Class getEncoderClass() {
            return this.primitiveClass;
        }

        public static PrimitiveArrayCodec get(Class<?> arrayClass) {
            if (arrayClass != null) {
                Class<?> componentType = arrayClass.getComponentType();
                return PRIMITIVE_CLASS_TO_TYPE.get(componentType);
            }
            return null;
        }

        protected abstract Object decodeInternal(BsonReader var1, DecoderContext var2);

        protected abstract void encodeInternal(BsonWriter var1, Object var2, EncoderContext var3);

        public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
            writer.writeStartArray();
            this.encodeInternal(writer, value, encoderContext);
            writer.writeEndArray();
        }

        public Object decode(BsonReader reader, DecoderContext decoderContext) {
            reader.readStartArray();
            Object primitiveArray = this.decodeInternal(reader, decoderContext);
            reader.readEndArray();
            return primitiveArray;
        }

        static {
            PRIMITIVE_CLASS_TO_TYPE = new HashMap();
            for (PrimitiveArrayCodec primitiveType : PrimitiveArrayCodec.values()) {
                PRIMITIVE_CLASS_TO_TYPE.put(primitiveType.primitiveClass, primitiveType);
            }
        }
    }
}

