/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.CodecConfiguration;
import de.bild.codec.FieldTypePair;
import de.bild.codec.TypeCodec;
import de.bild.codec.TypeCodecRegistry;
import de.bild.codec.TypeMismatchException;
import de.bild.codec.annotations.CodecToBeUsed;
import de.bild.codec.annotations.DecodeUndefinedHandlingStrategy;
import de.bild.codec.annotations.EncodeNullHandlingStrategy;
import de.bild.codec.annotations.EncodeNulls;
import de.bild.codec.annotations.Id;
import de.bild.codec.annotations.LockingVersion;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedField<T, F> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappedField.class);
    public static final String ID_KEY = "_id";
    private static final List<Class<? extends Annotation>> ANNOTATIONS_TO_BE_HANDLED = new ArrayList<Class<? extends Annotation>>();
    final Field field;
    final Class<T> persistedClass;
    private Codec<F> codec;
    private PrimitiveType primitiveType;
    final FieldTypePair fieldTypePair;
    final EncodeNullHandlingStrategy.Strategy encodeNullHandlingStrategy;
    final DecodeUndefinedHandlingStrategy.Strategy decodeUndefinedHandlingStrategy;
    final boolean encodeNulls;
    final CodecConfiguration codecConfiguration;
    private final Map<Class<? extends Annotation>, Annotation> foundAnnotations;

    public MappedField(FieldTypePair fieldTypePair, Class<T> persistedClass, TypeCodecRegistry typeCodecRegistry, CodecConfiguration codecConfiguration) {
        this.field = fieldTypePair.getField();
        this.field.setAccessible(true);
        this.fieldTypePair = fieldTypePair;
        this.persistedClass = persistedClass;
        this.foundAnnotations = MappedField.buildAnnotationMap(this.field);
        this.codecConfiguration = codecConfiguration;
        if (this.field.getType().isPrimitive()) {
            this.primitiveType = PrimitiveType.get(this.field.getType());
        } else {
            CodecToBeUsed codecToBeUsed = fieldTypePair.getField().getDeclaredAnnotation(CodecToBeUsed.class);
            if (codecToBeUsed != null) {
                Class<Codec<?>> clazz = codecToBeUsed.value();
                try {
                    Constructor<Codec<?>> declaredConstructor = clazz.getDeclaredConstructor(TypeCodecRegistry.class);
                    declaredConstructor.setAccessible(true);
                    try {
                        this.codec = declaredConstructor.newInstance(typeCodecRegistry);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        LOGGER.warn("Unable to instantiate codec for {} ", clazz, (Object)e);
                    }
                }
                catch (NoSuchMethodException e) {
                    LOGGER.warn("Unable to find constructor {}(TypeCodecRegistry.class)", clazz, (Object)e);
                }
            } else {
                this.codec = typeCodecRegistry.getCodec(fieldTypePair.getRealType());
            }
        }
        EncodeNullHandlingStrategy classEncodeNullHandlingStrategy = persistedClass.getDeclaredAnnotation(EncodeNullHandlingStrategy.class);
        EncodeNullHandlingStrategy fieldEncodeNullHandlingStrategy = this.getAnnotation(EncodeNullHandlingStrategy.class);
        this.encodeNullHandlingStrategy = fieldEncodeNullHandlingStrategy != null ? fieldEncodeNullHandlingStrategy.value() : (classEncodeNullHandlingStrategy != null ? classEncodeNullHandlingStrategy.value() : codecConfiguration.getEncodeNullHandlingStrategy());
        DecodeUndefinedHandlingStrategy classDecodeUndefinedHandlingStrategy = persistedClass.getDeclaredAnnotation(DecodeUndefinedHandlingStrategy.class);
        DecodeUndefinedHandlingStrategy fieldDecodeUndefinedHandlingStrategy = this.getAnnotation(DecodeUndefinedHandlingStrategy.class);
        this.decodeUndefinedHandlingStrategy = fieldDecodeUndefinedHandlingStrategy != null ? fieldDecodeUndefinedHandlingStrategy.value() : (classDecodeUndefinedHandlingStrategy != null ? classDecodeUndefinedHandlingStrategy.value() : codecConfiguration.getDecodeUndefinedHandlingStrategy());
        EncodeNulls classEncodeNulls = persistedClass.getDeclaredAnnotation(EncodeNulls.class);
        EncodeNulls fieldEncodeNulls = this.getAnnotation(EncodeNulls.class);
        this.encodeNulls = fieldEncodeNulls != null ? fieldEncodeNulls.value() : (classEncodeNulls != null ? classEncodeNulls.value() : codecConfiguration.isEncodeNulls());
    }

    private static Map<Class<? extends Annotation>, Annotation> buildAnnotationMap(Field field) {
        HashMap<Class<? extends Annotation>, Annotation> foundAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Class<? extends Annotation> annotationClass : ANNOTATIONS_TO_BE_HANDLED) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            foundAnnotations.put(annotationClass, field.getAnnotation(annotationClass));
        }
        return Collections.unmodifiableMap(foundAnnotations);
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return (T)this.foundAnnotations.get(clazz);
    }

    public Map<Class<? extends Annotation>, Annotation> getAnnotations() {
        return this.foundAnnotations;
    }

    public boolean hasAnnotation(Class ann) {
        return this.foundAnnotations.containsKey(ann);
    }

    public String getMappedFieldName() {
        if (this.isIdField()) {
            return ID_KEY;
        }
        return this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedField that = (MappedField)o;
        return this.field.equals(that.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean setFieldValue(T instance, F value) {
        try {
            this.field.set(instance, value);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Class<?> valueType = value != null ? value.getClass() : null;
            LOGGER.warn("Could not set field {} of instance {} to value {} of type", new Object[]{this.field, instance, value, e});
            throw new TypeMismatchException("Could not set field " + this.field + " of instance " + instance + " to value " + value + " of type " + valueType, e);
        }
    }

    public F getFieldValue(T instance) {
        try {
            return (F)this.field.get(instance);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Could not get field value.", new Object[]{this.field, instance, e});
            return null;
        }
    }

    public void encode(BsonWriter writer, T instance, EncoderContext encoderContext) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Encode field : {} - with codec {}", (Object)this.getMappedFieldName(), this.field.getType().isPrimitive() ? this.primitiveType : this.codec);
        }
        if (this.field.getType().isPrimitive()) {
            if (this.isLockingVersionField()) {
                this.writeLockingVersion(writer, instance);
            } else {
                this.primitiveType.encode(writer, instance, encoderContext, this);
            }
        } else if (this.codec != null) {
            Object fieldValue = this.getFieldValue(instance);
            if (fieldValue == null) {
                switch (this.encodeNullHandlingStrategy) {
                    case CODEC: {
                        if (!(this.codec instanceof TypeCodec)) break;
                        TypeCodec typeCodec = (TypeCodec)this.codec;
                        fieldValue = typeCodec.defaultInstance();
                        break;
                    }
                }
            }
            if (this.encodeNulls || fieldValue != null) {
                writer.writeName(this.getMappedFieldName());
                if (fieldValue == null) {
                    writer.writeNull();
                } else {
                    this.codec.encode(writer, fieldValue, encoderContext);
                }
            }
        }
    }

    private void writeLockingVersion(BsonWriter writer, T instance) {
        try {
            writer.writeName(this.getMappedFieldName());
            int lockingVersion = this.field.getInt(instance) + 1;
            writer.writeInt32(lockingVersion);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("IllegalAccessException while writeLockingVersion field " + this.field.getName(), (Throwable)e);
        }
    }

    public void decode(BsonReader reader, T instance, DecoderContext decoderContext) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Decode field : {}({}) - codec : {}", new Object[]{this.field, this.fieldTypePair.getRealType(), this.field.getType().isPrimitive() ? this.primitiveType : this.codec});
        }
        if (this.field.getType().isPrimitive()) {
            if (reader.getCurrentBsonType() == BsonType.NULL || reader.getCurrentBsonType() == BsonType.UNDEFINED) {
                reader.skipValue();
            } else {
                this.primitiveType.decode(reader, instance, decoderContext, this);
            }
        } else if (this.codec != null) {
            if (BsonType.NULL.equals((Object)reader.getCurrentBsonType())) {
                reader.readNull();
                this.setFieldValue(instance, null);
            } else if (BsonType.UNDEFINED.equals((Object)reader.getCurrentBsonType())) {
                reader.skipValue();
            } else {
                Object decoded = this.codec.decode(reader, decoderContext);
                this.setFieldValue(instance, decoded);
            }
        }
    }

    public boolean isIdField() {
        return this.hasAnnotation(Id.class);
    }

    public boolean isLockingVersionField() {
        return this.hasAnnotation(LockingVersion.class) && Integer.TYPE.equals(this.field.getType());
    }

    public Codec getCodec() {
        return this.codec;
    }

    public void initializeUndefinedValue(T instance) {
        if (this.field.getType().isPrimitive()) {
            return;
        }
        switch (this.decodeUndefinedHandlingStrategy) {
            case CODEC: {
                if (this.codec != null && this.codec instanceof TypeCodec) {
                    TypeCodec typeCodec = (TypeCodec)this.codec;
                    Object defaultValue = typeCodec.defaultInstance();
                    this.setFieldValue(instance, defaultValue);
                    return;
                }
                LOGGER.info("The provided codec {} for field {} is not capable of retrieving default values.", this.codec, (Object)this.field);
                break;
            }
            case SET_TO_NULL: {
                this.setFieldValue(instance, null);
                return;
            }
        }
    }

    static {
        ANNOTATIONS_TO_BE_HANDLED.add(Id.class);
        ANNOTATIONS_TO_BE_HANDLED.add(LockingVersion.class);
        ANNOTATIONS_TO_BE_HANDLED.add(EncodeNullHandlingStrategy.class);
        ANNOTATIONS_TO_BE_HANDLED.add(DecodeUndefinedHandlingStrategy.class);
        ANNOTATIONS_TO_BE_HANDLED.add(EncodeNulls.class);
    }

    private static enum PrimitiveType implements DefaultPrimitiveType
    {
        BYTE((Class)Byte.TYPE, BsonType.INT32){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setByte(instance, (byte)reader.readInt32());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeInt32((int)field.getByte(instance));
            }
        }
        ,
        BOOLEAN((Class)Boolean.TYPE, BsonType.BOOLEAN){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setBoolean(instance, reader.readBoolean());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeBoolean(field.getBoolean(instance));
            }
        }
        ,
        CHARACTER((Class)Character.TYPE, BsonType.INT32){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setChar(instance, (char)reader.readInt32());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeInt32((int)field.getChar(instance));
            }
        }
        ,
        FLOAT((Class)Float.TYPE, BsonType.DOUBLE){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setFloat(instance, (float)reader.readDouble());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeDouble((double)field.getFloat(instance));
            }
        }
        ,
        INTEGER((Class)Integer.TYPE, BsonType.INT32){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setInt(instance, reader.readInt32());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeInt32(field.getInt(instance));
            }
        }
        ,
        LONG((Class)Long.TYPE, BsonType.INT64){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setLong(instance, reader.readInt64());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeInt64(field.getLong(instance));
            }
        }
        ,
        SHORT((Class)Short.TYPE, BsonType.INT32){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setShort(instance, (short)reader.readInt32());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeInt32((int)field.getShort(instance));
            }
        }
        ,
        DOUBLE((Class)Double.TYPE, BsonType.DOUBLE){

            @Override
            public <T> void decodeInternal(BsonReader reader, T instance, Field field) throws IllegalAccessException {
                field.setDouble(instance, reader.readDouble());
            }

            @Override
            public <T> void encodeInternal(BsonWriter writer, T instance, Field field) throws IllegalAccessException {
                writer.writeDouble(field.getDouble(instance));
            }
        };

        final Class<?> primitiveClass;
        static final Map<Class<?>, PrimitiveType> PRIMITIVE_CLASS_TO_PRIMITIVE_TYPE;
        protected BsonType bsonType;

        private PrimitiveType(Class<?> primitiveClass, BsonType bsonType) {
            this.primitiveClass = primitiveClass;
            this.bsonType = bsonType;
        }

        @Override
        public BsonType getBsonType() {
            return this.bsonType;
        }

        public static PrimitiveType get(Class type) {
            return PRIMITIVE_CLASS_TO_PRIMITIVE_TYPE.get(type);
        }

        static {
            PRIMITIVE_CLASS_TO_PRIMITIVE_TYPE = new HashMap();
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                PRIMITIVE_CLASS_TO_PRIMITIVE_TYPE.put(primitiveType.primitiveClass, primitiveType);
            }
        }
    }

    private static interface DefaultPrimitiveType {
        public <T> void decodeInternal(BsonReader var1, T var2, Field var3) throws IllegalAccessException;

        public <T> void encodeInternal(BsonWriter var1, T var2, Field var3) throws IllegalAccessException;

        default public <T> void encode(BsonWriter writer, T instance, EncoderContext encoderContext, MappedField mappedField) {
            try {
                writer.writeName(mappedField.getMappedFieldName());
                this.encodeInternal(writer, instance, mappedField.getField());
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("Cannot access mappedField. ", (Object)mappedField, (Object)e);
            }
        }

        default public <T> void decode(BsonReader reader, T instance, DecoderContext decoderContext, MappedField mappedField) {
            try {
                if (this.checkBsonTypeAndSkipOnMisMatch(reader)) {
                    this.decodeInternal(reader, instance, mappedField.getField());
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("Could not decode mappedField.", (Object)mappedField, (Object)e);
            }
        }

        public BsonType getBsonType();

        default public boolean checkBsonTypeAndSkipOnMisMatch(BsonReader reader) {
            if (this.getBsonType().equals((Object)reader.getCurrentBsonType())) {
                return true;
            }
            LOGGER.warn("Expected {} from reader but got {}. Skipping value.", (Object)this.getBsonType(), (Object)reader.getCurrentBsonType());
            reader.skipValue();
            return false;
        }
    }
}

