/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import org.bson.BsonNull;
import org.bson.BsonValue;
import org.bson.codecs.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TypeCodec<T>
extends Codec<T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(TypeCodec.class);

    default public T defaultInstance() {
        return null;
    }

    default public boolean isCollectible() {
        return false;
    }

    default public T generateIdIfAbsentFromDocument(T document) {
        LOGGER.warn("generateIdIfAbsentFromDocument() should be overridden if used!");
        return document;
    }

    default public boolean documentHasId(T document) {
        LOGGER.warn("documentHasId() should be overridden if used!");
        return true;
    }

    default public BsonValue getDocumentId(T document) {
        LOGGER.warn("getDocumentId() should be overridden if used!");
        return BsonNull.VALUE;
    }
}

