/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.AbstractTypeCodec;
import de.bild.codec.ComplexMapTypeCodec;
import de.bild.codec.ReflectionHelper;
import de.bild.codec.SimpleMapTypeCodec;
import de.bild.codec.TypeCodecRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.bson.Document;
import org.bson.codecs.Codec;

public abstract class MapTypeCodec<K, V>
extends AbstractTypeCodec<Map<K, V>> {
    final Codec<V> valueTypeCodec;

    public MapTypeCodec(Class<Map<K, V>> encoderClass, Type valueType, TypeCodecRegistry typeCodecRegistry) {
        super(encoderClass, typeCodecRegistry);
        this.valueTypeCodec = typeCodecRegistry.getCodec(valueType);
    }

    @Override
    protected Constructor<Map<K, V>> getDefaultConstructor(Class<Map<K, V>> clazz) {
        if (clazz.isInterface()) {
            if (SortedMap.class.isAssignableFrom(clazz)) {
                return super.getDefaultConstructor(TreeMap.class);
            }
            return super.getDefaultConstructor(LinkedHashMap.class);
        }
        return super.getDefaultConstructor(clazz);
    }

    @Override
    public Map<K, V> defaultInstance() {
        return (Map)this.newInstance();
    }

    @Override
    public Class<Map<K, V>> getEncoderClass() {
        return this.encoderClass;
    }

    public static MapTypeCodec getCodecIfApplicable(Type type, TypeCodecRegistry typeCodecRegistry) {
        Type setInterface;
        Class rawClass = ReflectionHelper.extractRawClass(type);
        if (rawClass != null && !Document.class.isAssignableFrom(rawClass) && Map.class.isAssignableFrom(rawClass) && (setInterface = ReflectionHelper.findInterface(type, Map.class)) instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)setInterface;
            if (parameterizedType.getActualTypeArguments()[0].equals(String.class)) {
                return new SimpleMapTypeCodec(rawClass, parameterizedType.getActualTypeArguments()[1], typeCodecRegistry);
            }
            return new ComplexMapTypeCodec(rawClass, parameterizedType.getActualTypeArguments()[0], parameterizedType.getActualTypeArguments()[1], typeCodecRegistry);
        }
        return null;
    }
}

