/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.ArrayCodec;
import de.bild.codec.BasicReflectionCodec;
import de.bild.codec.CodecConfiguration;
import de.bild.codec.CodecResolver;
import de.bild.codec.ComplexMapTypeCodec;
import de.bild.codec.DelegatingCodec;
import de.bild.codec.EnumCodec;
import de.bild.codec.ListTypeCodec;
import de.bild.codec.PolymorphicCodec;
import de.bild.codec.PolymorphicReflectionCodec;
import de.bild.codec.PrimitiveArrayCodec;
import de.bild.codec.ReflectionHelper;
import de.bild.codec.SetTypeCodec;
import de.bild.codec.SimpleMapTypeCodec;
import de.bild.codec.SpecialFieldsMap;
import de.bild.codec.SpecialFieldsMapCodec;
import de.bild.codec.TypeCodec;
import de.bild.codec.TypeCodecProvider;
import de.bild.codec.TypeCodecRegistry;
import de.bild.codec.TypesModel;
import de.bild.codec.annotations.Discriminator;
import de.bild.codec.annotations.Polymorphic;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.IterableCodec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(PojoContext.class);
    private final Map<Type, Codec<?>> codecMap = new ConcurrentHashMap();
    private final TypesModel typesModel;
    private final List<CodecResolver> codecResolvers;
    private final List<TypeCodecProvider> typeCodecProviders;
    private final CodecConfiguration codecConfiguration;
    private static final TypeCodecProvider DEFAULT_TYPE_CODEC_PROVIDER = new TypeCodecProvider(){

        @Override
        public <T> Codec<T> get(Type type, TypeCodecRegistry typeCodecRegistry) {
            if (TypeUtils.isArrayType((Type)type)) {
                PrimitiveArrayCodec primitiveArrayCodec = PrimitiveArrayCodec.get(ReflectionHelper.extractRawClass(type));
                if (primitiveArrayCodec != null) {
                    return primitiveArrayCodec;
                }
                return new ArrayCodec(type, typeCodecRegistry);
            }
            if (type instanceof TypeVariable) {
                throw new IllegalArgumentException("This registry (and probably no other one as well) can not handle generic type variables.");
            }
            if (type instanceof WildcardType) {
                LOGGER.error("WildcardTypes are not yet supported. {}", (Object)type);
                throw new NotImplementedException("WildcardTypes are not yet supported. " + type);
            }
            if (TypeUtils.isAssignable((Type)type, SpecialFieldsMap.class)) {
                return new SpecialFieldsMapCodec(type, typeCodecRegistry);
            }
            if (TypeUtils.isAssignable((Type)type, Enum.class)) {
                return new EnumCodec(ReflectionHelper.extractRawClass(type));
            }
            return null;
        }
    };

    PojoContext(TypesModel typesModel, List<CodecResolver> codecResolvers, List<TypeCodecProvider> typeCodecProviders, CodecConfiguration codecConfiguration) {
        this.typesModel = typesModel;
        this.codecResolvers = codecResolvers;
        this.typeCodecProviders = typeCodecProviders;
        this.codecConfiguration = codecConfiguration;
    }

    public synchronized <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        return this.getCodec(clazz, new AnyTypeCodecRegistry(registry, this));
    }

    public synchronized <T> Codec<T> getCodec(Type type, TypeCodecRegistry typeCodecRegistry) {
        Object codec = this.codecMap.get(type);
        if (codec != null) {
            return codec;
        }
        LazyCodec lazyCodec = new LazyCodec(type, typeCodecRegistry);
        this.codecMap.put(type, lazyCodec);
        codec = this.calculateCodec(type, typeCodecRegistry);
        if (codec == null) {
            this.codecMap.remove(type);
        } else {
            this.codecMap.put(type, (Codec<?>)codec);
        }
        return codec;
    }

    public synchronized <T> PolymorphicCodec<T> resolve(Type type, TypeCodecRegistry typeCodecRegistry) {
        for (CodecResolver codecResolver : this.codecResolvers) {
            PolymorphicCodec codec = codecResolver.getCodec(type, typeCodecRegistry, this.codecConfiguration);
            if (codec == null) continue;
            return codec;
        }
        if (!this.codecMap.containsKey(type)) {
            Codec standardCodec = typeCodecRegistry.getCodec(type);
            if (standardCodec instanceof PolymorphicCodec) {
                return (PolymorphicCodec)standardCodec;
            }
            if (!(standardCodec instanceof TypeCodec)) {
                return new PolymorphicCodecWrapper(standardCodec);
            }
        }
        if (TypeUtils.isAssignable((Type)type, Enum.class)) {
            return new PolymorphicCodecWrapper(new EnumCodec(ReflectionHelper.extractRawClass(type)));
        }
        return new BasicReflectionCodec(type, typeCodecRegistry, this.codecConfiguration);
    }

    private <T> Codec<T> calculateCodec(Type type, TypeCodecRegistry typeCodecRegistry) {
        Codec codec;
        block22: {
            Type setInterface;
            for (TypeCodecProvider typeCodecProvider : this.typeCodecProviders) {
                codec = typeCodecProvider.get(type, typeCodecRegistry);
                if (codec == null) continue;
                return codec;
            }
            codec = DEFAULT_TYPE_CODEC_PROVIDER.get(type, typeCodecRegistry);
            if (codec != null) {
                return codec;
            }
            Class rawClass = ReflectionHelper.extractRawClass(type);
            if (rawClass != null && List.class.isAssignableFrom(rawClass)) {
                Type listInterface = ReflectionHelper.findInterface(type, List.class);
                if (listInterface instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)listInterface;
                    try {
                        codec = new ListTypeCodec(rawClass, parameterizedType.getActualTypeArguments()[0], typeCodecRegistry);
                    }
                    catch (CodecConfigurationException cce) {
                        LOGGER.debug("Can't create advanced (generic list) codec for {}. Fall back to mongo db driver defaults.", (Object)parameterizedType, (Object)cce.getMessage());
                    }
                }
            } else if (rawClass != null && Set.class.isAssignableFrom(rawClass)) {
                setInterface = ReflectionHelper.findInterface(type, Set.class);
                if (setInterface instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)setInterface;
                    try {
                        codec = new SetTypeCodec(rawClass, parameterizedType.getActualTypeArguments()[0], typeCodecRegistry);
                    }
                    catch (CodecConfigurationException cce) {
                        LOGGER.debug("Can't create advanced (generic set) codec for {}. Fall back to mongo db driver defaults.", (Object)parameterizedType, (Object)cce.getMessage());
                    }
                }
            } else if (Document.class.isAssignableFrom(rawClass)) {
                codec = null;
            } else if (rawClass != null && Map.class.isAssignableFrom(rawClass)) {
                setInterface = ReflectionHelper.findInterface(type, Map.class);
                if (setInterface instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)setInterface;
                    Type keyType = parameterizedType.getActualTypeArguments()[0];
                    Type valueType = parameterizedType.getActualTypeArguments()[1];
                    try {
                        if (keyType.equals(String.class)) {
                            codec = new SimpleMapTypeCodec(rawClass, valueType, typeCodecRegistry);
                            break block22;
                        }
                        codec = new ComplexMapTypeCodec(rawClass, keyType, valueType, typeCodecRegistry);
                    }
                    catch (CodecConfigurationException cce) {
                        LOGGER.debug("Can't create advanced (generic map) codec for {}. Fall back to mongo db driver defaults.", (Object)parameterizedType, (Object)cce.getMessage());
                    }
                }
            } else {
                Set<Type> validTypesForType = this.typesModel.getAssignableTypesWithinClassHierarchy(type);
                if (validTypesForType == null || validTypesForType.isEmpty()) {
                    LOGGER.debug("Could not find concrete implementation for type {}. Maybe another codec is able to handle te class?!", (Object)type);
                    return null;
                }
                if (validTypesForType.size() > 1 || this.isPolymorphic(type, validTypesForType.iterator().next())) {
                    LOGGER.debug("Creating polymorphic codec for type {} with valid types {}", (Object)type, validTypesForType);
                    return new PolymorphicReflectionCodec(type, validTypesForType, typeCodecRegistry, this);
                }
                LOGGER.debug("Creating simple reflection based codec for type {} (generic type {}) as only one concrete implementation known.", (Object)type, validTypesForType);
                Type singleType = validTypesForType.iterator().next();
                codec = this.resolve(singleType, typeCodecRegistry);
            }
        }
        return codec;
    }

    private boolean isPolymorphic(Type type, Type singleValidType) {
        Class typeClazz = ReflectionHelper.extractRawClass(type);
        Class singleValidClass = ReflectionHelper.extractRawClass(singleValidType);
        return typeClazz.isInterface() || singleValidClass.getAnnotation(Polymorphic.class) != null || singleValidClass.getDeclaredAnnotation(Discriminator.class) != null || this.isClassPartOfPolymorphicStructureWithinTypesModel(typeClazz);
    }

    private boolean isClassPartOfPolymorphicStructureWithinTypesModel(Class clazz) {
        Class superclass = clazz.getSuperclass();
        if (this.typesModel.getClassHierarchyNodeForType(superclass) != null) {
            return true;
        }
        for (Class<?> anInterface : clazz.getInterfaces()) {
            if (this.typesModel.getClassHierarchyNodeForType(anInterface) == null) continue;
            return true;
        }
        return false;
    }

    private static class LazyCodec<T>
    implements TypeCodec<T>,
    DelegatingCodec<T> {
        private final Type type;
        private volatile Codec<T> wrapped;
        private final TypeCodecRegistry typeCodecRegistry;

        LazyCodec(Type type, TypeCodecRegistry typeCodecRegistry) {
            this.type = type;
            this.typeCodecRegistry = typeCodecRegistry;
        }

        public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
            this.getWrapped().encode(writer, value, encoderContext);
        }

        public Class<T> getEncoderClass() {
            return this.getWrapped().getEncoderClass();
        }

        public T decode(BsonReader reader, DecoderContext decoderContext) {
            return (T)this.getWrapped().decode(reader, decoderContext);
        }

        private Codec<T> getWrapped() {
            if (this.wrapped == null) {
                this.wrapped = this.typeCodecRegistry.getCodec(this.type);
            }
            return this.wrapped;
        }

        @Override
        public Codec<T> getDelegate() {
            return this.getWrapped();
        }
    }

    private static class PolymorphicCodecWrapper<T>
    implements PolymorphicCodec<T> {
        final Codec<T> codec;

        public PolymorphicCodecWrapper(Codec<T> codec) {
            this.codec = codec;
        }

        @Override
        public T decodeFields(BsonReader reader, DecoderContext decoderContext, T instance) {
            while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                String fieldName = reader.readName();
                if ("data".equals(fieldName)) {
                    return (T)this.codec.decode(reader, decoderContext);
                }
                reader.skipValue();
            }
            return null;
        }

        @Override
        public void encodeFields(BsonWriter writer, T instance, EncoderContext encoderContext) {
            writer.writeName("data");
            this.codec.encode(writer, instance, encoderContext);
        }

        @Override
        public T newInstance() {
            return null;
        }

        @Override
        public void verifyFieldsNotNamedLikeAnyDiscriminatorKey(Set<String> discriminatorKeys) throws IllegalArgumentException {
            if (discriminatorKeys.contains("data")) {
                throw new IllegalArgumentException("One of the discriminator keys equals the reserved word 'data' " + discriminatorKeys);
            }
        }

        public Class<T> getEncoderClass() {
            return this.codec.getEncoderClass();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PolymorphicCodecWrapper{");
            sb.append("codec=").append(this.codec);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class AnyTypeCodecRegistry
    implements TypeCodecRegistry {
        final CodecRegistry codecRegistry;
        final PojoContext pojoContext;

        public AnyTypeCodecRegistry(CodecRegistry codecRegistry, PojoContext pojoContext) {
            this.codecRegistry = codecRegistry;
            this.pojoContext = pojoContext;
        }

        @Override
        public <T> Codec<T> getCodec(Type type) {
            Codec codec;
            if (type instanceof Class) {
                codec = this.codecRegistry.get(ReflectionHelper.extractRawClass(type));
                if (codec instanceof IterableCodec) {
                    codec = this.pojoContext.getCodec(type, this);
                }
            } else {
                codec = this.pojoContext.getCodec(type, this);
            }
            return codec;
        }

        @Override
        public CodecRegistry getRegistry() {
            return this.codecRegistry;
        }
    }
}

