/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonValue;
import org.bson.codecs.Codec;
import org.bson.conversions.Bson;
import org.slf4j.LoggerFactory;

public interface TypeCodec<T>
extends Codec<T> {
    default public T defaultInstance() {
        return null;
    }

    default public boolean isCollectible() {
        return false;
    }

    default public T generateIdIfAbsentFromDocument(T document) {
        LoggerFactory.getLogger(TypeCodec.class).warn("generateIdIfAbsentFromDocument() should be overridden if used!");
        return document;
    }

    default public boolean documentHasId(T document) {
        LoggerFactory.getLogger(TypeCodec.class).warn("documentHasId() should be overridden if used!");
        return true;
    }

    default public BsonValue getDocumentId(T document) {
        LoggerFactory.getLogger(TypeCodec.class).warn("getDocumentId() should be overridden if used!");
        return BsonNull.VALUE;
    }

    default public Bson getTypeFilter() {
        return new BsonDocument();
    }
}

