/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.AbstractTypeCodec;
import de.bild.codec.CodecConfiguration;
import de.bild.codec.FieldTypePair;
import de.bild.codec.IdGenerationException;
import de.bild.codec.IdGenerator;
import de.bild.codec.MappedField;
import de.bild.codec.MethodTypePair;
import de.bild.codec.ObjectIdGenerator;
import de.bild.codec.ReflectionCodec;
import de.bild.codec.ReflectionHelper;
import de.bild.codec.TypeCodecRegistry;
import de.bild.codec.TypeMismatchException;
import de.bild.codec.annotations.Id;
import de.bild.codec.annotations.PostLoad;
import de.bild.codec.annotations.PreSave;
import de.bild.codec.annotations.Transient;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicReflectionCodec<T>
extends AbstractTypeCodec<T>
implements ReflectionCodec<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicReflectionCodec.class);
    MappedField<T, Object> idField;
    private static IdGenerator<ObjectId> DEFAULT_ID_GENERATOR = new ObjectIdGenerator();
    final Map<String, MappedField> persistenceFields = new LinkedHashMap<String, MappedField>();
    final List<Method> postLoadMethods = new ArrayList<Method>();
    final List<Method> preSaveMethods = new ArrayList<Method>();
    IdGenerator idGenerator;
    boolean isCollectible;

    public BasicReflectionCodec(Type type, TypeCodecRegistry typeCodecRegistry, CodecConfiguration codecConfiguration) {
        super(type, typeCodecRegistry);
        for (FieldTypePair fieldTypePair : ReflectionHelper.getDeclaredAndInheritedFieldTypePairs(type, true)) {
            Field field = fieldTypePair.getField();
            if (this.isIgnorable(field)) continue;
            MappedField mappedField = null;
            try {
                mappedField = new MappedField(fieldTypePair, this.encoderClass, typeCodecRegistry, codecConfiguration);
            }
            catch (CodecConfigurationException e) {
                LOGGER.error("No codec found for field {}", (Object)field);
                throw e;
            }
            this.persistenceFields.put(mappedField.getMappedFieldName(), mappedField);
            if (!mappedField.isIdField()) continue;
            if (this.idField == null) {
                this.idField = mappedField;
                Id idAnnotation = this.idField.getAnnotation(Id.class);
                this.isCollectible = idAnnotation.collectible();
                if (!this.isCollectible) continue;
                Class<? extends IdGenerator> idGeneratorClass = idAnnotation.value();
                if (idGeneratorClass == Id.DefaultIdGenerator.class) {
                    if (this.idField.getField().getType() != ObjectId.class) {
                        LOGGER.error("The id field for pojo class {} is of type {} is not able to consume ObjectIds values from ObjectIdGenerator. Please define a proper ObjectIdGenerator along with annotation Id(value=Generator.class)", this.getEncoderClass(), (Object)this.idField.getFieldTypePair().getRealType());
                        throw new IllegalArgumentException("The id field for pojo class " + this.getEncoderClass() + " is of type " + this.idField.getFieldTypePair().getRealType() + " is not able to consume ObjectIds values from ObjectIdGenerator. Please define a proper ObjectIdGenerator along with annotation Id(value=Generator.class)");
                    }
                    this.idGenerator = DEFAULT_ID_GENERATOR;
                    continue;
                }
                try {
                    Constructor<? extends IdGenerator> idGeneratorConstructor = idGeneratorClass.getDeclaredConstructor(new Class[0]);
                    idGeneratorConstructor.setAccessible(true);
                    this.idGenerator = idGeneratorConstructor.newInstance(new Object[0]);
                    continue;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalArgumentException("Could not create instance of IdGenerator for class " + type + " Generator class: " + idGeneratorClass, e);
                }
            }
            throw new IllegalArgumentException("Id field is annotated multiple times in class hierarchy! Class " + this.encoderClass);
        }
        for (MethodTypePair methodTypePair : ReflectionHelper.getDeclaredAndInheritedMethods(this.encoderClass)) {
            Method method = methodTypePair.getMethod();
            if (method.isAnnotationPresent(PostLoad.class)) {
                this.postLoadMethods.add(method);
                continue;
            }
            if (!method.isAnnotationPresent(PreSave.class)) continue;
            this.preSaveMethods.add(method);
        }
    }

    @Override
    public Map<String, MappedField> getPersistenceFields() {
        return this.persistenceFields;
    }

    protected boolean isIgnorable(Field field) {
        return field.isAnnotationPresent(Transient.class) || Modifier.isTransient(field.getModifiers());
    }

    @Override
    public T decodeFields(BsonReader reader, DecoderContext decoderContext, T instance) {
        HashSet<String> fieldNames = new HashSet<String>(this.persistenceFields.keySet());
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            MappedField mappedField = this.persistenceFields.get(fieldName);
            if (mappedField != null) {
                fieldNames.remove(fieldName);
                mappedField.decode(reader, instance, decoderContext);
                continue;
            }
            reader.skipValue();
        }
        for (String fieldName : fieldNames) {
            this.persistenceFields.get(fieldName).initializeUndefinedValue(instance);
        }
        this.postDecode(instance);
        return instance;
    }

    @Override
    public void postDecode(T instance) {
        for (Method postLoadMethod : this.postLoadMethods) {
            try {
                postLoadMethod.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warn("@PostLoad method {} could not be called.", (Object)postLoadMethod, (Object)e);
            }
        }
    }

    @Override
    public void encodeFields(BsonWriter writer, T instance, EncoderContext encoderContext) {
        this.preEncode(instance);
        for (MappedField persistenceField : this.persistenceFields.values()) {
            persistenceField.encode(writer, instance, encoderContext);
        }
    }

    @Override
    public void preEncode(T instance) {
        for (Method preSaveMethod : this.preSaveMethods) {
            try {
                preSaveMethod.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warn("@PreSave method {} could not be called.", (Object)preSaveMethod, (Object)e);
            }
        }
    }

    @Override
    public MappedField getMappedField(String mappedFieldName) {
        return this.persistenceFields.get(mappedFieldName);
    }

    @Override
    public boolean isCollectible() {
        return this.isCollectible;
    }

    @Override
    public T generateIdIfAbsentFromDocument(T document) {
        if (this.idGenerator != null && !this.documentHasId(document)) {
            Object generatedId = this.idGenerator.generate();
            try {
                if (!this.idField.setFieldValue(document, generatedId)) {
                    LOGGER.error("Id {} for pojo {} could not be set. Please watch the logs.", generatedId, document);
                    throw new IdGenerationException("Id could not be generated for pojo. See logs for details.");
                }
            }
            catch (TypeMismatchException e) {
                if (generatedId != null && !TypeUtils.isAssignable(generatedId.getClass(), (Type)this.idField.fieldTypePair.realType)) {
                    LOGGER.error("Your set id generator {} for the id field {} produces non-assignable values.", new Object[]{this.idGenerator, this.idField, e});
                } else {
                    LOGGER.error("Some unspecified error occurred while generating an id {}\u00a0for your pojo {}", generatedId, document);
                }
                throw new IdGenerationException("Id could not be generated for pojo. See logs for details.", e);
            }
        }
        return document;
    }

    @Override
    public boolean documentHasId(T document) {
        return this.getPlainId(document) != null;
    }

    private Object getPlainId(T document) {
        return this.idField != null ? this.idField.getFieldValue(document) : null;
    }

    @Override
    public BsonValue getDocumentId(T document) {
        return this.idGenerator.asBsonValue(this.getPlainId(document), this.typeCodecRegistry);
    }
}

