/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.ClassResolver;
import de.bild.codec.CodecConfiguration;
import de.bild.codec.CodecResolver;
import de.bild.codec.DelegatingCodec;
import de.bild.codec.PojoContext;
import de.bild.codec.TypeCodec;
import de.bild.codec.TypeCodecProvider;
import de.bild.codec.TypesModel;
import de.bild.codec.annotations.DecodeUndefinedHandlingStrategy;
import de.bild.codec.annotations.EncodeNullHandlingStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoCodecProvider
implements CodecProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PojoCodecProvider.class);
    private final TypesModel typesModel;
    private final PojoContext pojoContext;

    PojoCodecProvider(Set<Class<?>> classes, Set<String> packages, Set<Class<? extends Annotation>> ignoreAnnotations, Set<Predicate<String>> ignoreTypesMatchingClassNamePredicates, Set<Class<?>> ignoreClasses, List<TypeCodecProvider> typeCodecProviders, List<CodecResolver> codecResolvers, CodecConfiguration codecConfiguration, ClassResolver classResolver) {
        this.typesModel = new TypesModel(classes, packages, ignoreAnnotations, ignoreTypesMatchingClassNamePredicates, ignoreClasses, classResolver);
        this.pojoContext = new PojoContext(this.typesModel, codecResolvers, typeCodecProviders, codecConfiguration);
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        Codec<T> codec = this.pojoContext.get(clazz, registry);
        if (codec instanceof TypeCodec) {
            TypeCodec typeCodec;
            if (clazz != null && clazz.getTypeParameters().length > 0) {
                LOGGER.warn("Generic classes will only be encoded/decoded with their upper bounds! We could prohibit handling of the pojo codec for those generic classes, but then user would loose flexibility when subclassing such classes. Class: {}", (Object)clazz.toGenericString());
            }
            if ((typeCodec = (TypeCodec)codec).isCollectible()) {
                LOGGER.debug("Enhancing {} to be collectible codec.", (Object)typeCodec);
                ArrayList proxyInterfaceList = new ArrayList(Arrays.asList(typeCodec.getClass().getInterfaces()));
                proxyInterfaceList.add(CollectibleCodec.class);
                proxyInterfaceList.add(DelegatingCodec.class);
                return (CollectibleCodec)Proxy.newProxyInstance(PojoCodecProvider.class.getClassLoader(), proxyInterfaceList.toArray(new Class[1]), new CollectibleCodecDelegator(typeCodec));
            }
        }
        return codec;
    }

    public Bson getTypeFilter(Class<?> clazz, CodecRegistry registry) {
        Codec<?> codec = this.get(clazz, registry);
        if (codec instanceof TypeCodec) {
            return ((TypeCodec)codec).getTypeFilter();
        }
        return null;
    }

    public static class Builder {
        private Set<String> packages = new HashSet<String>();
        private Set<Class<?>> classes = new HashSet();
        private List<CodecResolver> codecResolvers = new ArrayList<CodecResolver>();
        private Set<Class<? extends Annotation>> ignoreAnnotations = new HashSet<Class<? extends Annotation>>();
        private Set<Predicate<String>> ignoreTypesMatchingClassNamePredicates = new HashSet<Predicate<String>>();
        private Set<Class<?>> ignoreClasses = new HashSet();
        private ClassResolver classResolver;
        private List<TypeCodecProvider> typeCodecProviders = new ArrayList<TypeCodecProvider>();
        private EncodeNullHandlingStrategy.Strategy encodeNullHandlingStrategy = EncodeNullHandlingStrategy.Strategy.CODEC;
        private DecodeUndefinedHandlingStrategy.Strategy decodeUndefinedHandlingStrategy = DecodeUndefinedHandlingStrategy.Strategy.KEEP_POJO_DEFAULT;
        private boolean encodeNulls = false;

        public Builder setPackages(Set<String> packages) {
            this.packages = packages;
            return this;
        }

        public Builder register(String ... packages) {
            this.packages.addAll(Arrays.asList(packages));
            return this;
        }

        public Builder register(Class<?> ... classes) {
            this.classes.addAll(Arrays.asList(classes));
            return this;
        }

        public Builder registerClassResolver(ClassResolver classResolver) {
            this.classResolver = classResolver;
            return this;
        }

        public Builder ignoreTypesAnnotatedWith(Class<? extends Annotation> ... annotations) {
            this.ignoreAnnotations.addAll(Arrays.asList(annotations));
            return this;
        }

        public Builder ignoreTypesMatchingClassNamePredicate(Predicate<String> ... ignoreTypesMatchingClassNamePredicates) {
            this.ignoreTypesMatchingClassNamePredicates.addAll(Arrays.asList(ignoreTypesMatchingClassNamePredicates));
            return this;
        }

        public Builder ignoreClasses(Class<?> ... ignoreClasses) {
            this.ignoreClasses.addAll(Arrays.asList(ignoreClasses));
            return this;
        }

        public Builder register(TypeCodecProvider ... typeCodecProviders) {
            this.typeCodecProviders.addAll(Arrays.asList(typeCodecProviders));
            return this;
        }

        public Builder encodeNullHandlingStrategy(EncodeNullHandlingStrategy.Strategy encodeNullHandlingStrategy) {
            if (encodeNullHandlingStrategy != null) {
                this.encodeNullHandlingStrategy = encodeNullHandlingStrategy;
            }
            return this;
        }

        public Builder decodeUndefinedHandlingStrategy(DecodeUndefinedHandlingStrategy.Strategy decodeUndefinedHandlingStrategy) {
            if (decodeUndefinedHandlingStrategy != null) {
                this.decodeUndefinedHandlingStrategy = decodeUndefinedHandlingStrategy;
            }
            return this;
        }

        public Builder encodeNulls(boolean encodeNulls) {
            this.encodeNulls = encodeNulls;
            return this;
        }

        public Builder registerCodecResolver(CodecResolver ... codecResolvers) {
            this.codecResolvers.addAll(Arrays.asList(codecResolvers));
            return this;
        }

        public PojoCodecProvider build() {
            CodecConfiguration codecConfiguration = new CodecConfiguration(this.encodeNulls, this.encodeNullHandlingStrategy, this.decodeUndefinedHandlingStrategy);
            return new PojoCodecProvider(this.classes, this.packages, this.ignoreAnnotations, this.ignoreTypesMatchingClassNamePredicates, this.ignoreClasses, this.typeCodecProviders, this.codecResolvers, codecConfiguration, this.classResolver);
        }
    }

    private static class CollectibleCodecDelegator<T>
    implements InvocationHandler,
    CollectibleCodec<T>,
    DelegatingCodec<T> {
        private final TypeCodec<T> delegatingCodec;

        public CollectibleCodecDelegator(TypeCodec<T> delegatingCodec) {
            this.delegatingCodec = delegatingCodec;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (method.getDeclaringClass() == CollectibleCodec.class || method.getDeclaringClass() == DelegatingCodec.class) {
                    return method.invoke((Object)this, args);
                }
                return method.invoke(this.delegatingCodec, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warn("An exception was caught while invoking the delegate {} with args {}", (Object)method, (Object)args);
                LOGGER.debug("Original exception when invoking target.", (Throwable)e);
                throw e.getCause();
            }
        }

        public T generateIdIfAbsentFromDocument(T document) {
            return this.delegatingCodec.generateIdIfAbsentFromDocument(document);
        }

        public boolean documentHasId(T document) {
            return this.delegatingCodec.documentHasId(document);
        }

        public BsonValue getDocumentId(T document) {
            return this.delegatingCodec.getDocumentId(document);
        }

        public T decode(BsonReader reader, DecoderContext decoderContext) {
            return (T)this.delegatingCodec.decode(reader, decoderContext);
        }

        public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
            this.delegatingCodec.encode(writer, value, encoderContext);
        }

        public Class<T> getEncoderClass() {
            return this.delegatingCodec.getEncoderClass();
        }

        @Override
        public TypeCodec<T> getDelegate() {
            return this.delegatingCodec;
        }
    }
}

