/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.AbstractTypeCodec;
import de.bild.codec.MethodTypePair;
import de.bild.codec.ReflectionHelper;
import de.bild.codec.TypeCodecRegistry;
import de.bild.codec.annotations.FieldMapping;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bson.BsonBinarySubType;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public class SpecialFieldsMapCodec<T extends Map<String, Object>>
extends AbstractTypeCodec<T> {
    final Map<String, Codec> fieldMappingCodecs = new HashMap<String, Codec>();
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP = new BsonTypeClassMap();
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final CodecRegistry codecRegistry;

    public SpecialFieldsMapCodec(Type type, TypeCodecRegistry typeCodecRegistry) {
        super(type, typeCodecRegistry);
        this.codecRegistry = typeCodecRegistry.getRegistry();
        for (MethodTypePair methodTypePair : ReflectionHelper.getDeclaredAndInheritedMethods(type)) {
            Method method = methodTypePair.getMethod();
            FieldMapping fieldMapping = method.getAnnotation(FieldMapping.class);
            if (fieldMapping == null) continue;
            this.fieldMappingCodecs.put(fieldMapping.value(), typeCodecRegistry.getCodec(methodTypePair.getRealType()));
        }
        this.bsonTypeCodecMap = new BsonTypeCodecMap(DEFAULT_BSON_TYPE_CLASS_MAP, typeCodecRegistry.getRegistry());
    }

    public T decode(BsonReader reader, DecoderContext decoderContext) {
        Map map = (Map)this.newInstance();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String key = reader.readName();
            Codec fieldMappingCodec = this.fieldMappingCodecs.get(key);
            Object value = fieldMappingCodec != null ? fieldMappingCodec.decode(reader, decoderContext) : this.readValue(reader, decoderContext);
            map.put(key, value);
        }
        reader.readEndDocument();
        return (T)map;
    }

    private Object readValue(BsonReader reader, DecoderContext decoderContext) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        if (bsonType == BsonType.ARRAY) {
            return this.readList(reader, decoderContext);
        }
        if (bsonType == BsonType.BINARY && BsonBinarySubType.isUuid((byte)reader.peekBinarySubType()) && reader.peekBinarySize() == 16) {
            return this.codecRegistry.get(UUID.class).decode(reader, decoderContext);
        }
        return this.bsonTypeCodecMap.get(bsonType).decode(reader, decoderContext);
    }

    private List<Object> readList(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList<Object> list = new ArrayList<Object>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            list.add(this.readValue(reader, decoderContext));
        }
        reader.readEndArray();
        return list;
    }

    public void encode(BsonWriter writer, T map, EncoderContext encoderContext) {
        if (map == null) {
            writer.writeNull();
        } else {
            this.encodeMap(writer, (Map<String, Object>)map, encoderContext);
        }
    }

    private void encodeMap(BsonWriter writer, Map<String, Object> map, EncoderContext encoderContext) {
        writer.writeStartDocument();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            writer.writeName(entry.getKey());
            Object value = entry.getValue();
            Codec fieldMappingCodec = this.fieldMappingCodecs.get(entry.getKey());
            if (fieldMappingCodec != null) {
                fieldMappingCodec.encode(writer, value, encoderContext);
                continue;
            }
            this.encodeValue(writer, encoderContext, value);
        }
        writer.writeEndDocument();
    }

    private void encodeValue(BsonWriter writer, EncoderContext encoderContext, Object value) {
        if (value == null) {
            writer.writeNull();
        } else if (value instanceof Iterable) {
            this.writeIterable(writer, (Iterable)value, encoderContext);
        } else if (value instanceof Map) {
            this.encodeMap(writer, (Map)value, encoderContext);
        } else {
            Codec codec = this.codecRegistry.get(value.getClass());
            codec.encode(writer, value, encoderContext);
        }
    }

    private void writeIterable(BsonWriter writer, Iterable<Object> list, EncoderContext encoderContext) {
        writer.writeStartArray();
        for (Object value : list) {
            this.encodeValue(writer, encoderContext, value);
        }
        writer.writeEndArray();
    }
}

