/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import java.util.UUID;
import org.bson.BsonBinarySubType;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.Transformer;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public class ObjectCodec<T>
implements Codec<T> {
    private final Class<T> clazz;
    private final CodecRegistry registry;
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final Transformer valueTransformer;

    public ObjectCodec(Class<T> clazz, CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap) {
        this(clazz, registry, bsonTypeClassMap, null);
    }

    public ObjectCodec(Class<T> clazz, CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer) {
        this.clazz = clazz;
        this.registry = (CodecRegistry)Assertions.notNull((String)"registry", (Object)registry);
        this.bsonTypeCodecMap = new BsonTypeCodecMap((BsonTypeClassMap)Assertions.notNull((String)"bsonTypeClassMap", (Object)bsonTypeClassMap), registry);
        this.valueTransformer = valueTransformer != null ? valueTransformer : new Transformer(){

            public Object transform(Object objectToTransform) {
                return objectToTransform;
            }
        };
    }

    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        if (value == null) {
            writer.writeNull();
            return;
        }
        Codec encoder = this.registry.get(value.getClass());
        if (encoder == null) {
            throw new UnsupportedOperationException(value.getClass().toString());
        }
        encoderContext.encodeWithChildContext((Encoder)encoder, writer, value);
    }

    public Class<T> getEncoderClass() {
        return this.clazz;
    }

    public T decode(BsonReader reader, DecoderContext decoderContext) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        Codec decoder = bsonType == BsonType.BINARY && BsonBinarySubType.isUuid((byte)reader.peekBinarySubType()) && reader.peekBinarySize() == 16 ? this.registry.get(UUID.class) : this.bsonTypeCodecMap.get(bsonType);
        if (decoder == null) {
            throw new UnsupportedOperationException(bsonType.toString());
        }
        return this.clazz.cast(this.valueTransformer.transform(decoderContext.decodeWithChildContext((Decoder)decoder, reader)));
    }
}

