/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.algorithms.superimposition;

import de.bioforscher.singa.chemistry.algorithms.superimposition.SubStructureSuperimpositionException;
import de.bioforscher.singa.chemistry.algorithms.superimposition.SubstructureSuperimposition;
import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.atoms.representations.RepresentationScheme;
import de.bioforscher.singa.chemistry.physical.atoms.representations.RepresentationSchemeType;
import de.bioforscher.singa.chemistry.physical.branches.BranchSubstructure;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntityFilter;
import de.bioforscher.singa.chemistry.physical.model.Substructure;
import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.mathematics.algorithms.superimposition.VectorSuperimposer;
import de.bioforscher.singa.mathematics.algorithms.superimposition.VectorSuperimposition;
import de.bioforscher.singa.mathematics.combinatorics.StreamPermutations;
import de.bioforscher.singa.mathematics.concepts.Addable;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.matrices.Matrix;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubStructureSuperimposer {
    private static final Logger logger = LoggerFactory.getLogger(SubstructureSuperimposition.class);
    private static final Predicate<Atom> DEFAULT_ATOM_FILTER = StructuralEntityFilter.AtomFilter.isArbitrary();
    private final Predicate<Atom> atomFilter;
    private final RepresentationScheme representationScheme;
    private final List<LeafSubstructure<?, ?>> reference;
    private final List<LeafSubstructure<?, ?>> candidate;
    private double rmsd;
    private Vector translation;
    private Matrix rotation;

    private SubStructureSuperimposer(BranchSubstructure reference, BranchSubstructure candidate) {
        this(reference, candidate, StructuralEntityFilter.AtomFilter.isArbitrary(), null);
    }

    private SubStructureSuperimposer(BranchSubstructure<?> reference, BranchSubstructure<?> candidate, Predicate<Atom> atomFilter, RepresentationScheme representationScheme) {
        this.reference = reference.getLeafSubstructures();
        this.candidate = candidate.getLeafSubstructures();
        this.atomFilter = atomFilter;
        this.representationScheme = representationScheme;
        if (this.reference.size() != this.candidate.size() || this.reference.isEmpty() || this.candidate.isEmpty()) {
            throw new IllegalArgumentException("Two lists of substructures cannot be superimposed if they differ in size.");
        }
    }

    private SubStructureSuperimposer(List<LeafSubstructure<?, ?>> reference, List<LeafSubstructure<?, ?>> candidate, Predicate<Atom> atomFilter, RepresentationScheme representationScheme) {
        this.reference = reference;
        this.candidate = candidate;
        this.atomFilter = atomFilter;
        this.representationScheme = representationScheme;
    }

    private SubStructureSuperimposer(List<LeafSubstructure<?, ?>> reference, List<LeafSubstructure<?, ?>> candidate) {
        this(reference, candidate, DEFAULT_ATOM_FILTER, null);
    }

    public SubStructureSuperimposer(List<LeafSubstructure<?, ?>> reference, List<LeafSubstructure<?, ?>> candidate, RepresentationScheme representationScheme) {
        this(reference, candidate, DEFAULT_ATOM_FILTER, representationScheme);
    }

    public static SubstructureSuperimposition calculateIdealSubstructureSuperimposition(List<LeafSubstructure<?, ?>> reference, List<LeafSubstructure<?, ?>> candidate) {
        return new SubStructureSuperimposer(reference, candidate).calculateIdealSuperimposition();
    }

    public static SubstructureSuperimposition calculateIdealSubstructureSuperimposition(List<LeafSubstructure<?, ?>> reference, List<LeafSubstructure<?, ?>> candidate, Predicate<Atom> atomFilter) {
        return new SubStructureSuperimposer(reference, candidate, atomFilter, null).calculateIdealSuperimposition();
    }

    public static SubstructureSuperimposition calculateIdealSubstructureSuperimposition(List<LeafSubstructure<?, ?>> reference, List<LeafSubstructure<?, ?>> candidate, RepresentationScheme representationScheme) {
        return new SubStructureSuperimposer(reference, candidate, DEFAULT_ATOM_FILTER, representationScheme).calculateIdealSuperimposition();
    }

    public static SubstructureSuperimposition calculateIdealSubstructureSuperimposition(BranchSubstructure reference, BranchSubstructure candidate) {
        return new SubStructureSuperimposer(reference, candidate).calculateIdealSuperimposition();
    }

    public static SubstructureSuperimposition calculateIdealSubstructureSuperimposition(BranchSubstructure reference, BranchSubstructure candidate, Predicate<Atom> atomFilter) {
        return new SubStructureSuperimposer(reference, candidate, atomFilter, null).calculateIdealSuperimposition();
    }

    public static SubstructureSuperimposition calculateIdealSubstructureSuperimposition(BranchSubstructure reference, BranchSubstructure candidate, RepresentationScheme representationScheme) {
        return new SubStructureSuperimposer(reference, candidate, DEFAULT_ATOM_FILTER, representationScheme).calculateIdealSuperimposition();
    }

    public static SubstructureSuperimposition calculateSubstructureSuperimposition(List<LeafSubstructure<?, ?>> reference, List<LeafSubstructure<?, ?>> candidate) throws SubStructureSuperimpositionException {
        return new SubStructureSuperimposer(reference, candidate).calculateSuperimposition();
    }

    public static SubstructureSuperimposition calculateSubstructureSuperimposition(List<LeafSubstructure<?, ?>> reference, List<LeafSubstructure<?, ?>> candidate, Predicate<Atom> atomFilter) throws SubStructureSuperimpositionException {
        return new SubStructureSuperimposer(reference, candidate, atomFilter, null).calculateSuperimposition();
    }

    public static SubstructureSuperimposition calculateSubstructureSuperimposition(List<LeafSubstructure<?, ?>> reference, List<LeafSubstructure<?, ?>> candidate, RepresentationScheme representationScheme) throws SubStructureSuperimpositionException {
        return new SubStructureSuperimposer(reference, candidate, representationScheme).calculateSuperimposition();
    }

    public static SubstructureSuperimposition calculateSubstructureSuperimposition(BranchSubstructure reference, BranchSubstructure candidate) throws SubStructureSuperimpositionException {
        return new SubStructureSuperimposer(reference, candidate).calculateSuperimposition();
    }

    public static SubstructureSuperimposition calculateSubstructureSuperimposition(BranchSubstructure reference, BranchSubstructure candidate, Predicate<Atom> atomFilter) throws SubStructureSuperimpositionException {
        return new SubStructureSuperimposer(reference, candidate, atomFilter, null).calculateSuperimposition();
    }

    public static SubstructureSuperimposition calculateSubstructureSuperimposition(BranchSubstructure reference, BranchSubstructure candidate, RepresentationScheme representationScheme) throws SubStructureSuperimpositionException {
        return new SubStructureSuperimposer(reference, candidate, DEFAULT_ATOM_FILTER, representationScheme).calculateSuperimposition();
    }

    private String toAlignmentString(Map<Pair<LeafSubstructure<?, ?>>, Set<String>> perAtomAlignment) {
        StringJoiner referenceNameJoiner = new StringJoiner("|", "|", "|");
        perAtomAlignment.keySet().forEach(pair -> referenceNameJoiner.add(String.format("%-50s", ((LeafSubstructure)pair.getFirst()).toString())));
        StringJoiner atomNameJoiner = new StringJoiner("|", "|", "|");
        if (this.representationScheme == null) {
            perAtomAlignment.values().forEach(atomNames -> atomNameJoiner.add(String.format("%-50s", atomNames.stream().sorted().collect(Collectors.joining("-")))));
        } else {
            perAtomAlignment.values().forEach(atomNames -> atomNameJoiner.add(String.format("%-50s", new Object[]{Stream.of(RepresentationSchemeType.values()).filter(representationSchemeType -> representationSchemeType.getCompatibleRepresentationScheme().isInstance(this.representationScheme)).findAny().orElse(RepresentationSchemeType.CA)})));
        }
        StringJoiner candidateNameJoiner = new StringJoiner("|", "|", "|");
        perAtomAlignment.keySet().forEach(pair -> candidateNameJoiner.add(String.format("%-50s", ((LeafSubstructure)pair.getSecond()).toString())));
        StringJoiner alignmentJoiner = new StringJoiner("\n", "\n", "");
        alignmentJoiner.add(referenceNameJoiner.toString());
        alignmentJoiner.add(atomNameJoiner.toString());
        alignmentJoiner.add(candidateNameJoiner.toString());
        return alignmentJoiner.toString();
    }

    private SubstructureSuperimposition calculateIdealSuperimposition() throws SubStructureSuperimpositionException {
        Optional<SubstructureSuperimposition> optionalSuperimposition = ((Stream)StreamPermutations.of((Object[])this.candidate.toArray(new LeafSubstructure[this.candidate.size()])).parallel()).map(s -> s.collect(Collectors.toList())).map(permutedCandidates -> {
            try {
                return new SubStructureSuperimposer(this.reference, (List<LeafSubstructure<?, ?>>)permutedCandidates, this.atomFilter, this.representationScheme).calculateSuperimposition();
            }
            catch (SubStructureSuperimpositionException e) {
                logger.error("failed to calculate substructure superimposition", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).reduce((s1, s2) -> s1.getRmsd() < s2.getRmsd() ? s1 : s2);
        return optionalSuperimposition.orElseThrow(() -> new SubStructureSuperimpositionException("no ideal superimposition found"));
    }

    private SubstructureSuperimposition calculateSuperimposition() throws SubStructureSuperimpositionException {
        List candidateAtoms;
        List referenceAtoms;
        LinkedHashMap perAtomAlignment = new LinkedHashMap();
        IntStream.range(0, this.reference.size()).forEach(i -> {
            Set cfr_ignored_0 = perAtomAlignment.put(new Pair(this.reference.get(i), this.candidate.get(i)), new HashSet());
        });
        perAtomAlignment.entrySet().forEach(this::defineIntersectingAtoms);
        if (this.representationScheme == null) {
            referenceAtoms = perAtomAlignment.entrySet().stream().flatMap(pairSetEntry -> ((LeafSubstructure)((Pair)pairSetEntry.getKey()).getFirst()).getAllAtoms().stream().filter(this.atomFilter).filter(atom -> ((Set)pairSetEntry.getValue()).contains(atom.getAtomNameString())).sorted(Comparator.comparing(Atom::getAtomNameString))).collect(Collectors.toList());
            candidateAtoms = perAtomAlignment.entrySet().stream().flatMap(pairSetEntry -> ((LeafSubstructure)((Pair)pairSetEntry.getKey()).getSecond()).getAllAtoms().stream().filter(this.atomFilter).filter(atom -> ((Set)pairSetEntry.getValue()).contains(atom.getAtomNameString())).sorted(Comparator.comparing(Atom::getAtomNameString))).collect(Collectors.toList());
        } else {
            referenceAtoms = perAtomAlignment.entrySet().stream().map(pairSetEntry -> (LeafSubstructure)((Pair)pairSetEntry.getKey()).getFirst()).map(this.representationScheme::determineRepresentingAtom).collect(Collectors.toList());
            candidateAtoms = perAtomAlignment.entrySet().stream().map(pairSetEntry -> (LeafSubstructure)((Pair)pairSetEntry.getKey()).getSecond()).map(this.representationScheme::determineRepresentingAtom).collect(Collectors.toList());
        }
        if (referenceAtoms.isEmpty() || candidateAtoms.isEmpty()) {
            throw new SubStructureSuperimpositionException("failed to collect per atom alignment sets, no compatible atoms");
        }
        VectorSuperimposition vectorSuperimposition = VectorSuperimposer.calculateVectorSuperimposition(referenceAtoms.stream().map(Node::getPosition).collect(Collectors.toList()), candidateAtoms.stream().map(Node::getPosition).collect(Collectors.toList()));
        this.translation = vectorSuperimposition.getTranslation();
        this.rotation = vectorSuperimposition.getRotation();
        this.rmsd = vectorSuperimposition.getRmsd();
        List mappedPositions = vectorSuperimposition.getMappedCandidate();
        HashMap<Integer, Integer> positionMapping = new HashMap<Integer, Integer>();
        for (int i2 = 0; i2 < mappedPositions.size(); ++i2) {
            positionMapping.put(((Atom)candidateAtoms.get(i2)).getIdentifier(), i2);
        }
        List<LeafSubstructure<?, ?>> mappedCandidate = this.candidate.stream().map(Substructure::getCopy).collect(Collectors.toList());
        List<LeafSubstructure<?, ?>> mappedFullCandidate = this.candidate.stream().map(Substructure::getCopy).collect(Collectors.toList());
        List<Integer> atomIdsToBeRemoved = mappedCandidate.stream().flatMap(subStructure -> subStructure.getAllAtoms().stream()).filter(atom -> !positionMapping.containsKey(atom.getIdentifier())).map(Node::getIdentifier).collect(Collectors.toList());
        atomIdsToBeRemoved.forEach(id -> mappedCandidate.forEach(subStructure -> subStructure.removeNode((int)id)));
        mappedCandidate.forEach(subStructure -> subStructure.getAllAtoms().forEach(atom -> atom.setPosition((Vector3D)((Vector)mappedPositions.get((Integer)positionMapping.get(atom.getIdentifier()))).as(Vector3D.class))));
        mappedFullCandidate.stream().map(Substructure::getAllAtoms).flatMap(Collection::stream).forEach(atom -> atom.setPosition((Vector3D)((Vector)this.rotation.transpose().multiply(atom.getPosition()).add((Addable)this.translation)).as(Vector3D.class)));
        logger.debug("superimposed substructures with RMSD {}{}", (Object)this.rmsd, (Object)this.toAlignmentString(perAtomAlignment));
        return new SubstructureSuperimposition(vectorSuperimposition.getRmsd(), this.translation, this.rotation, this.reference, this.candidate, mappedCandidate, mappedFullCandidate);
    }

    private void defineIntersectingAtoms(Map.Entry<Pair<LeafSubstructure<?, ?>>, Set<String>> pairListEntry) {
        pairListEntry.getValue().addAll(((LeafSubstructure)pairListEntry.getKey().getFirst()).getAllAtoms().stream().filter(this.atomFilter).map(Atom::getAtomNameString).collect(Collectors.toSet()));
        pairListEntry.getValue().retainAll(((LeafSubstructure)pairListEntry.getKey().getSecond()).getAllAtoms().stream().filter(this.atomFilter).map(Atom::getAtomNameString).collect(Collectors.toSet()));
    }
}

