/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d;

import de.bioforscher.singa.chemistry.algorithms.superimposition.SubstructureSuperimposition;
import de.bioforscher.singa.chemistry.algorithms.superimposition.XieScore;
import de.bioforscher.singa.chemistry.parser.pdb.structures.StructureWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Fit3D {
    public static final Logger logger = LoggerFactory.getLogger(Fit3D.class);

    public TreeMap<Double, SubstructureSuperimposition> getMatches();

    public double getFraction();

    public XieScore getXieScore();

    default public void writeMatches(Path outputDirectory) {
        this.getMatches().values().forEach(substructureSuperimposition -> {
            try {
                StructureWriter.writeLeafSubstructures(substructureSuperimposition.getMappedFullCandidate(), outputDirectory.resolve(substructureSuperimposition.getStringRepresentation() + ".pdb"));
            }
            catch (IOException e) {
                logger.error("could not write match {}", (Object)substructureSuperimposition.getStringRepresentation(), (Object)e);
            }
        });
    }

    default public String getAlignmentString() {
        throw new UnsupportedOperationException("unique alignment string can only be obtained with Fit3DSite algorithm");
    }
}

