/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d;

import de.bioforscher.singa.chemistry.algorithms.superimposition.SubStructureSuperimposer;
import de.bioforscher.singa.chemistry.algorithms.superimposition.SubstructureSuperimposition;
import de.bioforscher.singa.chemistry.algorithms.superimposition.XieScore;
import de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d.Fit3D;
import de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d.Fit3DBuilder;
import de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d.Fit3DException;
import de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d.ValidAlignmentGenerator;
import de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d.ValidCandidateGenerator;
import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.atoms.representations.RepresentationScheme;
import de.bioforscher.singa.chemistry.physical.branches.BranchSubstructure;
import de.bioforscher.singa.chemistry.physical.branches.StructuralMotif;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.Exchangeable;
import de.bioforscher.singa.chemistry.physical.model.LeafIdentifier;
import de.bioforscher.singa.chemistry.physical.model.Structures;
import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import de.bioforscher.singa.mathematics.matrices.Matrices;
import de.bioforscher.singa.mathematics.vectors.RegularVector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fit3DAlignment
implements Fit3D {
    private static final Logger logger = LoggerFactory.getLogger(Fit3DAlignment.class);
    private final StructuralMotif queryMotif;
    private final BranchSubstructure<?> target;
    private final double squaredDistanceTolerance;
    private final RepresentationScheme representationScheme;
    private double squaredQueryExtent;
    private LabeledSymmetricMatrix<LeafSubstructure<?, ?>> squaredDistanceMatrix;
    private List<List<LeafSubstructure<?, ?>>> environments;
    private HashMap<List<LeafSubstructure<?, ?>>, Set<Set<LeafSubstructure<?, ?>>>> candidates;
    private double rmsdCutoff;
    private TreeMap<Double, SubstructureSuperimposition> matches;
    private Predicate<Atom> atomFilter;

    Fit3DAlignment(Fit3DBuilder.Builder builder) {
        this.queryMotif = builder.queryMotif.getCopy();
        this.target = (BranchSubstructure)builder.target.getCopy();
        this.rmsdCutoff = builder.rmsdCutoff;
        this.squaredDistanceTolerance = builder.distanceTolerance * builder.distanceTolerance;
        this.atomFilter = builder.atomFilter;
        this.representationScheme = builder.representationScheme;
        if (this.queryMotif.size() > this.target.getLeafSubstructures().size()) {
            throw new Fit3DException("search target " + this.target + " must contain at least as many atom-containing substructures as the query motif");
        }
        this.environments = new ArrayList();
        this.matches = new TreeMap();
        this.candidates = new HashMap();
        logger.debug("computing Fit3D alignment of motif {} against {}", (Object)this.queryMotif, this.target);
        this.reduceTargetStructure();
        if (this.queryMotif.size() > this.target.getLeafSubstructures().size()) {
            logger.debug("reduced target structure smaller than query motif, no matches can be found");
            return;
        }
        this.calculateMotifExtent();
        this.squaredDistanceMatrix = this.target.getSquaredDistanceMatrix();
        logger.debug("the target structure squared distance matrix is\n{}", (Object)this.squaredDistanceMatrix.getStringRepresentation());
        this.composeEnvironments();
        this.generateCandidates();
        this.computeMatches();
    }

    @Override
    public TreeMap<Double, SubstructureSuperimposition> getMatches() {
        return this.matches;
    }

    @Override
    public double getFraction() {
        return 1.0;
    }

    @Override
    public XieScore getXieScore() {
        throw new UnsupportedOperationException("Xie score can only be calculate for Fit3DSiteAlignment");
    }

    private void computeMatches() {
        this.candidates.values().stream().flatMap(Collection::stream).forEach(this::computeAlignments);
    }

    private void computeAlignments(Set<LeafSubstructure<?, ?>> leafSubstructures) {
        ValidAlignmentGenerator validAlignmentGenerator = new ValidAlignmentGenerator(this.queryMotif.getLeafSubstructures(), new ArrayList(leafSubstructures));
        List<List<Pair<LeafSubstructure<?, ?>>>> validAlignments = validAlignmentGenerator.getValidAlignments();
        for (List<Pair<LeafSubstructure<?, ?>>> validAlignment : validAlignments) {
            List<LeafSubstructure<?, ?>> alignmentCandidate = validAlignment.stream().map(Pair::getSecond).collect(Collectors.toList());
            SubstructureSuperimposition superimposition = this.representationScheme != null ? SubStructureSuperimposer.calculateSubstructureSuperimposition(this.queryMotif.getLeafSubstructures(), alignmentCandidate, this.representationScheme) : SubStructureSuperimposer.calculateSubstructureSuperimposition(this.queryMotif.getLeafSubstructures(), alignmentCandidate, this.atomFilter);
            if (!(superimposition.getRmsd() <= this.rmsdCutoff)) continue;
            this.matches.put(superimposition.getRmsd(), superimposition);
        }
    }

    private void generateCandidates() {
        for (List<LeafSubstructure<?, ?>> environment : this.environments) {
            Set<Set<LeafSubstructure<?, ?>>> currentCandidates = new ValidCandidateGenerator(this.queryMotif.getLeafSubstructures(), environment).getValidCandidates();
            this.candidates.put(environment, currentCandidates);
        }
    }

    public List<List<LeafSubstructure<?, ?>>> getEnvironments() {
        return this.environments;
    }

    private void calculateMotifExtent() {
        LabeledSymmetricMatrix<LeafSubstructure<?, ?>> queryDistanceMatrix = Structures.calculateSquaredDistanceMatrix(this.queryMotif);
        Pair positionOfMaximalElement = (Pair)Matrices.getPositionsOfMaximalElement(queryDistanceMatrix).stream().findFirst().orElseThrow(() -> new Fit3DException("could not determine extent of the query motif"));
        this.squaredQueryExtent = queryDistanceMatrix.getElement(((Integer)positionOfMaximalElement.getFirst()).intValue(), ((Integer)positionOfMaximalElement.getSecond()).intValue());
        logger.debug("the squared query motif extent is {}", (Object)this.squaredQueryExtent);
    }

    private void reduceTargetStructure() {
        Set containingTypes = this.queryMotif.getLeafSubstructures().stream().map(Exchangeable::getContainingFamilies).flatMap(Collection::stream).collect(Collectors.toSet());
        List<LeafIdentifier> toBeRemoved = this.target.getLeafSubstructures().stream().filter(leafSubstructure -> !containingTypes.contains(leafSubstructure.getFamily())).map(LeafSubstructure::getLeafIdentifier).collect(Collectors.toList());
        toBeRemoved.forEach(this.target::removeLeafSubstructure);
    }

    private void composeEnvironments() {
        for (LeafSubstructure<?, ?> currentSubstructure : this.target.getLeafSubstructures()) {
            RegularVector distanceToOthers = this.squaredDistanceMatrix.getColumnByLabel(currentSubstructure);
            ArrayList<Object> environment = new ArrayList<Object>();
            for (int i = 0; i < distanceToOthers.getElements().length; ++i) {
                double currentDistance = distanceToOthers.getElement(i);
                if (!(currentDistance <= this.squaredQueryExtent + this.squaredDistanceTolerance)) continue;
                environment.add(this.squaredDistanceMatrix.getColumnLabel(i));
            }
            if (environment.size() < this.queryMotif.size()) continue;
            logger.debug("possible environment {} within {} around {} added", new Object[]{environment, Math.sqrt(this.squaredQueryExtent + this.squaredDistanceTolerance), currentSubstructure});
            this.environments.add(environment);
        }
    }
}

