/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d;

import de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d.ValidAlignmentGenerator;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.Substructure;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidCandidateGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ValidAlignmentGenerator.class);
    private List<LeafSubstructure<?, ?>> queryMotif;
    private List<LeafSubstructure<?, ?>> environment;
    private List<List<LeafSubstructure<?, ?>>> acceptedElementsAtEachPosition;
    private Set<Set<LeafSubstructure<?, ?>>> candidates;

    public ValidCandidateGenerator(List<LeafSubstructure<?, ?>> queryMotif, List<LeafSubstructure<?, ?>> environment) {
        this.queryMotif = queryMotif;
        this.environment = environment;
        if (environment.size() < queryMotif.size()) {
            throw new IllegalArgumentException("environment cannot be smaller than query motif");
        }
    }

    public Set<Set<LeafSubstructure<?, ?>>> getValidCandidates() {
        this.acceptedElementsAtEachPosition = new ArrayList();
        for (LeafSubstructure<?, ?> currentLeafSubstructure : this.queryMotif) {
            Set typesAtPosition = currentLeafSubstructure.getContainingFamilies();
            List validLeafSubstructures = this.environment.stream().filter(leafSubstructure -> typesAtPosition.contains(leafSubstructure.getFamily())).collect(Collectors.toList());
            this.acceptedElementsAtEachPosition.add(validLeafSubstructures);
        }
        logger.trace("accepted elements at each position are\n{}", (Object)this.acceptedElementsAtEachPosition.stream().map(position -> position.stream().map(LeafSubstructure::toString).collect(Collectors.joining("\t", "[", "]"))).collect(Collectors.joining("\n")));
        this.candidates = new HashSet();
        this.candidates.add(new HashSet());
        int position2 = 0;
        while (position2 < this.queryMotif.size()) {
            int currentPosition = position2++;
            this.candidates = this.candidates.stream().flatMap(candidate -> this.acceptedElementsAtEachPosition.get(currentPosition).stream().map(acceptedElement -> {
                Set<LeafSubstructure<?, ?>> newCandidate = this.cloneSet((Set<LeafSubstructure<?, ?>>)candidate);
                newCandidate.add((LeafSubstructure<?, ?>)acceptedElement);
                return newCandidate;
            })).filter(candidate -> new HashSet(candidate).size() == currentPosition + 1).collect(Collectors.toSet());
        }
        if (this.candidates.isEmpty()) {
            logger.trace("no valid candidates");
        } else {
            logger.trace("candidates are\n{}", (Object)this.candidates.stream().map(candidate -> candidate.stream().map(LeafSubstructure::toString).collect(Collectors.joining("\t", "[", "]"))).collect(Collectors.joining("\n")));
        }
        return this.candidates;
    }

    private Set<LeafSubstructure<?, ?>> cloneSet(Set<LeafSubstructure<?, ?>> leafSubstructures) {
        return leafSubstructures.stream().map(Substructure::getCopy).collect(Collectors.toSet());
    }
}

