/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.entities;

import de.bioforscher.singa.chemistry.descriptive.annotations.Annotatable;
import de.bioforscher.singa.chemistry.descriptive.annotations.Annotation;
import de.bioforscher.singa.chemistry.descriptive.annotations.AnnotationType;
import de.bioforscher.singa.chemistry.descriptive.features.diffusivity.Diffusivity;
import de.bioforscher.singa.chemistry.descriptive.features.molarmass.MolarMass;
import de.bioforscher.singa.core.identifier.model.Identifiable;
import de.bioforscher.singa.core.identifier.model.Identifier;
import de.bioforscher.singa.core.utility.Nameable;
import de.bioforscher.singa.features.model.Feature;
import de.bioforscher.singa.features.model.FeatureContainer;
import de.bioforscher.singa.features.model.Featureable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ChemicalEntity<IdentifierType extends Identifier>
implements Identifiable<IdentifierType>,
Nameable,
Annotatable,
Featureable {
    private final IdentifierType identifier;
    private String name = "Unnamed chemical entity";
    private List<Annotation> annotations;
    private FeatureContainer features;
    protected final Set<Class<? extends Feature>> availableFeatures;

    protected ChemicalEntity(IdentifierType identifier) {
        this.identifier = identifier;
        this.annotations = new ArrayList<Annotation>();
        this.features = new FeatureContainer();
        this.availableFeatures = new HashSet<Class<? extends Feature>>();
        this.availableFeatures.add(Diffusivity.class);
        this.availableFeatures.add(MolarMass.class);
    }

    public IdentifierType getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void addAdditionalName(String additionalName) {
        this.addAnnotation(new Annotation<String>(AnnotationType.ADDITIONAL_NAME, additionalName));
    }

    public List<String> getAdditionalNames() {
        return this.getContentOfAnnotations(String.class, AnnotationType.ADDITIONAL_NAME);
    }

    public void addAdditionalIdentifiers(Collection<Identifier> identifiers) {
        identifiers.forEach(this::addAdditionalIdentifier);
    }

    public void addAdditionalIdentifier(Identifier identifier) {
        this.addAnnotation(new Annotation<Identifier>(AnnotationType.ADDITIONAL_IDENTIFIER, identifier));
    }

    public List<Identifier> getAdditionalIdentifiers() {
        return this.getContentOfAnnotations(Identifier.class, AnnotationType.ADDITIONAL_IDENTIFIER);
    }

    public <FeatureType extends Feature> FeatureType getFeature(Class<FeatureType> featureTypeClass) {
        return (FeatureType)this.features.getFeature(featureTypeClass);
    }

    public <FeatureType extends Feature> void setFeature(Class<FeatureType> featureTypeClass) {
        this.features.setFeature(featureTypeClass, (Featureable)this);
    }

    public <FeatureType extends Feature> void setFeature(FeatureType feature) {
        this.features.setFeature(feature);
    }

    public <FeatureType extends Feature> boolean hasFeature(Class<FeatureType> featureTypeClass) {
        return this.features.hasFeature(featureTypeClass);
    }

    public Set<Class<? extends Feature>> getAvailableFeatures() {
        return this.availableFeatures;
    }

    public List<Identifier> getAllIdentifiers() {
        List<Identifier> identifiers = this.getAdditionalIdentifiers();
        identifiers.add((Identifier)this.identifier);
        return identifiers;
    }

    public String toString() {
        return "ChemicalEntity{identifier=" + this.identifier + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChemicalEntity that = (ChemicalEntity)o;
        return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
    }

    public int hashCode() {
        return this.identifier != null ? this.identifier.hashCode() : 0;
    }

    public static abstract class Builder<TopLevelType extends ChemicalEntity<?>, BuilderType extends Builder, IdentifierType extends Identifier> {
        TopLevelType topLevelObject;
        BuilderType builderObject;

        public Builder(IdentifierType identifier) {
            this.topLevelObject = this.createObject(identifier);
            this.builderObject = this.getBuilder();
        }

        protected abstract TopLevelType createObject(IdentifierType var1);

        protected abstract BuilderType getBuilder();

        public BuilderType name(String name) {
            ((ChemicalEntity)this.topLevelObject).setName(name);
            return this.builderObject;
        }

        public BuilderType assignFeature(Feature feature) {
            ((ChemicalEntity)this.topLevelObject).setFeature((Feature)feature);
            return this.builderObject;
        }

        public BuilderType additionalIdentifier(Identifier identifier) {
            ((ChemicalEntity)this.topLevelObject).addAdditionalIdentifier(identifier);
            return this.builderObject;
        }

        public BuilderType additionalIdentifiers(Collection<Identifier> identifiers) {
            ((ChemicalEntity)this.topLevelObject).addAdditionalIdentifiers(identifiers);
            return this.builderObject;
        }

        public BuilderType annotation(Annotation annotation) {
            this.topLevelObject.addAnnotation(annotation);
            return this.builderObject;
        }

        public TopLevelType build() {
            return this.topLevelObject;
        }
    }
}

