/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.entities;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.chemistry.descriptive.entities.Protein;
import de.bioforscher.singa.chemistry.descriptive.entities.Species;
import de.bioforscher.singa.chemistry.descriptive.features.molarmass.MolarMass;
import de.bioforscher.singa.core.identifier.SimpleStringIdentifier;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.features.quantities.ReactionRate;
import de.bioforscher.singa.features.units.UnitProvider;
import java.util.ArrayList;
import java.util.List;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.units.ri.quantity.Quantities;

public class Enzyme
extends Protein {
    private Quantity<MolarConcentration> michaelisConstant;
    private Quantity<ReactionRate> turnoverNumber;
    private List<Species> substrates;

    protected Enzyme(SimpleStringIdentifier identifier) {
        super(identifier);
    }

    public Quantity<ReactionRate> getTurnoverNumber() {
        return this.turnoverNumber;
    }

    public void setTurnoverNumber(double turnoverNumber) {
        this.turnoverNumber = Quantities.getQuantity((Number)turnoverNumber, (Unit)UnitProvider.PER_SECOND);
    }

    public void setTurnoverNumber(Quantity<ReactionRate> turnoverNumber) {
        this.turnoverNumber = turnoverNumber;
    }

    public Quantity<MolarConcentration> getMichaelisConstant() {
        return this.michaelisConstant;
    }

    public void setMichaelisConstant(double michaelisConstant) {
        this.michaelisConstant = Quantities.getQuantity((Number)michaelisConstant, (Unit)UnitProvider.MOLE_PER_LITRE);
    }

    public void setMichaelisConstant(Quantity<MolarConcentration> michaelisConstant) {
        this.michaelisConstant = michaelisConstant;
    }

    public List<Species> getSubstrates() {
        return this.substrates;
    }

    public void setSubstrates(List<Species> substrates) {
        this.substrates = substrates;
    }

    @Override
    public String toString() {
        return "Enzyme: " + this.getIdentifier() + " " + this.getName() + " weight: " + (Object)((Object)this.getFeature(MolarMass.class));
    }

    public static class Builder
    extends ChemicalEntity.Builder<Enzyme, Builder, SimpleStringIdentifier> {
        public Builder(SimpleStringIdentifier identifier) {
            super(identifier);
            ((Enzyme)this.topLevelObject).setSubstrates(new ArrayList<Species>());
        }

        public Builder(String identifier) {
            this(new SimpleStringIdentifier(identifier));
        }

        @Override
        protected Enzyme createObject(SimpleStringIdentifier primaryIdentifer) {
            return new Enzyme(primaryIdentifer);
        }

        @Override
        protected Builder getBuilder() {
            return this;
        }

        public Builder substrates(List<Species> substrates) {
            ((Enzyme)this.topLevelObject).setSubstrates(substrates);
            return this;
        }

        public Builder addSubstrate(Species substrate) {
            ((Enzyme)this.topLevelObject).getSubstrates().add(substrate);
            return this;
        }

        public Builder turnoverNumber(Quantity<ReactionRate> turnoverNumber) {
            ((Enzyme)this.topLevelObject).setTurnoverNumber(turnoverNumber);
            return this;
        }

        public Builder turnoverNumber(double turnoverNumber) {
            ((Enzyme)this.topLevelObject).setTurnoverNumber(turnoverNumber);
            return this;
        }

        public Builder michaelisConstant(double michaelisConstant) {
            ((Enzyme)this.topLevelObject).setMichaelisConstant(michaelisConstant);
            return this;
        }

        public Builder michaelisConstant(Quantity<MolarConcentration> michaelisConstant) {
            ((Enzyme)this.topLevelObject).setMichaelisConstant(michaelisConstant);
            return this;
        }
    }
}

