/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.estimations;

import de.bioforscher.singa.chemistry.descriptive.elements.Element;
import de.bioforscher.singa.chemistry.descriptive.molecules.MoleculeAtom;
import de.bioforscher.singa.chemistry.descriptive.molecules.MoleculeBond;
import de.bioforscher.singa.chemistry.descriptive.molecules.MoleculeBondType;
import de.bioforscher.singa.chemistry.descriptive.molecules.MoleculeGraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;

public class MoleculePathFinder {
    private MoleculeGraph graph;
    private List<LinkedList<MoleculeAtom>> candidates;

    private MoleculePathFinder(MoleculeGraph molecule) {
        this.graph = molecule;
        this.candidates = new LinkedList<LinkedList<MoleculeAtom>>();
    }

    public static List<LinkedList<MoleculeAtom>> findPathInMolecule(MoleculeGraph molecule, LinkedList<Element> path) {
        MoleculePathFinder pathFinder = new MoleculePathFinder(molecule);
        pathFinder.initializeCandidates(pathFinder.findStartingPoints(path));
        pathFinder.findAllCandidates(path);
        pathFinder.cleanCandidates();
        return pathFinder.candidates;
    }

    public static List<LinkedList<MoleculeAtom>> findMultiPathInMolecule(MoleculeGraph molecule, LinkedList<Set<Element>> multiPath) {
        MoleculePathFinder pathFinder = new MoleculePathFinder(molecule);
        pathFinder.initializeCandidates(pathFinder.findStartingPointsForMultiPath(multiPath));
        pathFinder.findAllCandidatesForMultiPath(multiPath);
        pathFinder.cleanCandidates();
        return pathFinder.candidates;
    }

    public static List<LinkedList<MoleculeBond>> findAromaticPath(MoleculeGraph molecule) {
        MoleculePathFinder pathFinder = new MoleculePathFinder(molecule);
        List aromaticBonds = pathFinder.graph.getEdges().stream().filter(bond -> bond.getType() == MoleculeBondType.AROMATIC_BOND).collect(Collectors.toList());
        ArrayList<LinkedList<MoleculeBond>> continuousAromaticPaths = new ArrayList<LinkedList<MoleculeBond>>();
        while (!aromaticBonds.isEmpty()) {
            ListIterator iterator = aromaticBonds.listIterator();
            LinkedList candidate = new LinkedList();
            candidate.add(iterator.next());
            iterator.remove();
            continuousAromaticPaths.add(candidate);
            boolean added = true;
            while (added) {
                iterator = aromaticBonds.listIterator();
                added = false;
                while (iterator.hasNext()) {
                    MoleculeBond nextBond = (MoleculeBond)((Object)iterator.next());
                    MoleculeBond first = (MoleculeBond)((Object)candidate.getFirst());
                    MoleculeBond last = (MoleculeBond)((Object)candidate.getLast());
                    if (last != first && (first.containsNode(nextBond.getSource()) || first.containsNode(nextBond.getTarget()))) {
                        candidate.addFirst(nextBond);
                        added = true;
                        iterator.remove();
                        continue;
                    }
                    if (!last.containsNode(nextBond.getSource()) && !last.containsNode(nextBond.getTarget())) continue;
                    candidate.addLast(nextBond);
                    added = true;
                    iterator.remove();
                }
            }
        }
        return continuousAromaticPaths;
    }

    private void initializeCandidates(List<MoleculeAtom> startingPoints) {
        for (MoleculeAtom startingPoint : startingPoints) {
            LinkedList<MoleculeAtom> candidate = new LinkedList<MoleculeAtom>();
            candidate.add(startingPoint);
            this.candidates.add(candidate);
        }
    }

    private List<MoleculeAtom> findStartingPoints(LinkedList<Element> path) {
        return this.graph.getNodes().stream().filter(MoleculeGraph.isElement(path.getFirst())).collect(Collectors.toList());
    }

    private List<MoleculeAtom> findStartingPointsForMultiPath(LinkedList<Set<Element>> multiPath) {
        return this.graph.getNodes().stream().filter(MoleculeGraph.isOneOfElements(multiPath.getFirst())).collect(Collectors.toList());
    }

    private void findAllCandidates(LinkedList<Element> path) {
        Iterator pathIterator = path.iterator();
        pathIterator.next();
        int iteration = 1;
        while (pathIterator.hasNext()) {
            Element nextElement = (Element)pathIterator.next();
            ListIterator<LinkedList<MoleculeAtom>> candidateIterator = this.candidates.listIterator();
            while (candidateIterator.hasNext()) {
                LinkedList<MoleculeAtom> candidate = candidateIterator.next();
                if (candidate.size() != iteration) continue;
                for (MoleculeAtom neighbour : candidate.getLast().getNeighbours()) {
                    if (!neighbour.getElement().equals(nextElement) || candidate.contains((Object)neighbour)) continue;
                    LinkedList<MoleculeAtom> newCandidate = new LinkedList<MoleculeAtom>(candidate);
                    newCandidate.add(neighbour);
                    candidateIterator.add(newCandidate);
                }
            }
            this.cleanIteration(++iteration);
        }
    }

    private void findAllCandidatesForMultiPath(LinkedList<Set<Element>> path) {
        Iterator pathIterator = path.iterator();
        pathIterator.next();
        int iteration = 1;
        while (pathIterator.hasNext()) {
            Set nextElements = (Set)pathIterator.next();
            ListIterator<LinkedList<MoleculeAtom>> candidateIterator = this.candidates.listIterator();
            while (candidateIterator.hasNext()) {
                LinkedList<MoleculeAtom> candidate = candidateIterator.next();
                if (candidate.size() != iteration) continue;
                for (MoleculeAtom neighbour : candidate.getLast().getNeighbours()) {
                    if (!nextElements.contains(neighbour.getElement()) || candidate.contains((Object)neighbour)) continue;
                    LinkedList<MoleculeAtom> newCandidate = new LinkedList<MoleculeAtom>(candidate);
                    newCandidate.add(neighbour);
                    candidateIterator.add(newCandidate);
                }
            }
            this.cleanIteration(++iteration);
        }
    }

    private void cleanIteration(int iteration) {
        this.candidates.removeIf(moleculeAtoms -> moleculeAtoms.size() != iteration);
    }

    private void cleanCandidates() {
        ListIterator<LinkedList<MoleculeAtom>> candidateIterator = this.candidates.listIterator();
        HashSet<LinkedList<MoleculeAtom>> listsToRemove = new HashSet<LinkedList<MoleculeAtom>>();
        block0: while (candidateIterator.hasNext()) {
            LinkedList<MoleculeAtom> reference = candidateIterator.next();
            ListIterator<LinkedList<MoleculeAtom>> duplicateIterator = this.candidates.listIterator(candidateIterator.nextIndex());
            while (duplicateIterator.hasNext()) {
                LinkedList<MoleculeAtom> test = duplicateIterator.next();
                if (listsToRemove.contains(test) || !reference.getLast().equals((Object)test.getFirst()) || !reference.containsAll(test)) continue;
                listsToRemove.add(duplicateIterator.previous());
                continue block0;
            }
        }
        this.candidates.removeAll(listsToRemove);
    }
}

