/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.features.databases.chebi;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.chemistry.descriptive.features.molarmass.MolarMass;
import de.bioforscher.singa.chemistry.descriptive.features.smiles.Smiles;
import de.bioforscher.singa.core.identifier.ChEBIIdentifier;
import de.bioforscher.singa.core.identifier.model.Identifier;
import de.bioforscher.singa.features.model.FeatureOrigin;
import de.bioforscher.singa.features.model.Featureable;
import java.util.Optional;
import javax.measure.Quantity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tec.units.ri.quantity.Quantities;
import uk.ac.ebi.chebi.webapps.chebiWS.client.ChebiWebServiceClient;
import uk.ac.ebi.chebi.webapps.chebiWS.model.ChebiWebServiceFault_Exception;

public class ChEBIDatabase {
    private static final Logger logger = LoggerFactory.getLogger(ChEBIDatabase.class);
    public static final FeatureOrigin origin = new FeatureOrigin(FeatureOrigin.OriginType.DATABASE, "ChEBI Database", "Degtyarenko, Kirill, et al. \"ChEBI: a database and ontology for chemical entities of biological interest.\" Nucleic acids research 36.suppl 1 (2008): D344-D350.");
    private static final ChEBIDatabase instance = new ChEBIDatabase();

    public static ChEBIDatabase getInstance() {
        return instance;
    }

    public static <FeaturableType extends Featureable> MolarMass fetchMolarMass(Featureable featureable) {
        ChemicalEntity species = (ChemicalEntity)featureable;
        Optional identifier = ChEBIIdentifier.find(species.getAllIdentifiers());
        if (identifier.isPresent()) {
            ChebiWebServiceClient client = new ChebiWebServiceClient();
            try {
                double weight = ChEBIDatabase.parseMolarMass(client.getCompleteEntity(((Identifier)identifier.get()).toString()).getMass());
                if (weight != Double.NaN) {
                    Quantity quantity = Quantities.getQuantity((Number)weight, MolarMass.GRAM_PER_MOLE);
                    return new MolarMass((Quantity<MolarMass>)quantity, origin);
                }
            }
            catch (ChebiWebServiceFault_Exception e) {
                logger.warn("Can not reach Chemical Entities of Biological Interest (ChEBI) Database. Identifier {} can not be fetched.", (Object)identifier);
            }
        }
        return null;
    }

    private static double parseMolarMass(String massAsString) {
        if (massAsString != null) {
            return Double.valueOf(massAsString);
        }
        return Double.NaN;
    }

    public static <FeaturableType extends Featureable> Smiles fetchSmiles(Featureable featureable) {
        ChemicalEntity species = (ChemicalEntity)featureable;
        Optional identifier = ChEBIIdentifier.find(species.getAllIdentifiers());
        if (identifier.isPresent()) {
            ChebiWebServiceClient client = new ChebiWebServiceClient();
            try {
                String smilesString = client.getCompleteEntity(((Identifier)identifier.get()).toString()).getSmiles();
                return new Smiles(smilesString, origin);
            }
            catch (ChebiWebServiceFault_Exception e) {
                logger.warn("Can not reach Chemical Entities of Biological Interest (ChEBI) Database. Identifier {} can not be fetched.", (Object)identifier);
            }
        }
        return null;
    }
}

