/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.features.databases.pubchem;

import de.bioforscher.singa.chemistry.descriptive.annotations.Annotation;
import de.bioforscher.singa.chemistry.descriptive.annotations.AnnotationType;
import de.bioforscher.singa.chemistry.descriptive.entities.Species;
import de.bioforscher.singa.chemistry.descriptive.features.databases.pubchem.PubChemDatabase;
import de.bioforscher.singa.chemistry.descriptive.features.logp.LogP;
import de.bioforscher.singa.chemistry.descriptive.features.molarmass.MolarMass;
import de.bioforscher.singa.chemistry.descriptive.features.smiles.Smiles;
import de.bioforscher.singa.core.identifier.ChEBIIdentifier;
import de.bioforscher.singa.core.identifier.PubChemIdentifier;
import de.bioforscher.singa.core.identifier.SimpleStringIdentifier;
import de.bioforscher.singa.features.model.Feature;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class PubChemContentHandler
implements ContentHandler {
    private SimpleStringIdentifier chebiIdentifier;
    private String pubChemIdentifier;
    private String name;
    private String smilesRepresentation;
    private double molarMass;
    private double logP;
    private String currentTag = "";
    private boolean inRecordTitle;
    private boolean inRecordTitleInformation;
    private boolean inCanonicalSMILES;
    private boolean inCanonicalSMILESInformation;
    private boolean inComputedProperties;
    private boolean inMolecularWeightInformation;
    private boolean inSynonyms;
    private boolean inSynonymsInformation;
    private boolean inLogP;
    private boolean inLogPInformation;

    PubChemContentHandler() {
    }

    public Species getSpecies() {
        Species result = (Species)((Species.Builder)((Species.Builder)((Species.Builder)((Species.Builder)new Species.Builder(this.chebiIdentifier).name(this.name)).assignFeature((Feature)new MolarMass(this.molarMass, PubChemDatabase.origin))).assignFeature((Feature)new Smiles(this.smilesRepresentation, PubChemDatabase.origin))).assignFeature((Feature)new LogP(this.logP, PubChemDatabase.origin))).build();
        Annotation<PubChemIdentifier> pubChemIdentifierAnnotation = new Annotation<PubChemIdentifier>(AnnotationType.ADDITIONAL_IDENTIFIER, new PubChemIdentifier("CID:" + this.pubChemIdentifier));
        result.addAnnotation(pubChemIdentifierAnnotation);
        return result;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.currentTag) {
            case "RecordNumber": {
                this.pubChemIdentifier = new String(ch, start, length);
                break;
            }
            case "TOCHeading": {
                String value;
                switch (value = new String(ch, start, length)) {
                    case "Record Title": {
                        this.inRecordTitle = true;
                        break;
                    }
                    case "Canonical SMILES": {
                        this.inCanonicalSMILES = true;
                        break;
                    }
                    case "Computed Properties": {
                        this.inComputedProperties = true;
                        break;
                    }
                    case "Depositor-Supplied Synonyms": {
                        this.inSynonyms = true;
                        break;
                    }
                    case "LogP": {
                        this.inLogP = true;
                    }
                }
                break;
            }
            case "StringValue": {
                if (this.inRecordTitle && this.inRecordTitleInformation) {
                    this.name = new String(ch, start, length);
                    this.inRecordTitle = false;
                    this.inRecordTitleInformation = false;
                    break;
                }
                if (this.inCanonicalSMILES && this.inCanonicalSMILESInformation) {
                    this.smilesRepresentation = new String(ch, start, length);
                    this.inCanonicalSMILES = false;
                    this.inCanonicalSMILESInformation = false;
                    break;
                }
                if (this.inComputedProperties) {
                    if (!"Molecular Weight".equals(new String(ch, start, length))) break;
                    this.inMolecularWeightInformation = true;
                    break;
                }
                if (!this.inLogP || !this.inLogPInformation) break;
                String logPString = new String(ch, start, length);
                if (logPString.contains("log Kow")) {
                    String cleanedString = logPString.replaceAll("[^0-9.]", "");
                    this.logP = Double.parseDouble(cleanedString);
                    this.inLogP = false;
                    this.inLogPInformation = false;
                    break;
                }
                if (!logPString.matches("[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?")) break;
                this.logP = Double.parseDouble(logPString);
                this.inLogP = false;
                this.inLogPInformation = false;
                break;
            }
            case "StringValueList": {
                String potentialChebiIdentifier;
                if (!this.inSynonyms || !this.inSynonymsInformation || !ChEBIIdentifier.PATTERN.matcher(potentialChebiIdentifier = new String(ch, start, length)).matches()) break;
                this.chebiIdentifier = new SimpleStringIdentifier(potentialChebiIdentifier);
                this.inSynonyms = false;
                this.inSynonymsInformation = false;
                break;
            }
            case "NumValue": {
                if (this.inComputedProperties && this.inMolecularWeightInformation) {
                    this.molarMass = Double.parseDouble(new String(ch, start, length));
                    this.inMolecularWeightInformation = false;
                    this.inComputedProperties = false;
                    break;
                }
                if (!this.inLogP || !this.inLogPInformation) break;
                String logPString = new String(ch, start, length);
                this.logP = Double.parseDouble(logPString);
                this.inLogP = false;
                this.inLogPInformation = false;
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (this.currentTag) {
            case "RecordNumber": 
            case "TOCHeading": 
            case "StringValue": 
            case "NumValue": 
            case "StringValueList": {
                this.currentTag = "";
            }
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        switch (qName) {
            case "RecordNumber": 
            case "TOCHeading": 
            case "StringValue": 
            case "NumValue": 
            case "StringValueList": {
                this.currentTag = qName;
                break;
            }
            case "Information": {
                if (this.inRecordTitle) {
                    this.inRecordTitleInformation = true;
                } else if (this.inCanonicalSMILES) {
                    this.inCanonicalSMILESInformation = true;
                }
                if (this.inSynonyms) {
                    this.inSynonymsInformation = true;
                }
                if (!this.inLogP) break;
                this.inLogPInformation = true;
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

