/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.features.databases.unichem;

import de.bioforscher.singa.chemistry.descriptive.features.databases.uniprot.UniProtParserService;
import de.bioforscher.singa.core.identifier.ChEBIIdentifier;
import de.bioforscher.singa.core.identifier.InChIKey;
import de.bioforscher.singa.core.identifier.PubChemIdentifier;
import de.bioforscher.singa.core.identifier.model.Identifier;
import de.bioforscher.singa.core.parser.rest.AbstractHTMLParser;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniChemParser
extends AbstractHTMLParser<List<Identifier>> {
    private static final Logger logger = LoggerFactory.getLogger(UniProtParserService.class);
    private static final String UNICHEM_FETCH_URL = "https://www.ebi.ac.uk/unichem/rest/verbose_inchikey/%s";

    public UniChemParser(InChIKey inChIKey) {
        this.setResource(String.format(UNICHEM_FETCH_URL, inChIKey.toString()));
    }

    public static List<Identifier> parse(InChIKey inChIKey) {
        UniChemParser parser = new UniChemParser(inChIKey);
        return parser.parse();
    }

    /*
     * Exception decompiling
     */
    public List<Identifier> parse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Identifier> processLines(List<String> lines) {
        boolean isChebi = false;
        boolean isPubChem = false;
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        for (String line : lines) {
            if (line.equals("  name: chebi")) {
                isChebi = true;
                continue;
            }
            if (line.equals("  name: pubchem")) {
                isPubChem = true;
                continue;
            }
            if (isChebi && line.startsWith("    - ")) {
                isChebi = false;
                String chebiNumber = line.substring(5).trim();
                identifiers.add((Identifier)new ChEBIIdentifier("CHEBI:" + chebiNumber));
                continue;
            }
            if (!isPubChem || !line.startsWith("    - ")) continue;
            isPubChem = false;
            String pubChemNumber = line.substring(5).trim();
            identifiers.add((Identifier)new PubChemIdentifier("CID:" + pubChemNumber));
        }
        return identifiers;
    }
}

