/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.features.databases.uniprot;

import de.bioforscher.singa.chemistry.descriptive.annotations.Annotation;
import de.bioforscher.singa.chemistry.descriptive.annotations.AnnotationType;
import de.bioforscher.singa.chemistry.descriptive.entities.Enzyme;
import de.bioforscher.singa.chemistry.descriptive.entities.Protein;
import de.bioforscher.singa.chemistry.descriptive.features.databases.uniprot.UniProtDatabase;
import de.bioforscher.singa.chemistry.descriptive.features.molarmass.MolarMass;
import de.bioforscher.singa.core.biology.Organism;
import de.bioforscher.singa.core.biology.Taxon;
import de.bioforscher.singa.core.identifier.NCBITaxonomyIdentifier;
import de.bioforscher.singa.core.identifier.UniProtIdentifier;
import de.bioforscher.singa.core.identifier.model.Identifier;
import de.bioforscher.singa.features.model.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.measure.Quantity;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import tec.units.ri.quantity.Quantities;

public class UniProtContentHandler
implements ContentHandler {
    private static List<String> TEXT_COMMENTS_TO_PARSE = new ArrayList<String>();
    private String primaryIdentifier;
    private UniProtIdentifier identifier;
    private String recommendedName;
    private double molarMass;
    private List<String> additionalNames;
    private String aminoAcidSequence;
    private Organism sourceOrganism;
    private List<Annotation<String>> textComments;
    private String currentTag = "";
    private Annotation<String> temoraryCommentAnnotation;
    private boolean inRecommendedName = false;
    private boolean inAlternativeName = false;
    private boolean inOrganism = false;
    private boolean inRelevantComment = false;
    private boolean isScientificName = false;
    private boolean isCommonName = false;

    public UniProtContentHandler() {
        this.additionalNames = new ArrayList<String>();
        this.textComments = new ArrayList<Annotation<String>>();
    }

    public UniProtContentHandler(String primaryIdentifier) {
        this.primaryIdentifier = primaryIdentifier;
        this.additionalNames = new ArrayList<String>();
        this.textComments = new ArrayList<Annotation<String>>();
    }

    Protein getProtein() {
        Protein protein = this.primaryIdentifier == null ? (Protein)((Protein.Builder)((Protein.Builder)new Protein.Builder(this.identifier.toString()).name(this.recommendedName)).assignFeature((Feature)new MolarMass(this.molarMass, UniProtDatabase.origin))).build() : (Protein)((Enzyme.Builder)((Enzyme.Builder)((Enzyme.Builder)new Enzyme.Builder(this.primaryIdentifier).additionalIdentifier((Identifier)this.identifier)).name(this.recommendedName)).assignFeature((Feature)new MolarMass(this.molarMass, UniProtDatabase.origin))).build();
        protein.addOrganism(this.sourceOrganism);
        protein.addAminoAcidSequence(this.aminoAcidSequence.replaceAll("\\s", ""));
        this.additionalNames.forEach(protein::addAdditionalName);
        this.textComments.forEach(protein::addAnnotation);
        return protein;
    }

    Quantity<MolarMass> getMass() {
        return Quantities.getQuantity((Number)this.molarMass, MolarMass.GRAM_PER_MOLE);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        switch (qName) {
            case "accession": 
            case "fullName": 
            case "text": 
            case "taxon": {
                this.currentTag = qName;
                break;
            }
            case "recommendedName": {
                this.currentTag = qName;
                this.inRecommendedName = true;
                break;
            }
            case "alternativeName": {
                this.currentTag = qName;
                this.inAlternativeName = true;
                break;
            }
            case "organism": {
                this.currentTag = qName;
                this.inOrganism = true;
                break;
            }
            case "comment": {
                if (!TEXT_COMMENTS_TO_PARSE.contains(atts.getValue("type"))) break;
                this.currentTag = qName;
                this.inRelevantComment = true;
                this.temoraryCommentAnnotation = new Annotation(AnnotationType.NOTE);
                this.temoraryCommentAnnotation.setDescription(atts.getValue("type"));
                break;
            }
            case "name": {
                this.currentTag = qName;
                if (!this.inOrganism) break;
                if (atts.getValue("type").equals("scientific")) {
                    this.isScientificName = true;
                    break;
                }
                if (!atts.getValue("type").equals("common")) break;
                this.isCommonName = true;
                break;
            }
            case "dbReference": {
                if (!this.inOrganism || !atts.getValue("type").equals("NCBI Taxonomy")) break;
                this.sourceOrganism.setIdentifier(new NCBITaxonomyIdentifier(atts.getValue("id")));
                break;
            }
            case "sequence": {
                this.currentTag = qName;
                if (atts.getValue("mass") == null) break;
                this.molarMass = Double.valueOf(atts.getValue("mass"));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(this.currentTag)) {
            this.currentTag = "";
        }
        switch (qName) {
            case "recommendedName": {
                this.inRecommendedName = false;
                break;
            }
            case "alternativeName": {
                this.inAlternativeName = false;
                break;
            }
            case "organism": {
                this.inOrganism = false;
                break;
            }
            case "name": {
                this.isScientificName = false;
                this.isCommonName = false;
                break;
            }
            case "comment": {
                if (!this.inRelevantComment) break;
                if (this.temoraryCommentAnnotation.getContent() != null && !this.temoraryCommentAnnotation.getContent().trim().isEmpty()) {
                    this.textComments.add(this.temoraryCommentAnnotation);
                }
                this.inRelevantComment = false;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.currentTag) {
            case "accession": {
                this.identifier = new UniProtIdentifier(new String(ch, start, length));
            }
            case "fullName": {
                if (this.inRecommendedName) {
                    this.recommendedName = new String(ch, start, length);
                    break;
                }
                if (!this.inAlternativeName) break;
                this.additionalNames.add(new String(ch, start, length));
                break;
            }
            case "name": {
                if (!this.inOrganism) break;
                if (this.isScientificName) {
                    this.sourceOrganism = new Organism(new String(ch, start, length));
                    break;
                }
                if (!this.isCommonName) break;
                this.sourceOrganism.setCommonName(new String(ch, start, length));
                break;
            }
            case "taxon": {
                if (!this.inOrganism) break;
                this.sourceOrganism.getLineage().add(new Taxon(new String(ch, start, length)));
                break;
            }
            case "sequence": {
                if (this.aminoAcidSequence == null) {
                    this.aminoAcidSequence = new String(ch, start, length);
                    break;
                }
                this.aminoAcidSequence = this.aminoAcidSequence + new String(ch, start, length);
                break;
            }
            case "text": {
                if (!this.inRelevantComment) break;
                if (this.temoraryCommentAnnotation.getContent() == null) {
                    this.temoraryCommentAnnotation.setContent(new String(ch, start, length));
                    break;
                }
                this.temoraryCommentAnnotation.setContent(this.temoraryCommentAnnotation.getContent() + new String(ch, start, length));
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    static {
        Collections.addAll(TEXT_COMMENTS_TO_PARSE, "function", "catalytic activity");
    }
}

