/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.features.diffusivity;

import de.bioforscher.singa.chemistry.descriptive.features.diffusivity.Diffusivity;
import de.bioforscher.singa.chemistry.descriptive.features.diffusivity.WilkeCorrelation;
import de.bioforscher.singa.chemistry.descriptive.features.diffusivity.YoungCorrelation;
import de.bioforscher.singa.chemistry.descriptive.features.molarmass.MolarMass;
import de.bioforscher.singa.features.model.FeatureProvider;
import de.bioforscher.singa.features.model.Featureable;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Dimensionless;
import tec.units.ri.AbstractUnit;
import tec.units.ri.quantity.Quantities;

public class DiffusivityProvider
extends FeatureProvider<Diffusivity> {
    private final WilkeCorrelation wilkeCorrelation = new WilkeCorrelation();
    private final YoungCorrelation youngCorrelation = new YoungCorrelation();
    private static final Quantity<MolarMass> CORRELATION_THRESHOLD = Quantities.getQuantity((Number)10000, MolarMass.GRAM_PER_MOLE);
    public static final Quantity<Dimensionless> STDF_CELL_WATER = Quantities.getQuantity((Number)0.27, (Unit)AbstractUnit.ONE);

    public DiffusivityProvider() {
        this.setProvidedFeature(Diffusivity.class);
        this.addRequirement(MolarMass.class);
    }

    public <FeatureableType extends Featureable> Diffusivity provide(FeatureableType featureable) {
        MolarMass molarMass = (MolarMass)featureable.getFeature(MolarMass.class);
        if (molarMass.getValue().doubleValue() < CORRELATION_THRESHOLD.getValue().doubleValue()) {
            return this.wilkeCorrelation.predict(featureable);
        }
        return this.youngCorrelation.predict(featureable);
    }
}

