/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.features.logp;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.chemistry.descriptive.entities.Species;
import de.bioforscher.singa.chemistry.descriptive.features.databases.pubchem.PubChemDatabase;
import de.bioforscher.singa.chemistry.descriptive.features.databases.pubchem.PubChemParserService;
import de.bioforscher.singa.chemistry.descriptive.features.logp.LogP;
import de.bioforscher.singa.core.identifier.PubChemIdentifier;
import de.bioforscher.singa.core.identifier.model.Identifier;
import de.bioforscher.singa.features.model.FeatureProvider;
import de.bioforscher.singa.features.model.Featureable;
import java.util.Optional;

public class LogPProvider
extends FeatureProvider<LogP> {
    private final PubChemDatabase pubChemDatabase = PubChemDatabase.getInstance();

    public LogPProvider() {
        this.setProvidedFeature(LogP.class);
    }

    public <FeatureableType extends Featureable> LogP provide(FeatureableType featureable) {
        ChemicalEntity species = (ChemicalEntity)featureable;
        Optional identifier = PubChemIdentifier.find(species.getAllIdentifiers());
        if (identifier.isPresent()) {
            Species logPSpecies = PubChemParserService.parse(((Identifier)identifier.get()).toString());
            return logPSpecies.getFeature(LogP.class);
        }
        return null;
    }
}

