/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.features.molarmass;

import de.bioforscher.singa.chemistry.descriptive.entities.Enzyme;
import de.bioforscher.singa.chemistry.descriptive.entities.Protein;
import de.bioforscher.singa.chemistry.descriptive.entities.Species;
import de.bioforscher.singa.chemistry.descriptive.features.databases.chebi.ChEBIDatabase;
import de.bioforscher.singa.chemistry.descriptive.features.databases.uniprot.UniProtDatabase;
import de.bioforscher.singa.chemistry.descriptive.features.molarmass.MolarMass;
import de.bioforscher.singa.features.model.FeatureProvider;
import de.bioforscher.singa.features.model.Featureable;

public class MolarMassProvider
extends FeatureProvider<MolarMass> {
    private final ChEBIDatabase chEBIDatabase = ChEBIDatabase.getInstance();
    private final UniProtDatabase uniProtDatabase = UniProtDatabase.getInstance();

    public MolarMassProvider() {
        this.setProvidedFeature(MolarMass.class);
    }

    public <FeatureableType extends Featureable> MolarMass provide(FeatureableType featureable) {
        if (featureable.getClass().equals(Species.class)) {
            return ChEBIDatabase.fetchMolarMass(featureable);
        }
        if (featureable.getClass().equals(Enzyme.class) || featureable.getClass().equals(Protein.class)) {
            return UniProtDatabase.fetchMolarMass(featureable);
        }
        return null;
    }
}

