/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.features.smiles;

import de.bioforscher.singa.chemistry.descriptive.elements.Element;
import de.bioforscher.singa.chemistry.descriptive.elements.ElementProvider;
import de.bioforscher.singa.chemistry.descriptive.molecules.MoleculeAtom;
import de.bioforscher.singa.chemistry.descriptive.molecules.MoleculeBondType;
import de.bioforscher.singa.chemistry.descriptive.molecules.MoleculeGraph;
import de.bioforscher.singa.core.utility.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmilesParser {
    private static final Logger logger = LoggerFactory.getLogger(SmilesParser.class);
    private Queue<Character> symbols;
    private Character currentSymbol;
    private List<String> tokens;
    private String currentToken = "";
    private MoleculeGraph molecule;
    private int currentIdentifer = Integer.MIN_VALUE;
    private int currentMassNumber;
    private int currentCharge;
    private Element currentElement;
    private MoleculeBondType currentBondType = null;
    private HashMap<Pair<Integer>, MoleculeBondType> connectors;
    private HashMap<Integer, Integer> ringClosures;
    private List<Integer> hydrogens;
    private Deque<Integer> branches;
    private boolean firstAtomInBranch = false;
    private boolean sameChainReference;

    public SmilesParser() {
        this.symbols = new LinkedList<Character>();
        this.tokens = new ArrayList<String>();
        this.molecule = new MoleculeGraph();
        this.connectors = new HashMap();
        this.ringClosures = new HashMap();
        this.branches = new ArrayDeque<Integer>();
        this.hydrogens = new ArrayList<Integer>();
    }

    public static MoleculeGraph parse(String smilesString) {
        logger.info("parsing smiles string {} ", (Object)smilesString);
        SmilesParser parser = new SmilesParser();
        for (char aChar : smilesString.toCharArray()) {
            parser.symbols.add(Character.valueOf(aChar));
        }
        parser.currentSymbol = parser.symbols.poll();
        while (!parser.symbols.isEmpty()) {
            if (parser.parseSmiles()) continue;
            throw new IllegalArgumentException("The given string is no valid SMILES String (Exception was thrown after " + parser.tokens + " have been parsed).");
        }
        parser.hydrogens.forEach(identifier -> {
            int hydrogenIdentifier = parser.molecule.addNextAtom("H");
            parser.connectors.put((Pair<Integer>)new Pair(identifier, (Object)hydrogenIdentifier), MoleculeBondType.SINGLE_BOND);
        });
        parser.connectors.forEach((connector, type) -> {
            if (type != MoleculeBondType.UNCONNECTED) {
                parser.molecule.addEdgeBetween((MoleculeAtom)parser.molecule.getNode((Integer)connector.getFirst()), (MoleculeAtom)parser.molecule.getNode((Integer)connector.getSecond()), (MoleculeBondType)((Object)type));
            }
        });
        return parser.molecule;
    }

    private boolean parseSmiles() {
        if (this.isEmpty()) {
            return false;
        }
        if (!this.parseAtom()) {
            return false;
        }
        do {
            boolean parsable = this.parseBranch();
        } while (parsable |= this.parseChain());
        return true;
    }

    private boolean parseAtom() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.parseOrganicSymbol(false)) {
            this.connectConsecutiveAtoms();
            return true;
        }
        if (this.parseAromaticSymbol(false)) {
            this.connectConsecutiveAtoms();
            return true;
        }
        if (this.parseAtomSpecification()) {
            this.connectConsecutiveAtoms();
            return true;
        }
        if (this.currentSymbol.charValue() == '*') {
            this.addToTokens();
            this.poll();
        }
        return false;
    }

    private boolean parseBranch() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.currentSymbol.charValue() == '(') {
            this.addToTokens();
            this.poll();
            this.openBranch();
            this.parseBond();
            int length = 0;
            while (this.parseSmiles()) {
                ++length;
            }
            if (this.currentSymbol.charValue() == ')') {
                if (length < 1) {
                    return false;
                }
                this.closeBranch();
                this.addToTokens();
                this.poll();
                return true;
            }
        }
        return false;
    }

    private boolean parseChain() {
        boolean parsable;
        if (this.isEmpty()) {
            return false;
        }
        int length = 0;
        do {
            this.parseBond();
            parsable = this.parseAtom();
            if (!(parsable |= this.parseRingClosure())) continue;
            ++length;
        } while (parsable);
        return length > 0;
    }

    private boolean parseBond() {
        if (this.isEmpty()) {
            return false;
        }
        switch (this.currentSymbol.charValue()) {
            case '#': 
            case '$': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '=': 
            case '\\': {
                this.addToTokens();
                this.setNextBond();
                this.poll();
                return true;
            }
        }
        return false;
    }

    private boolean parseRingClosure() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.currentSymbol.charValue() == '%') {
            if (this.isNonZeroDecimal()) {
                this.addToCurrentToken();
                this.poll();
                if (this.isDecimal()) {
                    this.addToCurrentToken();
                    this.poll();
                    return true;
                }
            }
        } else if (this.isDecimal()) {
            this.addToTokens();
            this.addRingClosure();
            this.poll();
            return true;
        }
        return false;
    }

    private boolean parseOrganicSymbol(boolean addLater) {
        if (this.isEmpty()) {
            return false;
        }
        switch (this.currentSymbol.charValue()) {
            case 'B': {
                if (this.symbols.peek().charValue() == 'r') {
                    this.dispose();
                    if (addLater) {
                        this.currentToken = this.currentToken + "Br";
                        this.currentElement = ElementProvider.BROMINE;
                    } else {
                        this.tokens.add("Br");
                        this.addAtomToGraph("Br");
                    }
                } else {
                    this.handleAtom(addLater);
                }
                this.poll();
                return true;
            }
            case 'C': {
                if (this.symbols.peek().charValue() == 'l') {
                    this.dispose();
                    if (addLater) {
                        this.currentToken = this.currentToken + "Cl";
                        this.currentElement = ElementProvider.CHLORINE;
                    } else {
                        this.tokens.add("Cl");
                        this.addAtomToGraph("Cl");
                    }
                } else {
                    this.handleAtom(addLater);
                }
                this.poll();
                return true;
            }
            case 'F': 
            case 'I': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'S': {
                this.handleAtom(addLater);
                this.poll();
                return true;
            }
        }
        return false;
    }

    private void handleAtom(boolean addLater) {
        if (addLater) {
            this.addToCurrentToken();
            this.currentElement = ElementProvider.getElementBySymbol(String.valueOf(this.currentSymbol)).orElseThrow(() -> new IllegalArgumentException("The symbol " + this.currentSymbol + " represents no valid element."));
        } else {
            this.addToTokens();
            this.addAtomToGraph(this.currentSymbol.charValue());
        }
    }

    private boolean parseAromaticSymbol(boolean addLater) {
        if (this.isEmpty()) {
            return false;
        }
        switch (this.currentSymbol.charValue()) {
            case 'b': 
            case 'c': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 's': {
                this.handleAtom(addLater);
                this.currentBondType = MoleculeBondType.AROMATIC_BOND;
                this.poll();
                return true;
            }
        }
        return false;
    }

    private boolean parseAtomSpecification() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.currentSymbol.charValue() == '[') {
            this.addToCurrentToken();
            this.poll();
            this.parseIsotope();
            if (!(this.parseAromaticSeleniumAndArsenic() || this.parseAromaticSymbol(true) || this.parseElementSymbol())) {
                if (this.currentSymbol.charValue() == '*') {
                    this.addToCurrentToken();
                    this.poll();
                } else {
                    return false;
                }
            }
            this.parseChirality();
            this.parseHCount();
            this.parseCharge();
            this.parseClass();
            this.addAtom();
            if (this.currentSymbol.charValue() == ']') {
                this.addToCurrentToken();
                this.addAndClearCurrentToken();
                this.poll();
                return true;
            }
        }
        return false;
    }

    private boolean parseIsotope() {
        if (this.isEmpty()) {
            return false;
        }
        String isotopeCount = "";
        if (this.isNonZeroDecimal()) {
            isotopeCount = isotopeCount + this.currentSymbol;
            this.poll();
            if (this.isDecimal()) {
                isotopeCount = isotopeCount + this.currentSymbol;
                this.poll();
                if (this.isDecimal()) {
                    isotopeCount = isotopeCount + this.currentSymbol;
                    this.poll();
                }
            }
            this.currentToken = this.currentToken + isotopeCount;
            this.currentMassNumber = Integer.valueOf(isotopeCount);
            return true;
        }
        return false;
    }

    private boolean parseAromaticSeleniumAndArsenic() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.currentSymbol.charValue() == 's') {
            if (this.symbols.peek().charValue() == 'e') {
                this.dispose();
                this.currentElement = ElementProvider.SELENIUM;
                this.currentBondType = MoleculeBondType.AROMATIC_BOND;
                this.poll();
                return true;
            }
            return false;
        }
        if (this.currentSymbol.charValue() == 'a') {
            if (this.symbols.peek().charValue() == 's') {
                this.dispose();
                this.currentElement = ElementProvider.ARSENIC;
                this.currentBondType = MoleculeBondType.AROMATIC_BOND;
                this.poll();
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean parseElementSymbol() {
        if (this.isUpperCaseWordCharacter()) {
            String element = "";
            this.addToCurrentToken();
            element = element + this.currentSymbol;
            this.poll();
            if (this.isLowerCaseWordCharacter()) {
                this.addToCurrentToken();
                element = element + this.currentSymbol;
                this.poll();
            }
            this.currentElement = ElementProvider.getElementBySymbol(String.valueOf(element)).orElseThrow(() -> new IllegalArgumentException("The symbol " + this.currentSymbol + " represents no valid element."));
            return true;
        }
        return false;
    }

    private boolean parseChirality() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.currentSymbol.charValue() == '@') {
            this.addToCurrentToken();
            this.poll();
            if (this.currentSymbol.charValue() == '@') {
                this.addToCurrentToken();
                this.poll();
                return true;
            }
            if (this.currentSymbol.charValue() == 'T') {
                if (this.symbols.peek().charValue() == 'H') {
                    this.addThisAndNext();
                    this.poll();
                    if (this.isInRage(Character.valueOf('1'), Character.valueOf('2'))) {
                        this.addToCurrentToken();
                        this.poll();
                        return true;
                    }
                } else if (this.symbols.peek().charValue() == 'B') {
                    this.addThisAndNext();
                    this.poll();
                    if (this.currentSymbol.charValue() == '1') {
                        this.addToCurrentToken();
                        this.poll();
                        if (this.isDecimal()) {
                            this.addToCurrentToken();
                            this.poll();
                        }
                        return true;
                    }
                    if (this.currentSymbol.charValue() == '2') {
                        this.addToCurrentToken();
                        this.poll();
                        if (this.currentSymbol.charValue() == '0') {
                            this.addToCurrentToken();
                            this.poll();
                        }
                        return true;
                    }
                    if (this.isInRage(Character.valueOf('3'), Character.valueOf('9'))) {
                        this.addToCurrentToken();
                        this.poll();
                        return true;
                    }
                }
            } else if (this.currentSymbol.charValue() == 'A') {
                if (this.symbols.peek().charValue() == 'L') {
                    this.addThisAndNext();
                    this.poll();
                    if (this.isInRage(Character.valueOf('1'), Character.valueOf('2'))) {
                        this.addToCurrentToken();
                        this.poll();
                        return true;
                    }
                }
            } else if (this.currentSymbol.charValue() == 'S') {
                if (this.symbols.peek().charValue() == 'P') {
                    this.addThisAndNext();
                    this.poll();
                    if (this.isInRage(Character.valueOf('1'), Character.valueOf('3'))) {
                        this.addToCurrentToken();
                        this.poll();
                        return true;
                    }
                }
            } else if (this.currentSymbol.charValue() == 'O' && this.symbols.peek().charValue() == 'H') {
                this.addThisAndNext();
                this.poll();
                if (this.currentSymbol.charValue() == '1') {
                    this.addToCurrentToken();
                    this.poll();
                    if (this.isDecimal()) {
                        this.addToCurrentToken();
                        this.poll();
                    }
                    return true;
                }
                if (this.currentSymbol.charValue() == '2') {
                    this.addToCurrentToken();
                    this.poll();
                    if (this.isDecimal()) {
                        this.addToCurrentToken();
                        this.poll();
                    }
                    return true;
                }
                if (this.currentSymbol.charValue() == '3') {
                    this.addToCurrentToken();
                    this.poll();
                    if (this.currentSymbol.charValue() == '0') {
                        this.addToCurrentToken();
                        this.poll();
                    }
                    return true;
                }
                if (this.isInRage(Character.valueOf('4'), Character.valueOf('9'))) {
                    this.addToCurrentToken();
                    this.poll();
                    return true;
                }
            }
        }
        return false;
    }

    private boolean parseHCount() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.currentSymbol.charValue() == 'H') {
            this.addToCurrentToken();
            this.poll();
            if (this.isDecimal()) {
                this.addToCurrentToken();
                this.connectHydrogens(Integer.valueOf(String.valueOf(this.currentSymbol)));
                this.poll();
                return true;
            }
            this.connectHydrogens(1);
        }
        return false;
    }

    private boolean parseCharge() {
        if (this.isEmpty()) {
            return false;
        }
        String chargeToken = "";
        if (this.currentSymbol.charValue() == '+') {
            chargeToken = chargeToken + this.currentSymbol;
            this.addToCurrentToken();
            this.poll();
            if (this.currentSymbol.charValue() == '+') {
                chargeToken = chargeToken + this.currentSymbol;
                this.addToCurrentToken();
                this.poll();
            } else {
                chargeToken = chargeToken + this.parseChargeNumber();
            }
            this.setCharge(chargeToken);
            return true;
        }
        if (this.currentSymbol.charValue() == '-') {
            chargeToken = chargeToken + this.currentSymbol;
            this.addToCurrentToken();
            this.poll();
            if (this.currentSymbol.charValue() == '-') {
                chargeToken = chargeToken + this.currentSymbol;
                this.addToCurrentToken();
                this.poll();
            } else {
                chargeToken = chargeToken + this.parseChargeNumber();
            }
            this.setCharge(chargeToken);
            return true;
        }
        return false;
    }

    private String parseChargeNumber() {
        String chargeToken = "";
        if (this.currentSymbol.charValue() == '0') {
            chargeToken = chargeToken + this.currentSymbol;
            this.addToCurrentToken();
            this.poll();
        } else if (this.currentSymbol.charValue() == '1') {
            chargeToken = chargeToken + this.currentSymbol;
            this.addToCurrentToken();
            this.poll();
            if (this.isInRage(Character.valueOf('0'), Character.valueOf('5'))) {
                chargeToken = chargeToken + this.currentSymbol;
                this.addToCurrentToken();
                this.poll();
            }
        } else if (this.isInRage(Character.valueOf('2'), Character.valueOf('9'))) {
            chargeToken = chargeToken + this.currentSymbol;
            this.addToCurrentToken();
            this.poll();
        }
        return chargeToken;
    }

    private void setCharge(String chargeToken) {
        switch (chargeToken) {
            case "+": {
                this.currentCharge = 1;
                break;
            }
            case "++": {
                this.currentCharge = 2;
                break;
            }
            case "-": {
                this.currentCharge = -1;
                break;
            }
            case "--": {
                this.currentCharge = -2;
                break;
            }
            default: {
                this.currentCharge = Integer.valueOf(chargeToken);
            }
        }
    }

    private boolean parseClass() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.currentSymbol.charValue() == ':') {
            this.addToCurrentToken();
            this.poll();
            int length = 0;
            while (this.isDecimal()) {
                this.addToCurrentToken();
                this.poll();
                ++length;
            }
            return length > 0;
        }
        return false;
    }

    private void setNextBond() {
        this.currentBondType = MoleculeBondType.getBondForSMILESSymbol(this.currentSymbol.charValue());
    }

    private void connectConsecutiveAtoms() {
        if (this.molecule.getNodes().size() > 1) {
            if (this.firstAtomInBranch) {
                if (this.sameChainReference) {
                    this.connectors.put((Pair<Integer>)new Pair((Object)this.branches.peekLast(), (Object)this.currentIdentifer), this.currentBondType == null ? MoleculeBondType.SINGLE_BOND : this.currentBondType);
                    this.sameChainReference = false;
                } else {
                    this.connectors.put((Pair<Integer>)new Pair((Object)this.branches.pollLast(), (Object)this.currentIdentifer), this.currentBondType == null ? MoleculeBondType.SINGLE_BOND : this.currentBondType);
                }
                this.currentBondType = null;
                this.firstAtomInBranch = false;
            } else {
                this.connectors.put((Pair<Integer>)new Pair((Object)(this.currentIdentifer - 1), (Object)this.currentIdentifer), this.currentBondType == null ? MoleculeBondType.SINGLE_BOND : this.currentBondType);
                this.currentBondType = null;
            }
        }
    }

    private void connectHydrogens(int hydrogenCount) {
        for (int count = 0; count < hydrogenCount; ++count) {
            this.hydrogens.add(this.currentIdentifer + 1);
        }
    }

    private void addRingClosure() {
        int closureIdentifier = Integer.valueOf(String.valueOf(this.currentSymbol));
        if (this.ringClosures.containsKey(closureIdentifier)) {
            this.connectors.put((Pair<Integer>)new Pair((Object)this.ringClosures.get(closureIdentifier), (Object)this.currentIdentifer), MoleculeBondType.SINGLE_BOND);
            this.ringClosures.remove(closureIdentifier);
        } else {
            this.ringClosures.put(closureIdentifier, this.currentIdentifer);
        }
    }

    private boolean isEmpty() {
        return this.currentSymbol == null;
    }

    private boolean isInRage(Character rangeStart, Character rangeEnd) {
        return this.currentSymbol.charValue() >= rangeStart.charValue() && this.currentSymbol.charValue() <= rangeEnd.charValue();
    }

    private boolean isNonZeroDecimal() {
        return this.isInRage(Character.valueOf('1'), Character.valueOf('9'));
    }

    private boolean isDecimal() {
        return this.isInRage(Character.valueOf('0'), Character.valueOf('9'));
    }

    private boolean isLowerCaseWordCharacter() {
        return this.isInRage(Character.valueOf('a'), Character.valueOf('z'));
    }

    private boolean isUpperCaseWordCharacter() {
        return this.isInRage(Character.valueOf('A'), Character.valueOf('Z'));
    }

    private void addToCurrentToken() {
        this.currentToken = this.currentToken + this.currentSymbol;
    }

    private void addThisAndNext() {
        this.addToCurrentToken();
        this.poll();
        this.addToCurrentToken();
    }

    private void addToTokens() {
        logger.trace("read token {}", (Object)this.currentSymbol);
        this.tokens.add(String.valueOf(this.currentSymbol));
    }

    private void addAndClearCurrentToken() {
        logger.trace("read token {}", (Object)this.currentToken);
        this.tokens.add(this.currentToken);
        this.currentToken = "";
    }

    private void poll() {
        this.currentSymbol = this.symbols.poll();
    }

    private void dispose() {
        this.poll();
    }

    private void addAtomToGraph(char atom) {
        this.addAtomToGraph(String.valueOf(atom));
    }

    private void addAtomToGraph(String atom) {
        this.currentIdentifer = this.molecule.addNextAtom(atom);
    }

    private void addAtom() {
        if (this.currentMassNumber != 0) {
            this.currentIdentifer = this.molecule.addNextAtom(this.currentElement, this.currentCharge, this.currentMassNumber);
            this.currentMassNumber = 0;
        } else {
            this.currentIdentifer = this.molecule.addNextAtom(this.currentElement, this.currentCharge);
        }
        this.currentElement = null;
        this.currentCharge = 0;
    }

    private void openBranch() {
        if (!this.sameChainReference) {
            this.branches.add(this.currentIdentifer);
        }
    }

    private void closeBranch() {
        if (this.symbols.peek().charValue() == '(') {
            this.sameChainReference = true;
        }
        this.firstAtomInBranch = true;
    }
}

