/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.parser.pdb.structures;

import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.model.UniqueAtomIdentifer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ContentTreeNode {
    private StructureLevel level;
    private String identifier;
    private Map<Atom, UniqueAtomIdentifer> identiferMap;
    private Atom atom;
    private List<ContentTreeNode> children;

    public ContentTreeNode(String identifier, StructureLevel level) {
        this.identifier = identifier;
        this.level = level;
        this.children = new ArrayList<ContentTreeNode>();
        this.identiferMap = new HashMap<Atom, UniqueAtomIdentifer>();
    }

    public ContentTreeNode(String identifier, StructureLevel level, Atom atom) {
        this.level = level;
        this.identifier = identifier;
        this.atom = atom;
        this.children = null;
    }

    public StructureLevel getLevel() {
        return this.level;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Atom getAtom() {
        return this.atom;
    }

    public void setAtom(Atom atom) {
        this.atom = atom;
    }

    public List<ContentTreeNode> getChildren() {
        return this.children;
    }

    public List<ContentTreeNode> getNodesFromLevel(StructureLevel level) {
        ArrayList<ContentTreeNode> nodes = new ArrayList<ContentTreeNode>();
        if (this.level == level) {
            nodes.add(this);
        } else {
            this.children.forEach(child -> nodes.addAll(child.getNodesFromLevel(level)));
        }
        return nodes;
    }

    public Map<String, Atom> getAtomMap() {
        if (this.getLevel() == StructureLevel.LEAF) {
            HashMap<String, Atom> atoms = new HashMap<String, Atom>();
            for (ContentTreeNode node : this.children) {
                atoms.put(node.getAtom().getAtomNameString(), node.getAtom());
            }
            return atoms;
        }
        return null;
    }

    public void appendAtom(Atom atom, UniqueAtomIdentifer identifer) {
        ListIterator<ContentTreeNode> iterator = this.children.listIterator();
        if (this.children.isEmpty()) {
            switch (this.level) {
                case STRUCTURE: {
                    iterator.add(new ContentTreeNode(String.valueOf(identifer.getModelIdentifier()), StructureLevel.MODEL));
                    break;
                }
                case MODEL: {
                    iterator.add(new ContentTreeNode(identifer.getChainIdentifier(), StructureLevel.CHAIN));
                    break;
                }
                case CHAIN: {
                    iterator.add(new ContentTreeNode(String.valueOf(identifer.getLeafIdentifer()), StructureLevel.LEAF));
                    break;
                }
                case LEAF: {
                    iterator.add(new ContentTreeNode(String.valueOf(identifer.getAtomSerial()), StructureLevel.ATOM, atom));
                    return;
                }
                case ATOM: {
                    return;
                }
            }
            iterator.previous().appendAtom(atom, identifer);
        } else {
            switch (this.level) {
                case STRUCTURE: {
                    while (iterator.hasNext()) {
                        ContentTreeNode model = iterator.next();
                        if (!model.identifier.equals(String.valueOf(identifer.getModelIdentifier()))) continue;
                        model.appendAtom(atom, identifer);
                        return;
                    }
                    iterator.add(new ContentTreeNode(String.valueOf(identifer.getModelIdentifier()), StructureLevel.MODEL));
                    break;
                }
                case MODEL: {
                    while (iterator.hasNext()) {
                        ContentTreeNode chain = iterator.next();
                        if (!chain.identifier.equals(String.valueOf(identifer.getChainIdentifier()))) continue;
                        chain.appendAtom(atom, identifer);
                        return;
                    }
                    iterator.add(new ContentTreeNode(identifer.getChainIdentifier(), StructureLevel.CHAIN));
                    break;
                }
                case CHAIN: {
                    while (iterator.hasNext()) {
                        ContentTreeNode leaf = iterator.next();
                        if (!leaf.identifier.equals(String.valueOf(identifer.getLeafIdentifer()))) continue;
                        leaf.children.add(new ContentTreeNode(String.valueOf(identifer.getAtomSerial()), StructureLevel.ATOM, atom));
                        leaf.identiferMap.put(atom, identifer);
                        return;
                    }
                    ContentTreeNode leafNode = new ContentTreeNode(String.valueOf(identifer.getLeafIdentifer()), StructureLevel.LEAF);
                    leafNode.identiferMap.put(atom, identifer);
                    leafNode.children.add(new ContentTreeNode(String.valueOf(identifer.getAtomSerial()), StructureLevel.ATOM, atom));
                    iterator.add(leafNode);
                    break;
                }
                case LEAF: 
                case ATOM: {
                    return;
                }
            }
            iterator.previous().appendAtom(atom, identifer);
        }
    }

    public Map<Atom, UniqueAtomIdentifer> getIdentiferMap() {
        return this.identiferMap;
    }

    public static enum StructureLevel {
        STRUCTURE,
        MODEL,
        CHAIN,
        LEAF,
        ATOM;

    }
}

