/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.parser.pdb.structures;

import de.bioforscher.singa.chemistry.parser.pdb.ligands.LigandParserService;
import de.bioforscher.singa.chemistry.parser.pdb.structures.ContentTreeNode;
import de.bioforscher.singa.chemistry.parser.pdb.structures.StructureParser;
import de.bioforscher.singa.chemistry.parser.pdb.structures.StructureParserException;
import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.AtomToken;
import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.ChainTerminatorToken;
import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.HeaderToken;
import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.LeafSkeleton;
import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.ModelToken;
import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.TerminatorTokens;
import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.TitleToken;
import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.branches.Chain;
import de.bioforscher.singa.chemistry.physical.branches.StructuralModel;
import de.bioforscher.singa.chemistry.physical.families.AminoAcidFamily;
import de.bioforscher.singa.chemistry.physical.families.LeafFactory;
import de.bioforscher.singa.chemistry.physical.families.LigandFamily;
import de.bioforscher.singa.chemistry.physical.families.NucleotideFamily;
import de.bioforscher.singa.chemistry.physical.leaves.AminoAcid;
import de.bioforscher.singa.chemistry.physical.leaves.AtomContainer;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.leaves.Nucleotide;
import de.bioforscher.singa.chemistry.physical.model.LeafIdentifier;
import de.bioforscher.singa.chemistry.physical.model.Structure;
import de.bioforscher.singa.chemistry.physical.model.UniqueAtomIdentifer;
import de.bioforscher.singa.core.identifier.PDBIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureCollector {
    private static final Logger logger = LoggerFactory.getLogger(StructureCollector.class);
    private String currentPDB = "0000";
    private StringBuilder titleBuilder = new StringBuilder();
    private int currentModel = 0;
    private Map<UniqueAtomIdentifer, Atom> atoms;
    private Map<LeafIdentifier, String> leafNames;
    private Set<LeafIdentifier> hetAtoms;
    private Set<LeafIdentifier> notInConsecutiveChain;
    private String currentChain;
    private Set<String> closedChains;
    private ContentTreeNode contentTree;
    private StructureParser.Reducer reducer;
    private List<String> pdbLines;

    public StructureCollector(List<String> pdbLines, StructureParser.Reducer reducer) {
        this.reducer = reducer;
        this.pdbLines = pdbLines;
        this.atoms = new HashMap<UniqueAtomIdentifer, Atom>();
        this.leafNames = new TreeMap<LeafIdentifier, String>();
        this.hetAtoms = new HashSet<LeafIdentifier>();
        this.notInConsecutiveChain = new HashSet<LeafIdentifier>();
        this.closedChains = new HashSet<String>();
    }

    static Structure parse(List<String> pdbLines, StructureParser.Reducer reducer) throws StructureParserException {
        StructureCollector collector = new StructureCollector(pdbLines, reducer);
        collector.reduceLines();
        return collector.collectStructure();
    }

    private void reduceLines() throws StructureParserException {
        String firstLine = this.pdbLines.get(0);
        if (this.reducer.options.isInferringIdentifierFromFileName()) {
            String currentSource = this.reducer.sourceSelector.contentIterator.getCurrentSource();
            String identifier = PDBIdentifier.extractFirst((String)currentSource);
            if (identifier != null) {
                this.currentPDB = identifier;
            }
        } else if (HeaderToken.RECORD_PATTERN.matcher(firstLine).matches()) {
            this.currentPDB = HeaderToken.ID_CODE.extract(firstLine);
        }
        this.getTitle();
        if (this.reducer.parseMapping) {
            this.reducer.updatePdbIdentifer();
            this.reducer.updateChainIdentifier();
            this.reduceToChain(this.reducer.chainIdentifier);
            logger.info("Parsing structure {} chainIdentifier {}", (Object)this.reducer.pdbIdentifier, (Object)this.reducer.chainIdentifier);
        } else {
            if (!this.reducer.allModels) {
                this.reduceToModel(this.reducer.modelIdentifier);
            }
            if (!this.reducer.allChains) {
                this.reduceToChain(this.reducer.chainIdentifier);
            }
        }
    }

    private void getTitle() {
        if (this.reducer.options.isInferringTitleFromFileName()) {
            this.titleBuilder.append(this.reducer.sourceSelector.contentIterator.getCurrentSource());
        } else {
            boolean titleFound = false;
            for (String currentLine : this.pdbLines) {
                if (TitleToken.RECORD_PATTERN.matcher(currentLine).matches()) {
                    if (!titleFound) {
                        titleFound = true;
                    }
                    this.titleBuilder.append(TitleToken.TEXT.extract(currentLine));
                    continue;
                }
                if (!titleFound) continue;
                return;
            }
        }
    }

    private void reduceToModel(int modelIdentifier) {
        ArrayList<String> reducedList = new ArrayList<String>();
        boolean collectLines = false;
        for (String currentLine : this.pdbLines) {
            int currentModel;
            if (ModelToken.RECORD_PATTERN.matcher(currentLine).matches() && (currentModel = Integer.valueOf(ModelToken.MODEL_SERIAL.extract(currentLine)).intValue()) == modelIdentifier) {
                this.currentModel = currentModel;
                collectLines = true;
                continue;
            }
            if (collectLines && TerminatorTokens.MODEL_TERMINATOR.matcher(currentLine).matches()) break;
            if (!collectLines) continue;
            reducedList.add(currentLine);
        }
        this.pdbLines = reducedList;
    }

    private void reduceToChain(String chainIdentifier) {
        ArrayList<String> reducedList = new ArrayList<String>();
        for (String currentLine : this.pdbLines) {
            if (AtomToken.RECORD_PATTERN.matcher(currentLine).matches()) {
                String currentChain = AtomToken.CHAIN_IDENTIFIER.extract(currentLine);
                if (!currentChain.equals(chainIdentifier)) continue;
                reducedList.add(currentLine);
                continue;
            }
            if (ModelToken.RECORD_PATTERN.matcher(currentLine).matches()) {
                reducedList.add(currentLine);
                continue;
            }
            if (!ChainTerminatorToken.RECORD_PATTERN.matcher(currentLine).matches()) continue;
            reducedList.add(currentLine);
        }
        this.pdbLines = reducedList;
    }

    private Structure collectStructure() {
        this.collectAtomInformation();
        this.createContentTree();
        Structure structure = new Structure();
        structure.setPdbIdentifier(this.contentTree.getIdentifier());
        structure.setTitle(this.titleBuilder.toString());
        logger.debug("creating structure");
        int chainGraphId = 0;
        for (ContentTreeNode modelNode : this.contentTree.getNodesFromLevel(ContentTreeNode.StructureLevel.MODEL)) {
            logger.debug("collecting chains for model {}", (Object)modelNode.getIdentifier());
            StructuralModel model = new StructuralModel(Integer.valueOf(modelNode.getIdentifier()));
            for (ContentTreeNode chainNode : modelNode.getNodesFromLevel(ContentTreeNode.StructureLevel.CHAIN)) {
                logger.trace("collecting leafs for chainIdentifier {}", (Object)chainNode.getIdentifier());
                Chain chain = new Chain(chainGraphId++);
                chain.setChainIdentifier(chainNode.getIdentifier());
                for (ContentTreeNode leafNode : chainNode.getNodesFromLevel(ContentTreeNode.StructureLevel.LEAF)) {
                    LeafSubstructure<?, ?> leafSubstructure = this.assignLeaf(leafNode, Integer.valueOf(modelNode.getIdentifier()), chainNode.getIdentifier());
                    if (this.hetAtoms.contains(leafSubstructure.getLeafIdentifier())) {
                        leafSubstructure.setAnnotatedAsHetAtom(true);
                    }
                    if (this.notInConsecutiveChain.contains(leafSubstructure.getLeafIdentifier())) {
                        chain.addSubstructure(leafSubstructure);
                        continue;
                    }
                    chain.addToConsecutivePart(leafSubstructure);
                }
                model.addSubstructure(chain);
            }
            structure.addSubstructure(model);
        }
        if (this.reducer.options.isCreatingEdges()) {
            structure.getAllChains().forEach(Chain::connectChainBackbone);
        }
        return structure;
    }

    private void collectAtomInformation() {
        logger.debug("collecting information from {} PDB lines", (Object)this.pdbLines.size());
        for (String currentLine : this.pdbLines) {
            String currentRecordType = AtomToken.RECORD_TYPE.extract(currentLine);
            if (AtomToken.RECORD_PATTERN.matcher(currentRecordType).matches()) {
                UniqueAtomIdentifer identifier = this.createUniqueAtomIdentifier(currentLine);
                this.atoms.put(identifier, AtomToken.assembleAtom(currentLine));
                LeafIdentifier leafIdentifier = new LeafIdentifier(identifier.getPdbIdentifier(), identifier.getModelIdentifier(), identifier.getChainIdentifier(), identifier.getLeafIdentifer());
                this.currentChain = leafIdentifier.getChainIdentifer();
                if (currentRecordType.equals("HETATM")) {
                    this.hetAtoms.add(leafIdentifier);
                }
                if (this.closedChains.contains(this.currentModel + "-" + this.currentChain)) {
                    this.notInConsecutiveChain.add(leafIdentifier);
                }
                this.leafNames.put(leafIdentifier, AtomToken.RESIDUE_NAME.extract(currentLine));
                continue;
            }
            if (currentRecordType.equals("MODEL")) {
                this.currentModel = Integer.valueOf(ModelToken.MODEL_SERIAL.extract(currentLine));
                continue;
            }
            if (!currentRecordType.equals("TER")) continue;
            this.closedChains.add(this.currentModel + "-" + this.currentChain);
        }
    }

    private void createContentTree() {
        logger.debug("creating content tree");
        this.contentTree = new ContentTreeNode(this.currentPDB, ContentTreeNode.StructureLevel.STRUCTURE);
        this.atoms.forEach((identifer, atom) -> this.contentTree.appendAtom((Atom)atom, (UniqueAtomIdentifer)identifer));
        if (this.atoms.isEmpty()) {
            throw new StructureParserException("could not reduce PDB-ID according to " + this.reducer);
        }
    }

    private UniqueAtomIdentifer createUniqueAtomIdentifier(String atomLine) {
        int atomSerial = Integer.valueOf(AtomToken.ATOM_SERIAL.extract(atomLine));
        String chain = AtomToken.CHAIN_IDENTIFIER.extract(atomLine);
        int leaf = Integer.valueOf(AtomToken.RESIDUE_SERIAL.extract(atomLine));
        return new UniqueAtomIdentifer(this.currentPDB, this.currentModel, chain, leaf, atomSerial);
    }

    private LeafSubstructure<?, ?> assignLeaf(ContentTreeNode leafNode, int modelIdentifier, String chainIdentifer) {
        LeafIdentifier leafIdentifier = new LeafIdentifier(this.currentPDB, modelIdentifier, chainIdentifer, Integer.valueOf(leafNode.getIdentifier()));
        String leafName = this.leafNames.get(leafIdentifier);
        Map<String, Atom> atoms = leafNode.getAtomMap();
        logger.trace("creating leaf {}:{} for chainIdentifier {}", new Object[]{leafNode.getIdentifier(), leafName, chainIdentifer});
        if (this.isPlainAminoAcid(leafName)) {
            AminoAcidFamily family = AminoAcidFamily.getAminoAcidTypeByThreeLetterCode(leafName).get();
            return this.createAminoAcid(leafIdentifier, family, atoms);
        }
        if (this.isPlainNucleotide(leafName)) {
            NucleotideFamily family = NucleotideFamily.getNucleotideByThreeLetterCode(leafName).get();
            return this.createNucleotide(leafIdentifier, family, atoms);
        }
        if (this.reducer.options.isRetrievingLigandInformation()) {
            return this.createLeafWithAdditionalInformation(leafIdentifier, leafName, atoms);
        }
        return this.createLeafWithoutAdditionalInformation(leafIdentifier, leafName, atoms);
    }

    private boolean isPlainAminoAcid(String leafName) {
        return AminoAcidFamily.getAminoAcidTypeByThreeLetterCode(leafName).isPresent();
    }

    private boolean isPlainNucleotide(String leafName) {
        return NucleotideFamily.getNucleotideByThreeLetterCode(leafName).isPresent();
    }

    private AminoAcid createAminoAcid(LeafIdentifier identifier, AminoAcidFamily family, Map<String, Atom> atoms) {
        return LeafFactory.createAminoAcidFromAtoms(identifier, family, atoms, this.reducer.options);
    }

    private Nucleotide createNucleotide(LeafIdentifier identifier, NucleotideFamily family, Map<String, Atom> atoms) {
        return LeafFactory.createNucleotideFromAtoms(identifier, family, atoms, this.reducer.options);
    }

    private LeafSubstructure<?, ?> createLeafWithoutAdditionalInformation(LeafIdentifier identifier, String leafName, Map<String, Atom> atoms) {
        AtomContainer<LigandFamily> substructure = new AtomContainer<LigandFamily>(identifier, new LigandFamily("?", leafName));
        atoms.values().forEach(substructure::addNode);
        return substructure;
    }

    private LeafSubstructure<?, ?> createLeafWithAdditionalInformation(LeafIdentifier identifier, String leafName, Map<String, Atom> atoms) {
        LeafSkeleton leafSkeleton;
        if (!this.reducer.skeletons.containsKey(leafName)) {
            leafSkeleton = LigandParserService.parseLeafSkeleton(leafName);
            this.reducer.skeletons.put(leafName, leafSkeleton);
        } else {
            leafSkeleton = this.reducer.skeletons.get(leafName);
        }
        return leafSkeleton.toRealLeafSubStructure(identifier, atoms);
    }
}

