/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.parser.pdb.structures;

import de.bioforscher.singa.chemistry.parser.pdb.structures.StructureParser;
import de.bioforscher.singa.core.utility.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StructureContentIterator
implements Iterator<List<String>> {
    private static final Logger logger = LoggerFactory.getLogger(StructureContentIterator.class);
    private static final String PDB_FETCH_URL = "https://files.rcsb.org/download/%s.pdb";
    private static final String PDB_BASE_PATH = "data/structures/divided/pdb";
    private StructureParser.LocalPDB localPdb;
    private List<URL> identifiers;
    private List<Path> paths;
    private List<String> pdbIds;
    private Iterator<String> pdbIdIterator;
    private String currentPdbIdentifier;
    private List<String> chains;
    private Iterator<String> chainIterator;
    private String currentChain;
    private Iterator<URL> currentURL;
    private Iterator<Path> currentPath;
    private SourceLocation location;
    private String currentSource;
    private int progressCounter;

    public StructureContentIterator(String identifier) {
        this(String.class, Collections.singletonList(identifier));
    }

    public StructureContentIterator(Path path) {
        this(Path.class, Collections.singletonList(path));
    }

    public StructureContentIterator(File file) {
        this(File.class, Collections.singletonList(file));
    }

    public StructureContentIterator(StructureParser.LocalPDB localPdb, String identifier) {
        this.localPdb = localPdb;
        this.paths = new ArrayList<Path>();
        this.pdbIds = new ArrayList<String>();
        this.prepareLocalPDB(Collections.singletonList(identifier));
    }

    public StructureContentIterator(StructureParser.LocalPDB localPdb, List<String> identifiers) {
        this.localPdb = localPdb;
        this.paths = new ArrayList<Path>();
        this.pdbIds = new ArrayList<String>();
        this.prepareLocalPDB(identifiers);
    }

    public StructureContentIterator(List<Pair<String>> mapping, StructureParser.LocalPDB localPDB) {
        this.localPdb = localPDB;
        this.paths = new ArrayList<Path>();
        this.pdbIds = new ArrayList<String>();
        this.chains = new ArrayList<String>();
        this.prepareMappedLocalPDB(mapping);
    }

    public StructureContentIterator(List<Pair<String>> mapping) {
        this.paths = new ArrayList<Path>();
        this.identifiers = new ArrayList<URL>();
        this.pdbIds = new ArrayList<String>();
        this.chains = new ArrayList<String>();
        this.prepareMappedIdentifiers(mapping);
    }

    public StructureContentIterator(Class<?> context, List<?> identifiers) {
        this.paths = new ArrayList<Path>();
        this.identifiers = new ArrayList<URL>();
        this.pdbIds = new ArrayList<String>();
        this.progressCounter = 0;
        if (context.equals(String.class)) {
            this.prepareIdentifiers(identifiers);
        } else if (context.equals(Path.class)) {
            this.prepareOfflinePaths(identifiers);
        } else if (context.equals(File.class)) {
            this.prepareOfflineFiles(identifiers);
        }
    }

    private void prepareIdentifiers(List<String> identifiers) {
        for (String identifier : identifiers) {
            try {
                this.identifiers.add(new URL(String.format(PDB_FETCH_URL, identifier)));
                this.pdbIds.add(identifier);
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException("Malformed URL to PDB", e);
            }
        }
        this.currentURL = this.identifiers.iterator();
        this.pdbIdIterator = this.pdbIds.iterator();
        this.location = SourceLocation.ONLINE;
    }

    private void prepareOfflinePaths(List<Path> paths) {
        this.paths = paths;
        this.currentPath = this.paths.iterator();
        this.location = SourceLocation.OFFLINE;
    }

    private void prepareOfflineFiles(List<File> files) {
        for (File file : files) {
            this.paths.add(file.toPath());
        }
        this.currentPath = this.paths.iterator();
        this.location = SourceLocation.OFFLINE;
    }

    private void prepareLocalPDB(List<String> identifiers) {
        for (String identifier : identifiers) {
            this.paths.add(this.assemblePath(identifier));
            this.pdbIds.add(identifier);
        }
        this.currentPath = this.paths.iterator();
        this.pdbIdIterator = this.pdbIds.iterator();
        this.location = SourceLocation.OFFLINE;
    }

    private void prepareMappedLocalPDB(List<Pair<String>> mapping) {
        for (Pair<String> pair : mapping) {
            this.paths.add(this.assemblePath((String)pair.getFirst()));
            this.pdbIds.add((String)pair.getFirst());
            this.chains.add((String)pair.getSecond());
        }
        this.currentPath = this.paths.iterator();
        this.pdbIdIterator = this.pdbIds.iterator();
        this.chainIterator = this.chains.iterator();
        this.location = SourceLocation.OFFLINE;
    }

    private void prepareMappedIdentifiers(List<Pair<String>> mapping) {
        for (Pair<String> pair : mapping) {
            try {
                this.identifiers.add(new URL(String.format(PDB_FETCH_URL, pair.getFirst())));
                this.pdbIds.add((String)pair.getFirst());
                this.chains.add((String)pair.getSecond());
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException("Malformed URL to PDB", e);
            }
        }
        this.currentURL = this.identifiers.iterator();
        this.pdbIdIterator = this.pdbIds.iterator();
        this.chainIterator = this.chains.iterator();
        this.location = SourceLocation.ONLINE;
    }

    private Path assemblePath(String identifier) {
        return this.localPdb.getLocalPdbPath().resolve(Paths.get("data/structures/divided/pdb/" + identifier.substring(1, identifier.length() - 1).toLowerCase() + "/pdb" + identifier.toLowerCase() + ".ent.gz", new String[0]));
    }

    public InputStream readPacked(Path path) throws IOException {
        return new GZIPInputStream(new FileInputStream(path.toFile()));
    }

    public int getNumberOfQueuedStructures() {
        if (this.location == SourceLocation.ONLINE) {
            return this.identifiers.size();
        }
        return this.paths.size();
    }

    public int getNumberOfRemainingStructures() {
        if (this.location == SourceLocation.ONLINE) {
            return this.identifiers.size() - this.progressCounter;
        }
        return this.paths.size() - this.progressCounter;
    }

    public String getCurrentPdbIdentifier() {
        if (this.currentPdbIdentifier != null) {
            return this.currentPdbIdentifier;
        }
        throw new IllegalStateException("Unable to retrieve the PDB Identifier in the current state.");
    }

    public String getCurrentChainIdentifier() {
        if (this.currentChain != null) {
            return this.currentChain;
        }
        throw new IllegalStateException("Unable to retrieve chainIdentifier Identifier in the current state.");
    }

    public String getCurrentSource() {
        return this.currentSource;
    }

    @Override
    public boolean hasNext() {
        if (this.location == SourceLocation.ONLINE) {
            return this.currentURL.hasNext();
        }
        return this.currentPath.hasNext();
    }

    @Override
    public List<String> next() {
        if (this.pdbIds != null && !this.pdbIds.isEmpty()) {
            this.currentPdbIdentifier = this.pdbIdIterator.next();
            if (this.chains != null) {
                this.currentChain = this.chainIterator.next();
                logger.debug("parsing structure {}/{}", (Object)this.currentPdbIdentifier, (Object)this.currentChain);
            } else {
                logger.debug("parsing structure {}", (Object)this.currentPdbIdentifier);
            }
        }
        if (this.location == SourceLocation.OFFLINE) {
            try {
                Path path = this.currentPath.next();
                this.currentSource = path.getFileName().toString().replaceFirst("[.][^.]+$", "");
                if (path.toString().endsWith(".ent.gz")) {
                    List<String> list = this.fetchLines(this.readPacked(path));
                    return list;
                }
                List<String> list = this.fetchLines(Files.newInputStream(path, new OpenOption[0]));
                return list;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not open input stream for path.", e);
            }
            finally {
                ++this.progressCounter;
            }
        }
        try {
            URL url = this.currentURL.next();
            this.currentSource = url.getFile();
            List<String> list = this.fetchLines(url.openStream());
            return list;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not open input stream for URL. The PDBID \"" + this.currentPdbIdentifier + "\" does not seem to exist", e);
        }
        finally {
            ++this.progressCounter;
        }
    }

    /*
     * Exception decompiling
     */
    private List<String> fetchLines(InputStream inputStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static enum SourceLocation {
        ONLINE,
        OFFLINE;

    }
}

