/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.parser.pdb.structures;

import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.HeaderToken;
import de.bioforscher.singa.chemistry.physical.branches.BranchSubstructure;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureWriter {
    private static final Logger logger = LoggerFactory.getLogger(StructureWriter.class);

    private StructureWriter() {
    }

    public static void writeBranchSubstructure(BranchSubstructure<?> branchSubstructure, Path outputPath) throws IOException {
        logger.info("writing {} to {}", branchSubstructure, (Object)outputPath);
        StructureWriter.writeLeafSubstructures(branchSubstructure.getLeafSubstructures(), outputPath);
    }

    public static void writeLeafSubstructures(List<LeafSubstructure<?, ?>> leafSubstructures, Path outputPath) throws IOException {
        logger.info("writing {} leaf substructures to {}", (Object)leafSubstructures.size(), (Object)outputPath);
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        Optional<String> headerContent = StructureWriter.createHeaderContent(leafSubstructures);
        String pdbFileContent = leafSubstructures.stream().map(LeafSubstructure::getPdbLines).flatMap(Collection::stream).collect(Collectors.joining("\n"));
        if (headerContent.isPresent()) {
            pdbFileContent = headerContent.get() + "\n" + pdbFileContent;
        }
        Files.write(outputPath, pdbFileContent.getBytes(), new OpenOption[0]);
    }

    private static Optional<String> createHeaderContent(List<LeafSubstructure<?, ?>> leafSubstructures) {
        StringJoiner headerContent = new StringJoiner("\n");
        String pdbIdentifier = leafSubstructures.iterator().next().getPdbIdentifier();
        if (!pdbIdentifier.equals("0000")) {
            headerContent.add(HeaderToken.ID_CODE.createHeaderLine(pdbIdentifier));
        }
        if (!headerContent.toString().isEmpty()) {
            return Optional.ofNullable(headerContent.toString());
        }
        return Optional.empty();
    }
}

