/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.parser.pdb.structures.tokens;

import de.bioforscher.singa.chemistry.descriptive.elements.Element;
import de.bioforscher.singa.chemistry.descriptive.elements.ElementProvider;
import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.Justification;
import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.PDBToken;
import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.atoms.RegularAtom;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.core.utility.Range;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public enum AtomToken implements PDBToken
{
    RECORD_TYPE((Range<Integer>)Range.of((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)), Justification.LEFT),
    ATOM_SERIAL((Range<Integer>)Range.of((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(11)), Justification.RIGHT),
    ATOM_NAME((Range<Integer>)Range.of((Comparable)Integer.valueOf(13), (Comparable)Integer.valueOf(16)), Justification.LEFT),
    ALTERNATE_LOCATION_INDICATOR((Range<Integer>)Range.of((Comparable)Integer.valueOf(17)), Justification.LEFT),
    RESIDUE_NAME((Range<Integer>)Range.of((Comparable)Integer.valueOf(18), (Comparable)Integer.valueOf(20)), Justification.RIGHT),
    CHAIN_IDENTIFIER((Range<Integer>)Range.of((Comparable)Integer.valueOf(22)), Justification.LEFT),
    RESIDUE_SERIAL((Range<Integer>)Range.of((Comparable)Integer.valueOf(23), (Comparable)Integer.valueOf(26)), Justification.RIGHT),
    RESIDUE_INSERTION((Range<Integer>)Range.of((Comparable)Integer.valueOf(27)), Justification.LEFT),
    X_COORDINATE((Range<Integer>)Range.of((Comparable)Integer.valueOf(31), (Comparable)Integer.valueOf(38)), Justification.RIGHT),
    Y_COORDINATE((Range<Integer>)Range.of((Comparable)Integer.valueOf(39), (Comparable)Integer.valueOf(46)), Justification.RIGHT),
    Z_COORDINATE((Range<Integer>)Range.of((Comparable)Integer.valueOf(47), (Comparable)Integer.valueOf(54)), Justification.RIGHT),
    OCCUPANCY((Range<Integer>)Range.of((Comparable)Integer.valueOf(55), (Comparable)Integer.valueOf(60)), Justification.RIGHT),
    TEMPERATURE_FACTOR((Range<Integer>)Range.of((Comparable)Integer.valueOf(61), (Comparable)Integer.valueOf(66)), Justification.RIGHT),
    ELEMENT_SYMBOL((Range<Integer>)Range.of((Comparable)Integer.valueOf(77), (Comparable)Integer.valueOf(78)), Justification.RIGHT),
    ELEMENT_CHARGE((Range<Integer>)Range.of((Comparable)Integer.valueOf(79), (Comparable)Integer.valueOf(80)), Justification.LEFT);

    public static final Pattern RECORD_PATTERN;
    private static DecimalFormat coordinateFormat;
    private static DecimalFormat temperatureFormat;
    private final Range<Integer> columns;
    private final Justification justification;

    private AtomToken(Range<Integer> columns, Justification justification) {
        this.columns = columns;
        this.justification = justification;
    }

    public static Atom assembleAtom(String atomLine) {
        Double x = Double.valueOf(X_COORDINATE.extract(atomLine));
        Double y = Double.valueOf(Y_COORDINATE.extract(atomLine));
        Double z = Double.valueOf(Z_COORDINATE.extract(atomLine));
        Vector3D coordinates = new Vector3D(x.doubleValue(), y.doubleValue(), z.doubleValue());
        Integer atomSerial = Integer.valueOf(ATOM_SERIAL.extract(atomLine));
        String atomName = ATOM_NAME.extract(atomLine);
        Element element = ElementProvider.getElementBySymbol(ELEMENT_SYMBOL.extract(atomLine)).orElse(ElementProvider.UNKOWN);
        return new RegularAtom(atomSerial, element, atomName, coordinates);
    }

    public static List<String> assemblePDBLine(LeafSubstructure<?, ?> leaf) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Atom atom : leaf.getNodes()) {
            StringBuilder currentLine = new StringBuilder();
            if (!leaf.isAnnotatedAsHetAtom()) {
                currentLine.append(RECORD_TYPE.createTokenString("ATOM"));
            } else {
                currentLine.append(RECORD_TYPE.createTokenString("HETATM"));
            }
            currentLine.append(ATOM_SERIAL.createTokenString(String.valueOf(atom.getIdentifier()))).append(" ").append(AtomToken.formatAtomName(atom)).append(" ").append(RESIDUE_NAME.createTokenString(leaf.getName().toUpperCase())).append(" ").append(leaf.getChainIdentifier()).append(RESIDUE_SERIAL.createTokenString(String.valueOf(leaf.getIdentifier()))).append("    ").append(X_COORDINATE.createTokenString(coordinateFormat.format(((Vector3D)atom.getPosition()).getX()))).append(Y_COORDINATE.createTokenString(coordinateFormat.format(((Vector3D)atom.getPosition()).getY()))).append(Z_COORDINATE.createTokenString(coordinateFormat.format(((Vector3D)atom.getPosition()).getZ()))).append("  1.00").append("  0.00").append("          ").append(ELEMENT_SYMBOL.createTokenString(atom.getElement().getSymbol())).append(AtomToken.formatCharge(atom.getElement()));
            lines.add(currentLine.toString());
        }
        return lines;
    }

    static String formatAtomName(Atom atom) {
        String fullName = null;
        String name = atom.getAtomNameString();
        String element = atom.getElement().getSymbol();
        if (name.length() == 4) {
            fullName = name;
        } else if (name.length() == 3) {
            fullName = " " + name;
        } else if (name.length() == 2) {
            fullName = element.equals("C") || element.equals("N") || element.equals("O") || element.equals("P") || element.equals("S") ? " " + name + " " : name + "  ";
        } else if (name.length() == 1) {
            fullName = " " + name + "  ";
        }
        return fullName;
    }

    private static String formatCharge(Element element) {
        int charge = element.getCharge();
        if (charge > 0) {
            return String.valueOf(charge) + "+";
        }
        if (charge < 0) {
            return String.valueOf(Math.abs(charge)) + "-";
        }
        return "  ";
    }

    @Override
    public Range<Integer> getColumns() {
        return this.columns;
    }

    @Override
    public Pattern getRecordNamePattern() {
        return RECORD_PATTERN;
    }

    private String createTokenString(String content) {
        int totalLength = (Integer)this.columns.getUpperBound() - (Integer)this.columns.getLowerBound() - content.length();
        StringBuilder filler = new StringBuilder();
        for (int i = 0; i < totalLength + 1; ++i) {
            filler.append(" ");
        }
        if (this.justification == Justification.LEFT) {
            return content + filler;
        }
        return filler + content;
    }

    static {
        RECORD_PATTERN = Pattern.compile("^(ATOM|HETATM).*");
        coordinateFormat = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
        temperatureFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    }
}

