/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.parser.pdb.structures.tokens;

import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.PDBToken;
import de.bioforscher.singa.core.utility.Range;
import java.util.regex.Pattern;

public enum HeaderToken implements PDBToken
{
    CLASSIFICATION((Range<Integer>)Range.of((Comparable)Integer.valueOf(11), (Comparable)Integer.valueOf(50))),
    DEPOSITION_DATE((Range<Integer>)Range.of((Comparable)Integer.valueOf(51), (Comparable)Integer.valueOf(59))),
    ID_CODE((Range<Integer>)Range.of((Comparable)Integer.valueOf(63), (Comparable)Integer.valueOf(66)));

    public static final Pattern RECORD_PATTERN;
    private final Range<Integer> columns;

    private HeaderToken(Range<Integer> columns) {
        this.columns = columns;
    }

    @Override
    public Pattern getRecordNamePattern() {
        return RECORD_PATTERN;
    }

    @Override
    public Range<Integer> getColumns() {
        return this.columns;
    }

    public String createHeaderLine(String content) {
        return "HEADER" + String.format("%" + ((Integer)this.getColumns().getLowerBound() - content.length() + 1) + "s", content.toUpperCase());
    }

    static {
        RECORD_PATTERN = Pattern.compile("^HEADER.*");
    }
}

