/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.atoms.representations;

import de.bioforscher.singa.chemistry.descriptive.elements.ElementProvider;
import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.atoms.AtomName;
import de.bioforscher.singa.chemistry.physical.atoms.UncertainAtom;
import de.bioforscher.singa.chemistry.physical.atoms.representations.RepresentationScheme;
import de.bioforscher.singa.chemistry.physical.atoms.representations.RepresentationSchemeType;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntityFilter;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vectors3D;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepresentationScheme
implements RepresentationScheme {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRepresentationScheme.class);

    Atom determineCentroid(LeafSubstructure<?, ?> leafSubstructure) {
        if (leafSubstructure.containsAtomWithName(AtomName.CO)) {
            return leafSubstructure.getAtomByName(AtomName.CO);
        }
        logger.debug("obtaining centroid representation for {}", leafSubstructure);
        return new UncertainAtom(leafSubstructure.getAllAtoms().get(0).getIdentifier(), ElementProvider.UNKOWN, RepresentationSchemeType.CENTROID.getAtomNameString(), Vectors3D.getCentroid((Collection)leafSubstructure.getAllAtoms().stream().filter(StructuralEntityFilter.AtomFilter.isHydrogen().negate()).map(Node::getPosition).collect(Collectors.toList())));
    }
}

