/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.atoms.representations;

import de.bioforscher.singa.chemistry.descriptive.elements.ElementProvider;
import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.atoms.AtomName;
import de.bioforscher.singa.chemistry.physical.atoms.UncertainAtom;
import de.bioforscher.singa.chemistry.physical.atoms.representations.AbstractRepresentationScheme;
import de.bioforscher.singa.chemistry.physical.atoms.representations.BetaCarbonRepresentationScheme;
import de.bioforscher.singa.chemistry.physical.atoms.representations.RepresentationSchemeType;
import de.bioforscher.singa.chemistry.physical.families.AminoAcidFamily;
import de.bioforscher.singa.chemistry.physical.leaves.AminoAcid;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntityFilter;
import de.bioforscher.singa.chemistry.physical.model.Structures;
import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.mathematics.vectors.Vectors;
import java.util.stream.Collectors;

public class LastHeavySidechainRepresentationScheme
extends AbstractRepresentationScheme {
    @Override
    public Atom determineRepresentingAtom(LeafSubstructure<?, ?> leafSubstructure) {
        if (leafSubstructure.containsAtomWithName(AtomName.LH)) {
            return leafSubstructure.getAtomByName(AtomName.LH);
        }
        if (!(leafSubstructure instanceof AminoAcid) || leafSubstructure.getAllAtoms().stream().noneMatch(StructuralEntityFilter.AtomFilter.isAlphaCarbon())) {
            return this.determineCentroid(leafSubstructure);
        }
        if (leafSubstructure.getFamily() == AminoAcidFamily.GLYCINE) {
            return new BetaCarbonRepresentationScheme().determineCentroid(leafSubstructure);
        }
        if (leafSubstructure.getAllAtoms().stream().filter(StructuralEntityFilter.AtomFilter.isSideChain()).count() == 0L || leafSubstructure.getAllAtoms().stream().filter(StructuralEntityFilter.AtomFilter.isAlphaCarbon()).count() == 0L) {
            return this.determineCentroid(leafSubstructure);
        }
        LabeledSymmetricMatrix atomDistanceMatrix = Structures.calculateDistanceMatrix(leafSubstructure.getAllAtoms().stream().filter(StructuralEntityFilter.AtomFilter.isSideChain().and(StructuralEntityFilter.AtomFilter.isHydrogen().negate()).or(StructuralEntityFilter.AtomFilter.isAlphaCarbon())).collect(Collectors.toList()));
        if (atomDistanceMatrix.getRowDimension() == 1) {
            return (Atom)atomDistanceMatrix.getColumnLabel(0);
        }
        int maximalElementIndex = Vectors.getIndexWithMaximalElement((Vector)atomDistanceMatrix.getRowByLabel((Object)((AminoAcid)leafSubstructure).getAlphaCarbon()));
        Atom referenceAtom = (Atom)atomDistanceMatrix.getColumnLabel(maximalElementIndex);
        return new UncertainAtom(leafSubstructure.getAllAtoms().get(leafSubstructure.getAllAtoms().size() - 1).getIdentifier(), ElementProvider.UNKOWN, RepresentationSchemeType.LAST_HEAVY_SIDE_CHAIN.getAtomNameString(), (Vector3D)referenceAtom.getPosition());
    }

    @Override
    public RepresentationSchemeType getType() {
        return RepresentationSchemeType.LAST_HEAVY_SIDE_CHAIN;
    }
}

