/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.atoms.representations;

import de.bioforscher.singa.chemistry.physical.atoms.representations.AlphaCarbonRepresentationScheme;
import de.bioforscher.singa.chemistry.physical.atoms.representations.RepresentationScheme;
import de.bioforscher.singa.chemistry.physical.atoms.representations.RepresentationSchemeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepresentationSchemeFactory {
    protected static final Logger logger = LoggerFactory.getLogger(RepresentationSchemeFactory.class);
    private static final RepresentationSchemeType FALLBACK_REPRESENTATION_SCHEME_TYPE = RepresentationSchemeType.CA;

    private RepresentationSchemeFactory() {
    }

    public static RepresentationScheme createRepresentationScheme(RepresentationSchemeType representationSchemeType) {
        logger.debug("creating representation scheme for type {}", (Object)representationSchemeType);
        try {
            return representationSchemeType.getCompatibleRepresentationScheme().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.warn("failed to create representation scheme for type {}, defaulting to alpha carbon", (Object)representationSchemeType, (Object)e);
            return new AlphaCarbonRepresentationScheme();
        }
    }
}

