/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.branches;

import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.branches.Chain;
import de.bioforscher.singa.chemistry.physical.branches.StructuralMotif;
import de.bioforscher.singa.chemistry.physical.leaves.AminoAcid;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.leaves.Nucleotide;
import de.bioforscher.singa.chemistry.physical.model.Bond;
import de.bioforscher.singa.chemistry.physical.model.LeafIdentifier;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntityFilter;
import de.bioforscher.singa.chemistry.physical.model.Structure;
import de.bioforscher.singa.chemistry.physical.model.Substructure;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import de.bioforscher.singa.mathematics.matrices.SymmetricMatrix;
import de.bioforscher.singa.mathematics.metrics.model.VectorMetricProvider;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.mathematics.vectors.Vectors3D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public abstract class BranchSubstructure<SubstructureType extends Substructure<SubstructureType>>
implements Substructure<SubstructureType> {
    public int identifier;
    protected Map<Integer, Substructure<?>> substructures;
    private int nextNodeIdentifier;
    private int nextEdgeIdentifier;
    private List<SubstructureType> neighbours;
    private Map<Integer, Atom> nodes;
    private Map<Integer, Bond> edges;

    public BranchSubstructure(int identifier) {
        this.identifier = identifier;
        this.neighbours = new ArrayList<SubstructureType>();
        this.substructures = new TreeMap();
        this.nodes = new TreeMap<Integer, Atom>();
        this.edges = new HashMap<Integer, Bond>();
    }

    public BranchSubstructure(BranchSubstructure<SubstructureType> branchSubstructure) {
        this.identifier = branchSubstructure.getIdentifier();
        this.substructures = new TreeMap();
        for (Substructure<?> structure : branchSubstructure.substructures.values()) {
            this.substructures.put(structure.getIdentifier(), (Substructure<?>)structure.getCopy());
        }
        this.nodes = new TreeMap<Integer, Atom>();
        for (Atom atom : branchSubstructure.nodes.values()) {
            this.nodes.put(atom.getIdentifier(), atom.getCopy());
        }
        this.edges = new HashMap<Integer, Bond>();
        for (Bond bond : branchSubstructure.edges.values()) {
            Bond edgeCopy = bond.getCopy();
            Atom sourceCopy = this.nodes.get(((Atom)bond.getSource()).getIdentifier());
            Atom targetCopy = this.nodes.get(((Atom)bond.getTarget()).getIdentifier());
            this.addEdgeBetween(edgeCopy, sourceCopy, targetCopy);
        }
        this.neighbours = new ArrayList<SubstructureType>();
    }

    public LabeledSymmetricMatrix<LeafSubstructure<?, ?>> getDistanceMatrix() {
        List<LeafSubstructure<?, ?>> leafSubstructures = this.getLeafSubstructures();
        SymmetricMatrix distanceMatrix = VectorMetricProvider.EUCLIDEAN_METRIC.calculateDistancesPairwise(leafSubstructures.stream().map(LeafSubstructure::getPosition).collect(Collectors.toList()));
        LabeledSymmetricMatrix labeledDistanceMatrix = new LabeledSymmetricMatrix(distanceMatrix.getElements());
        labeledDistanceMatrix.setRowLabels(leafSubstructures);
        return labeledDistanceMatrix;
    }

    public LabeledSymmetricMatrix<LeafSubstructure<?, ?>> getSquaredDistanceMatrix() {
        List<LeafSubstructure<?, ?>> leafSubstructures = this.getLeafSubstructures();
        SymmetricMatrix distanceMatrix = VectorMetricProvider.SQUARED_EUCLIDEAN_METRIC.calculateDistancesPairwise(leafSubstructures.stream().map(LeafSubstructure::getPosition).collect(Collectors.toList()));
        LabeledSymmetricMatrix labeledDistanceMatrix = new LabeledSymmetricMatrix(distanceMatrix.getElements());
        labeledDistanceMatrix.setRowLabels(leafSubstructures);
        return labeledDistanceMatrix;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public Vector3D getPosition() {
        return Vectors3D.getCentroid((Collection)this.getAllAtoms().stream().map(Node::getPosition).collect(Collectors.toList()));
    }

    public int nextNodeIdentifier() {
        return this.nextNodeIdentifier++;
    }

    public void addNeighbour(SubstructureType substructure) {
        this.neighbours.add(substructure);
    }

    public List<SubstructureType> getNeighbours() {
        return this.neighbours;
    }

    public int getDegree() {
        return this.neighbours.size();
    }

    public List<Atom> getNodes() {
        return new ArrayList<Atom>(this.nodes.values());
    }

    public Atom getNode(int identifier) {
        return this.nodes.values().stream().filter(atom -> atom.getIdentifier() == identifier).findAny().orElseThrow(IllegalArgumentException::new);
    }

    public int addNode(Atom atom) {
        this.nodes.put(atom.getIdentifier(), atom);
        return atom.getIdentifier();
    }

    public void addAllNodes(Collection<Atom> atoms) {
        atoms.forEach(this::addNode);
    }

    public int getNextSubstructureIdentifier() {
        if (this.substructures.keySet().isEmpty()) {
            return 0;
        }
        return Collections.max(this.substructures.keySet()) + 1;
    }

    public void addSubstructure(Substructure substructure) {
        this.substructures.put(substructure.getIdentifier(), substructure);
    }

    public void removeSubstructure(int identifier) {
        List<Integer> atomsToBeRemoved = this.substructures.get(identifier).getAllAtoms().stream().map(Node::getIdentifier).collect(Collectors.toList());
        atomsToBeRemoved.forEach(this::removeNode);
        this.substructures.entrySet().removeIf(substructure -> ((Substructure)substructure.getValue()).getIdentifier() == identifier);
    }

    public void removeLeafSubstructure(LeafIdentifier leafIdentifier) {
        ArrayList atomsToBeRemoved = new ArrayList();
        this.getLeafSubstructures().stream().filter(leafSubstructure -> leafSubstructure.getLeafIdentifier().equals(leafIdentifier)).findFirst().ifPresent(leafSubstructure -> atomsToBeRemoved.addAll(leafSubstructure.getAllAtoms().stream().map(Node::getIdentifier).collect(Collectors.toList())));
        atomsToBeRemoved.forEach(this::removeNode);
        if (this instanceof Chain || this instanceof StructuralMotif) {
            this.substructures.entrySet().removeIf(substructure -> ((Substructure)substructure.getValue()).getIdentifier() == leafIdentifier.getIdentifier());
        } else {
            this.getBranchSubstructures().stream().filter(StructuralEntityFilter.BranchFilter.isChain()).map(Chain.class::cast).filter(chain -> chain.getChainIdentifier().equals(leafIdentifier.getChainIdentifer())).findFirst().ifPresent(chain -> chain.removeSubstructure(leafIdentifier.getIdentifier()));
        }
    }

    public void addAllSubstructures(List<Substructure> substructures) {
        substructures.forEach(substructure -> this.substructures.put(substructure.getIdentifier(), (Substructure<?>)substructure));
    }

    public Optional<Substructure> getSubstructure(int identifier) {
        return Optional.ofNullable(this.substructures.getOrDefault(identifier, null));
    }

    public List<Substructure> getSubstructures() {
        return new ArrayList<Substructure>(this.substructures.values());
    }

    public void removeNode(int identifier) {
        this.nodes.entrySet().removeIf(node -> ((Atom)node.getValue()).getIdentifier() == identifier);
        this.edges.entrySet().removeIf(edge -> ((Bond)((Object)((Object)edge.getValue()))).containsNode(identifier));
    }

    public int nextEdgeIdentifier() {
        return this.nextEdgeIdentifier++;
    }

    public Set<Bond> getEdges() {
        return new HashSet<Bond>(this.edges.values());
    }

    public Bond getEdge(int identifier) {
        return this.edges.get(identifier);
    }

    public int addEdgeBetween(int identifier, Atom source, Atom target) {
        return this.addEdgeBetween(new Bond(identifier), source, target);
    }

    public int addEdgeBetween(Bond edge, Atom source, Atom target) {
        edge.setSource(source);
        edge.setTarget(target);
        this.edges.put(edge.getIdentifier(), edge);
        source.addNeighbour(target);
        target.addNeighbour(source);
        return edge.getIdentifier();
    }

    public int addEdgeBetween(Atom source, Atom target) {
        return this.addEdgeBetween(this.nextEdgeIdentifier(), source, target);
    }

    @Override
    public List<Atom> getAllAtoms() {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Substructure<?> substructure : this.substructures.values()) {
            atoms.addAll(substructure.getAllAtoms());
        }
        atoms.addAll(this.getNodes());
        return atoms;
    }

    public List<AminoAcid> getAminoAcids() {
        return this.getLeafSubstructures().stream().filter(StructuralEntityFilter.LeafFilter.isAminoAcid()).map(AminoAcid.class::cast).collect(Collectors.toList());
    }

    public List<Nucleotide> getNucleotides() {
        return this.getLeafSubstructures().stream().filter(StructuralEntityFilter.LeafFilter.isNucleotide()).map(Nucleotide.class::cast).collect(Collectors.toList());
    }

    public boolean containsNode(Object node) {
        return this.nodes.containsValue(node);
    }

    public boolean containsEdge(Object edge) {
        return this.edges.containsValue(edge);
    }

    public List<BranchSubstructure<?>> getBranchSubstructures() {
        ArrayList branchSubStructures = new ArrayList();
        for (Substructure<?> substructure : this.substructures.values()) {
            if (!(substructure instanceof BranchSubstructure)) continue;
            BranchSubstructure branchSubstructure = (BranchSubstructure)substructure;
            branchSubStructures.add(branchSubstructure);
            branchSubStructures.addAll(branchSubstructure.getBranchSubstructures());
        }
        return branchSubStructures;
    }

    public List<LeafSubstructure<?, ?>> getLeafSubstructures() {
        ArrayList leafSubstructures = new ArrayList();
        for (Substructure<?> substructure : this.substructures.values()) {
            if (substructure instanceof LeafSubstructure) {
                leafSubstructures.add((LeafSubstructure)substructure);
                continue;
            }
            if (!(substructure instanceof BranchSubstructure)) continue;
            leafSubstructures.addAll(((BranchSubstructure)substructure).getLeafSubstructures());
        }
        return leafSubstructures;
    }

    public Structure toStructure() {
        Structure structure = new Structure();
        structure.addSubstructure(this);
        return structure;
    }

    @Override
    public abstract SubstructureType getCopy();
}

