/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.branches;

import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.atoms.AtomName;
import de.bioforscher.singa.chemistry.physical.branches.BranchSubstructure;
import de.bioforscher.singa.chemistry.physical.leaves.AminoAcid;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.leaves.Nucleotide;
import de.bioforscher.singa.chemistry.physical.model.Bond;
import de.bioforscher.singa.chemistry.physical.model.Substructure;
import de.bioforscher.singa.core.utility.Nameable;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class Chain
extends BranchSubstructure<Chain>
implements Nameable {
    private Set<Integer> consecutiveIdentifier;
    private String chainIdentifier;

    public Chain(int graphIdentifier) {
        super(graphIdentifier);
        this.consecutiveIdentifier = new TreeSet<Integer>();
    }

    public Chain(Chain chain) {
        this(chain.getIdentifier());
        this.chainIdentifier = chain.chainIdentifier;
        for (Substructure structure : chain.getSubstructures()) {
            this.addSubstructure((Substructure)structure.getCopy());
        }
        TreeMap<Integer, Atom> atoms = new TreeMap<Integer, Atom>();
        for (Atom atom : this.getAllAtoms()) {
            atoms.put(atom.getIdentifier(), atom);
        }
        for (Bond bond : chain.getEdges()) {
            Bond edgeCopy = bond.getCopy();
            Atom sourceCopy = (Atom)atoms.get(((Atom)bond.getSource()).getIdentifier());
            Atom targetCopy = (Atom)atoms.get(((Atom)bond.getTarget()).getIdentifier());
            this.addEdgeBetween(edgeCopy, sourceCopy, targetCopy);
        }
    }

    public Chain() {
        super(0);
    }

    public String getChainIdentifier() {
        return this.chainIdentifier;
    }

    public void setChainIdentifier(String chainIdentifier) {
        this.chainIdentifier = chainIdentifier;
    }

    public void connectChainBackbone() {
        LeafSubstructure<?, ?> lastSubstructure = null;
        for (LeafSubstructure<?, ?> currentSubstructure : this.getLeafSubstructures()) {
            if (lastSubstructure != null) {
                if (lastSubstructure instanceof AminoAcid && currentSubstructure instanceof AminoAcid) {
                    this.connectPeptideBonds((AminoAcid)lastSubstructure, (AminoAcid)currentSubstructure);
                } else if (lastSubstructure instanceof Nucleotide && currentSubstructure instanceof Nucleotide) {
                    this.connectNucleotideBonds((Nucleotide)lastSubstructure, (Nucleotide)currentSubstructure);
                }
            }
            lastSubstructure = currentSubstructure;
        }
    }

    public void connectPeptideBonds(AminoAcid source, AminoAcid target) {
        Bond bond = new Bond(this.nextEdgeIdentifier());
        if (source.containsAtomWithName(AtomName.C) && target.containsAtomWithName(AtomName.N)) {
            this.addEdgeBetween(bond, source.getBackboneCarbon(), target.getBackboneNitrogen());
        }
    }

    public void connectNucleotideBonds(Nucleotide source, Nucleotide target) {
        Bond bond = new Bond(this.nextEdgeIdentifier());
        if (source.containsAtomWithName(AtomName.O3Pr) && target.containsAtomWithName(AtomName.P)) {
            this.addEdgeBetween(bond, source.getAtomByName(AtomName.O3Pr), target.getAtomByName(AtomName.P));
        }
    }

    public void addToConsecutivePart(LeafSubstructure<?, ?> leafSubstructure) {
        this.consecutiveIdentifier.add(leafSubstructure.getIdentifier());
        this.addSubstructure(leafSubstructure);
    }

    public List<LeafSubstructure<?, ?>> getConsecutivePart() {
        return this.consecutiveIdentifier.stream().map(this::getLeafSubstructure).collect(Collectors.toList());
    }

    public List<LeafSubstructure<?, ?>> getNonConsecutivePart() {
        return this.getLeafSubstructures().stream().filter(leafSubstructure -> !this.consecutiveIdentifier.contains(leafSubstructure.getIdentifier())).map(substructure -> substructure).collect(Collectors.toList());
    }

    @Override
    public List<LeafSubstructure<?, ?>> getLeafSubstructures() {
        return this.substructures.values().stream().map(substructure -> (LeafSubstructure)substructure).collect(Collectors.toList());
    }

    public LeafSubstructure<?, ?> getLeafSubstructure(int identifier) {
        return (LeafSubstructure)this.substructures.get(identifier);
    }

    public String getName() {
        return String.valueOf(this.chainIdentifier);
    }

    @Override
    public Chain getCopy() {
        return new Chain(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chain chain = (Chain)o;
        return this.chainIdentifier != null ? this.chainIdentifier.equals(chain.chainIdentifier) : chain.chainIdentifier == null;
    }

    public int hashCode() {
        return this.chainIdentifier != null ? this.chainIdentifier.hashCode() : 0;
    }

    public String toString() {
        return this.getLeafSubstructures().stream().findAny().map(LeafSubstructure::getPdbIdentifier).orElse("") + "_" + this.chainIdentifier;
    }

    public void setPosition(Vector3D position) {
        throw new UnsupportedOperationException();
    }
}

