/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.branches;

import de.bioforscher.singa.chemistry.physical.branches.BranchSubstructure;
import de.bioforscher.singa.chemistry.physical.families.AminoAcidFamily;
import de.bioforscher.singa.chemistry.physical.families.MatcherFamily;
import de.bioforscher.singa.chemistry.physical.families.NucleotideFamily;
import de.bioforscher.singa.chemistry.physical.leaves.AminoAcid;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.leaves.Nucleotide;
import de.bioforscher.singa.chemistry.physical.model.LeafIdentifier;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntityFilter;
import de.bioforscher.singa.chemistry.physical.model.Structure;
import de.bioforscher.singa.chemistry.physical.model.Substructure;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class StructuralMotif
extends BranchSubstructure<StructuralMotif> {
    private static final int DEFAULT_IDENTIFIER = 0;
    public LinkedHashMap<Integer, Substructure<?>> orderedSubstructures = new LinkedHashMap();

    public StructuralMotif(int identifier) {
        super(identifier);
    }

    public StructuralMotif(StructuralMotif branchSubstructure) {
        super(branchSubstructure);
        for (LeafSubstructure<?, ?> leafSubstructure : branchSubstructure.getOrderedLeafSubstructures()) {
            this.orderedSubstructures.put(leafSubstructure.getIdentifier(), this.getSubstructures().get(this.getSubstructures().indexOf(leafSubstructure)));
        }
    }

    public static StructuralMotif fromLeaves(int identifier, Structure structure, List<LeafIdentifier> leafIdentifiers) {
        StructuralMotif motif = new StructuralMotif(identifier);
        leafIdentifiers.forEach(leafIdentifer -> {
            Substructure subStructure = structure.getAllChains().stream().filter(StructuralEntityFilter.ChainFilter.isInChain(leafIdentifer.getChainIdentifer())).findFirst().orElseThrow(NoSuchElementException::new).getSubstructure(leafIdentifer.getIdentifier()).orElseThrow(NoSuchElementException::new);
            motif.addSubstructure(subStructure);
        });
        return motif;
    }

    public static StructuralMotif fromLeaves(Structure structure, List<LeafIdentifier> leafIdentifiers) {
        return StructuralMotif.fromLeaves(0, structure, leafIdentifiers);
    }

    public static StructuralMotif fromLeaves(int identifier, List<LeafSubstructure<?, ?>> leafSubstructures) {
        StructuralMotif motif = new StructuralMotif(identifier);
        leafSubstructures.forEach(motif::addSubstructure);
        return motif;
    }

    public static StructuralMotif fromLeaves(List<LeafSubstructure<?, ?>> leafSubstructures) {
        return StructuralMotif.fromLeaves(0, leafSubstructures);
    }

    @Override
    public void removeLeafSubstructure(LeafIdentifier leafIdentifier) {
        super.removeLeafSubstructure(leafIdentifier);
        this.orderedSubstructures.entrySet().removeIf(substructure -> ((Substructure)substructure.getValue()).getIdentifier() == leafIdentifier.getIdentifier());
    }

    public List<LeafSubstructure<?, ?>> getOrderedLeafSubstructures() {
        ArrayList leafSubstructures = new ArrayList();
        for (Substructure<?> substructure : this.orderedSubstructures.values()) {
            if (substructure instanceof LeafSubstructure) {
                leafSubstructures.add((LeafSubstructure)substructure);
                continue;
            }
            if (!(substructure instanceof BranchSubstructure)) continue;
            leafSubstructures.addAll(((BranchSubstructure)substructure).getLeafSubstructures());
        }
        return leafSubstructures;
    }

    @Override
    public void addSubstructure(Substructure substructure) {
        this.substructures.put(substructure.getIdentifier(), substructure);
        this.orderedSubstructures.put(substructure.getIdentifier(), substructure);
    }

    public String toString() {
        return this.getSubstructures().stream().map(Object::toString).collect(Collectors.joining("_", this.getLeafSubstructures().stream().findAny().map(LeafSubstructure::getPdbIdentifier).orElse("") + "_", ""));
    }

    public int size() {
        return this.getLeafSubstructures().size();
    }

    public void addExchangeableFamily(LeafIdentifier leafIdentifier, MatcherFamily matcherFamily) {
        matcherFamily.getMembers().forEach(matcherFamilyMember -> this.addExchangeableFamily(leafIdentifier, (AminoAcidFamily)matcherFamilyMember));
    }

    public void addExchangeableFamily(LeafIdentifier leafIdentifier, NucleotideFamily nucleotideFamily) {
        this.getLeafSubstructures().stream().filter(StructuralEntityFilter.LeafFilter.isNucleotide()).map(Nucleotide.class::cast).filter(aminoAcid -> aminoAcid.getLeafIdentifier().getChainIdentifer().equals(leafIdentifier.getChainIdentifer())).filter(aminoAcid -> aminoAcid.getLeafIdentifier().getIdentifier() == leafIdentifier.getIdentifier()).findFirst().orElseThrow(NoSuchElementException::new).addExchangeableFamily(nucleotideFamily);
    }

    public void addExchangeableFamily(LeafIdentifier leafIdentifier, AminoAcidFamily aminoAcidFamily) {
        this.getLeafSubstructures().stream().filter(StructuralEntityFilter.LeafFilter.isAminoAcid()).map(AminoAcid.class::cast).filter(aminoAcid -> aminoAcid.getLeafIdentifier().getChainIdentifer().equals(leafIdentifier.getChainIdentifer())).filter(aminoAcid -> aminoAcid.getLeafIdentifier().getIdentifier() == leafIdentifier.getIdentifier()).findFirst().orElseThrow(NoSuchElementException::new).addExchangeableFamily(aminoAcidFamily);
    }

    public void addExchangeableFamilyToAll(AminoAcidFamily aminoAcidFamily) {
        this.getLeafSubstructures().stream().filter(StructuralEntityFilter.LeafFilter.isAminoAcid()).map(AminoAcid.class::cast).forEach(exchangeable -> exchangeable.addExchangeableFamily(aminoAcidFamily));
    }

    public void addExchangeableFamilyToAll(NucleotideFamily nucleotideFamily) {
        this.getLeafSubstructures().stream().filter(StructuralEntityFilter.LeafFilter.isNucleotide()).map(Nucleotide.class::cast).forEach(exchangeable -> exchangeable.addExchangeableFamily(nucleotideFamily));
    }

    public void addExchangeableFamilyToAll(MatcherFamily matcherFamily) {
        this.getLeafSubstructures().forEach(leafSubstructure -> matcherFamily.getMembers().forEach(matcherFamilyMember -> this.addExchangeableFamily(leafSubstructure.getLeafIdentifier(), (AminoAcidFamily)matcherFamilyMember)));
    }

    @Override
    public StructuralMotif getCopy() {
        return new StructuralMotif(this);
    }

    public void setPosition(Vector3D position) {
        throw new UnsupportedOperationException();
    }
}

