/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.families;

import de.bioforscher.singa.chemistry.parser.pdb.structures.StructureParserOptions;
import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.families.AminoAcidFamily;
import de.bioforscher.singa.chemistry.physical.families.NucleotideFamily;
import de.bioforscher.singa.chemistry.physical.leaves.AminoAcid;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.leaves.Nucleotide;
import de.bioforscher.singa.chemistry.physical.model.LeafIdentifier;
import java.util.Map;

public class LeafFactory {
    private LeafFactory() {
    }

    public static Nucleotide createNucleotideFromAtoms(LeafIdentifier leafIdentifier, NucleotideFamily nucleotideFamily, Map<String, Atom> atoms, StructureParserOptions options) {
        Nucleotide nucleotide = new Nucleotide(leafIdentifier, nucleotideFamily);
        if (options.isOmittingHydrogen()) {
            atoms.values().stream().filter(atom -> !atom.isHydrogen()).forEach(nucleotide::addNode);
        } else {
            atoms.values().forEach(nucleotide::addNode);
        }
        if (options.isCreatingEdges()) {
            LeafFactory.connectRibose(nucleotide, atoms);
            LeafFactory.connectPhosphateGroup(nucleotide, atoms);
            nucleotide.addEdgeBetween(atoms.get("P"), atoms.get("O5'"));
            switch (nucleotideFamily) {
                case ADENOSINE: {
                    nucleotide.addEdgeBetween(atoms.get("C2'"), atoms.get("O2'"));
                    LeafFactory.connectPurine(nucleotide, atoms);
                    nucleotide.addEdgeBetween(atoms.get("C6"), atoms.get("N6"));
                    nucleotide.addEdgeBetween(atoms.get("C1'"), atoms.get("N9"));
                    break;
                }
                case CYTIDINE: {
                    nucleotide.addEdgeBetween(atoms.get("C2'"), atoms.get("O2'"));
                    LeafFactory.connectPyrimidin(nucleotide, atoms);
                    nucleotide.addEdgeBetween(atoms.get("C4"), atoms.get("N4"));
                    nucleotide.addEdgeBetween(atoms.get("C1'"), atoms.get("N1"));
                    break;
                }
                case DESOXYADENOSINE: {
                    LeafFactory.connectPurine(nucleotide, atoms);
                    nucleotide.addEdgeBetween(atoms.get("C6"), atoms.get("N6"));
                    nucleotide.addEdgeBetween(atoms.get("C1'"), atoms.get("N9"));
                    break;
                }
                case DESOXYCYTIDINE: {
                    LeafFactory.connectPyrimidin(nucleotide, atoms);
                    nucleotide.addEdgeBetween(atoms.get("C4"), atoms.get("N4"));
                    nucleotide.addEdgeBetween(atoms.get("C1'"), atoms.get("N1"));
                    break;
                }
                case DESOXYGUANOSINE: {
                    LeafFactory.connectPurine(nucleotide, atoms);
                    nucleotide.addEdgeBetween(atoms.get("C6"), atoms.get("O6"));
                    nucleotide.addEdgeBetween(atoms.get("C2"), atoms.get("N2"));
                    nucleotide.addEdgeBetween(atoms.get("C1'"), atoms.get("N9"));
                    break;
                }
                case DESOXYTHYMIDINE: {
                    LeafFactory.connectPyrimidin(nucleotide, atoms);
                    nucleotide.addEdgeBetween(atoms.get("C4"), atoms.get("O4"));
                    nucleotide.addEdgeBetween(atoms.get("C5"), atoms.get("C7"));
                    nucleotide.addEdgeBetween(atoms.get("C1'"), atoms.get("N1"));
                    break;
                }
                case DESOXYURIDINE: {
                    LeafFactory.connectPyrimidin(nucleotide, atoms);
                    nucleotide.addEdgeBetween(atoms.get("C4"), atoms.get("O4"));
                    nucleotide.addEdgeBetween(atoms.get("C1'"), atoms.get("N1"));
                    break;
                }
                case GUANOSINE: {
                    nucleotide.addEdgeBetween(atoms.get("C2'"), atoms.get("O2'"));
                    LeafFactory.connectPurine(nucleotide, atoms);
                    nucleotide.addEdgeBetween(atoms.get("C6"), atoms.get("O6"));
                    nucleotide.addEdgeBetween(atoms.get("C2"), atoms.get("N2"));
                    nucleotide.addEdgeBetween(atoms.get("C1'"), atoms.get("N9"));
                    break;
                }
                case THYMIDINE: {
                    nucleotide.addEdgeBetween(atoms.get("C2'"), atoms.get("O2'"));
                    LeafFactory.connectPyrimidin(nucleotide, atoms);
                    nucleotide.addEdgeBetween(atoms.get("C4"), atoms.get("O4"));
                    nucleotide.addEdgeBetween(atoms.get("C5"), atoms.get("C7"));
                    nucleotide.addEdgeBetween(atoms.get("C1'"), atoms.get("N1"));
                    break;
                }
                case URIDINE: {
                    nucleotide.addEdgeBetween(atoms.get("C2'"), atoms.get("O2'"));
                    LeafFactory.connectPyrimidin(nucleotide, atoms);
                    nucleotide.addEdgeBetween(atoms.get("C4"), atoms.get("O4"));
                    nucleotide.addEdgeBetween(atoms.get("C1'"), atoms.get("N1"));
                }
            }
        }
        return nucleotide;
    }

    private static void connectRibose(Nucleotide nucleotide, Map<String, Atom> atoms) {
        LeafFactory.connectInOrder(nucleotide, atoms, "C1'", "C2'", "C3'", "C4'", "O4'", "C1'");
        nucleotide.addEdgeBetween(atoms.get("C3'"), atoms.get("O3'"));
        nucleotide.addEdgeBetween(atoms.get("C4'"), atoms.get("C5'"));
        nucleotide.addEdgeBetween(atoms.get("C5'"), atoms.get("O5'"));
    }

    private static void connectPhosphateGroup(Nucleotide nucleotide, Map<String, Atom> atoms) {
        nucleotide.addEdgeBetween(atoms.get("P"), atoms.get("OP1"));
        nucleotide.addEdgeBetween(atoms.get("P"), atoms.get("OP2"));
        nucleotide.addEdgeBetween(atoms.get("P"), atoms.get("OP3"));
    }

    private static void connectPyrimidin(Nucleotide nucleotide, Map<String, Atom> atoms) {
        LeafFactory.connectInOrder(nucleotide, atoms, "N1", "C2", "N3", "C4", "C5", "C6", "N1");
        nucleotide.addEdgeBetween(atoms.get("C2"), atoms.get("O2"));
    }

    private static void connectPurine(Nucleotide nucleotide, Map<String, Atom> atoms) {
        LeafFactory.connectInOrder(nucleotide, atoms, "N1", "C2", "N3", "C4", "N9", "C8", "N7", "C5", "C6", "N1");
        nucleotide.addEdgeBetween(atoms.get("C4"), atoms.get("C5"));
    }

    public static AminoAcid createAminoAcidFromAtoms(LeafIdentifier leafIdentifier, AminoAcidFamily aminoAcidFamily, Map<String, Atom> atoms, StructureParserOptions options) {
        AminoAcid aminoAcid = new AminoAcid(leafIdentifier, aminoAcidFamily);
        if (options.isOmittingHydrogen()) {
            atoms.values().stream().filter(atom -> !atom.isHydrogen()).forEach(aminoAcid::addNode);
        } else {
            atoms.values().forEach(aminoAcid::addNode);
        }
        if (options.isCreatingEdges()) {
            LeafFactory.connectBackboneAtoms(aminoAcid, atoms);
            switch (aminoAcidFamily) {
                case ALANINE: {
                    aminoAcid.addEdgeBetween(atoms.get("CA"), atoms.get("CB"));
                    break;
                }
                case ARGININE: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD", "NE", "CZ", "NH1");
                    aminoAcid.addEdgeBetween(atoms.get("CZ"), atoms.get("NH2"));
                    break;
                }
                case ASPARAGINE: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "OD1");
                    aminoAcid.addEdgeBetween(atoms.get("CG"), atoms.get("ND2"));
                    break;
                }
                case ASPARTIC_ACID: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "OD1");
                    aminoAcid.addEdgeBetween(atoms.get("CG"), atoms.get("OD2"));
                    break;
                }
                case CYSTEINE: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "SG");
                    break;
                }
                case GLUTAMINE: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD", "OE1");
                    aminoAcid.addEdgeBetween(atoms.get("CD"), atoms.get("NE2"));
                    break;
                }
                case GLUTAMIC_ACID: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD", "OE1");
                    aminoAcid.addEdgeBetween(atoms.get("CD"), atoms.get("OE2"));
                    break;
                }
                case GLYCINE: {
                    break;
                }
                case HISTIDINE: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD2", "NE2", "CE1", "ND1", "CG");
                    break;
                }
                case ISOLEUCINE: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG1", "CD1");
                    aminoAcid.addEdgeBetween(atoms.get("CB"), atoms.get("CG2"));
                    break;
                }
                case LEUCINE: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD1");
                    aminoAcid.addEdgeBetween(atoms.get("CG"), atoms.get("CD2"));
                    break;
                }
                case LYSINE: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD", "CE", "NZ");
                    break;
                }
                case METHIONINE: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "SD", "CE");
                    break;
                }
                case PHENYLALANINE: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD2", "CE2", "CZ", "CE1", "CD1", "CG");
                    break;
                }
                case PROLINE: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD", "N", "CA");
                    break;
                }
                case SERINE: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "OG");
                    break;
                }
                case THREONINE: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "OG1");
                    aminoAcid.addEdgeBetween(atoms.get("CB"), atoms.get("CG2"));
                    break;
                }
                case TRYPTOPHAN: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD", "CD1", "CE2", "CE2", "CZ2", "CH2", "CZ2", "CE3", "CD2", "CG");
                    aminoAcid.addEdgeBetween(atoms.get("CD2"), atoms.get("CE2"));
                    break;
                }
                case TYROSINE: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD1", "CE1", "CZ", "CE2", "CD2", "CG");
                    aminoAcid.addEdgeBetween(atoms.get("CZ"), atoms.get("OH"));
                    break;
                }
                case VALINE: {
                    LeafFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG1");
                    aminoAcid.addEdgeBetween(atoms.get("CB"), atoms.get("CG2"));
                    break;
                }
            }
        }
        return aminoAcid;
    }

    private static void connectInOrder(LeafSubstructure substructure, Map<String, Atom> atoms, String ... names) {
        if (names.length < 2) {
            throw new IllegalArgumentException("Two or more atom names are required in order to connect them.");
        }
        for (int i = 1; i < names.length; ++i) {
            substructure.addEdgeBetween(atoms.get(names[i - 1]), atoms.get(names[i]));
        }
    }

    private static void connectBackboneAtoms(AminoAcid aminoAcid, Map<String, Atom> atoms) {
        aminoAcid.addEdgeBetween(atoms.get("N"), atoms.get("CA"));
        aminoAcid.addEdgeBetween(atoms.get("CA"), atoms.get("C"));
        aminoAcid.addEdgeBetween(atoms.get("C"), atoms.get("O"));
    }

    private static void connectNTerminalAtoms(AminoAcid aminoAcid, Map<String, Atom> atoms, StructureParserOptions options) {
        if (options.isConnectingHydrogens()) {
            aminoAcid.addEdgeBetween(atoms.get("N"), atoms.get("H"));
            aminoAcid.addEdgeBetween(atoms.get("N"), atoms.get("H2"));
        }
    }

    private static void connectCTerminaAtoms(AminoAcid aminoAcid, Map<String, Atom> atoms, StructureParserOptions options) {
        aminoAcid.addEdgeBetween(atoms.get("C"), atoms.get("OXT"));
        if (options.isConnectingHydrogens()) {
            aminoAcid.addEdgeBetween(atoms.get("OXT"), atoms.get("HXT"));
        }
    }
}

