/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.families.substitution.matrices;

import de.bioforscher.singa.chemistry.physical.families.AminoAcidFamily;
import de.bioforscher.singa.chemistry.physical.model.StructuralFamily;
import de.bioforscher.singa.core.utility.TestUtils;
import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import de.bioforscher.singa.mathematics.matrices.Matrices;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SubstitutionMatrix
extends Enum<SubstitutionMatrix> {
    public static final /* enum */ SubstitutionMatrix BLOSUM_45 = new SubstitutionMatrix("de/bioforscher/singa/chemistry/physical/families/substitution/matrices/blosum45.csv");
    public static final /* enum */ SubstitutionMatrix MC_LACHLAN = new SubstitutionMatrix("de/bioforscher/singa/chemistry/physical/families/substitution/matrices/mclachlan.csv");
    private LabeledSymmetricMatrix<StructuralFamily> matrix;
    private static final /* synthetic */ SubstitutionMatrix[] $VALUES;

    public static SubstitutionMatrix[] values() {
        return (SubstitutionMatrix[])$VALUES.clone();
    }

    public static SubstitutionMatrix valueOf(String name) {
        return Enum.valueOf(SubstitutionMatrix.class, name);
    }

    private SubstitutionMatrix(String resourceLocation) {
        Logger logger = LoggerFactory.getLogger(SubstitutionMatrix.class);
        InputStream stream = TestUtils.getResourceAsStream((String)resourceLocation);
        LabeledSymmetricMatrix stringLabeledMatrix = null;
        try {
            stringLabeledMatrix = (LabeledSymmetricMatrix)Matrices.readLabeledMatrixFromCSV((InputStream)stream);
        }
        catch (IOException e) {
            logger.error("failed to read subsitution matrices from resources", (Throwable)e);
        }
        ArrayList<AminoAcidFamily> structuralFamilyLabels = new ArrayList<AminoAcidFamily>();
        assert (stringLabeledMatrix != null);
        for (int i = 0; i < stringLabeledMatrix.getRowDimension(); ++i) {
            String matrixLabel = (String)stringLabeledMatrix.getRowLabel(i);
            if (!Arrays.stream(AminoAcidFamily.values()).map(Enum::name).anyMatch(name -> name.equals(matrixLabel))) continue;
            structuralFamilyLabels.add(AminoAcidFamily.valueOf((String)stringLabeledMatrix.getRowLabel(i)));
        }
        this.matrix = new LabeledSymmetricMatrix(stringLabeledMatrix.getCompleteElements());
        this.matrix.setRowLabels(structuralFamilyLabels);
    }

    public LabeledSymmetricMatrix<StructuralFamily> getMatrix() {
        return this.matrix;
    }

    static {
        $VALUES = new SubstitutionMatrix[]{BLOSUM_45, MC_LACHLAN};
    }
}

