/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.leaves;

import de.bioforscher.singa.chemistry.physical.families.NucleotideFamily;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.LeafIdentifier;
import de.bioforscher.singa.mathematics.vectors.Vector3D;

public class Nucleotide
extends LeafSubstructure<Nucleotide, NucleotideFamily> {
    private final boolean modified;
    private final String modifiedName;

    public Nucleotide(LeafIdentifier leafIdentifier, NucleotideFamily family) {
        super(leafIdentifier, family);
        this.modified = false;
        this.modifiedName = null;
    }

    public Nucleotide(LeafIdentifier leafIdentifier, NucleotideFamily family, String modifiedName) {
        super(leafIdentifier, family);
        this.modified = true;
        this.modifiedName = modifiedName;
    }

    public Nucleotide(Nucleotide nucleotide) {
        super(nucleotide);
        this.modified = nucleotide.modified;
        this.modifiedName = nucleotide.modifiedName;
    }

    @Override
    public Nucleotide getCopy() {
        return new Nucleotide(this);
    }

    public String getName() {
        return this.modified ? this.modifiedName : ((NucleotideFamily)this.getFamily()).getThreeLetterCode();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setPosition(Vector3D position) {
        throw new UnsupportedOperationException();
    }
}

