/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.model;

import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.model.BondType;
import de.bioforscher.singa.mathematics.graphs.model.AbstractEdge;

public class Bond
extends AbstractEdge<Atom> {
    private BondType bondType;

    public Bond() {
        this(BondType.SINGLE_BOND);
    }

    public Bond(int identifier) {
        super(identifier);
    }

    public Bond(int identifier, BondType bondType) {
        super(identifier);
        this.bondType = bondType;
    }

    public Bond(BondType bondType) {
        this.bondType = bondType;
    }

    public Bond(Bond bond) {
        this.identifier = bond.getIdentifier();
        this.bondType = bond.getBondType();
    }

    public BondType getBondType() {
        return this.bondType;
    }

    public void setBondType(BondType bondType) {
        this.bondType = bondType;
    }

    public Bond getCopy() {
        return new Bond(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Bond bond = (Bond)((Object)o);
        if (this.identifier != bond.getIdentifier()) {
            return false;
        }
        return this.bondType == bond.bondType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.bondType != null ? this.bondType.hashCode() : 0);
        return result;
    }
}

