/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.model;

import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.branches.BranchSubstructure;
import de.bioforscher.singa.chemistry.physical.branches.Chain;
import de.bioforscher.singa.chemistry.physical.branches.StructuralModel;
import de.bioforscher.singa.chemistry.physical.leaves.AminoAcid;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntityFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Structure {
    private String pdbIdentifier;
    private String title;
    private Map<Integer, BranchSubstructure<?>> branchSubstructures = new TreeMap();

    public String toString() {
        return "Structure{pdbIdentifier='" + this.pdbIdentifier + '\'' + '}';
    }

    private List<BranchSubstructure<?>> getBranchSubstructures() {
        return new ArrayList(this.branchSubstructures.values());
    }

    public void addSubstructure(BranchSubstructure<?> branchSubstructure) {
        this.branchSubstructures.put(branchSubstructure.getIdentifier(), branchSubstructure);
    }

    public List<StructuralModel> getAllModels() {
        return this.getBranchSubstructures().stream().filter(StructuralEntityFilter.BranchFilter.isModel()).map(StructuralModel.class::cast).collect(Collectors.toList());
    }

    public Optional<StructuralModel> getFirstModel() {
        return this.getBranchSubstructures().stream().filter(StructuralEntityFilter.BranchFilter.isModel()).map(StructuralModel.class::cast).findFirst();
    }

    public List<Chain> getAllChains() {
        return this.getAllBranches().stream().filter(StructuralEntityFilter.BranchFilter.isChain()).map(Chain.class::cast).collect(Collectors.toList());
    }

    public List<AminoAcid> getAllAminoAcids() {
        return this.branchSubstructures.values().stream().map(BranchSubstructure::getAminoAcids).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<LeafSubstructure<?, ?>> getAllLeaves() {
        return this.branchSubstructures.values().stream().map(BranchSubstructure::getLeafSubstructures).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<BranchSubstructure<?>> getAllBranches() {
        List<BranchSubstructure<?>> branchSubstructures = this.branchSubstructures.values().stream().map(BranchSubstructure::getBranchSubstructures).flatMap(Collection::stream).collect(Collectors.toList());
        branchSubstructures.addAll(this.branchSubstructures.values());
        return branchSubstructures;
    }

    public List<Atom> getAllAtoms() {
        return this.branchSubstructures.values().stream().map(BranchSubstructure::getAllAtoms).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String getPdbIdentifier() {
        return this.pdbIdentifier;
    }

    public void setPdbIdentifier(String pdbID) {
        this.pdbIdentifier = pdbID;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

