/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.model;

import de.bioforscher.singa.chemistry.physical.branches.StructuralMotif;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntity;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import de.bioforscher.singa.mathematics.metrics.model.VectorMetricProvider;
import java.util.List;
import java.util.stream.Collectors;

public class Structures {
    private Structures() {
    }

    public static LabeledSymmetricMatrix<LeafSubstructure<?, ?>> calculateDistanceMatrix(StructuralMotif structuralMotif) {
        LabeledSymmetricMatrix labeledDistances = new LabeledSymmetricMatrix(VectorMetricProvider.EUCLIDEAN_METRIC.calculateDistancesPairwise(structuralMotif.getLeafSubstructures().stream().map(Node::getPosition).collect(Collectors.toList())).getElements());
        labeledDistances.setRowLabels(structuralMotif.getLeafSubstructures());
        return labeledDistances;
    }

    public static LabeledSymmetricMatrix<LeafSubstructure<?, ?>> calculateSquaredDistanceMatrix(StructuralMotif structuralMotif) {
        LabeledSymmetricMatrix labeledDistances = new LabeledSymmetricMatrix(VectorMetricProvider.SQUARED_EUCLIDEAN_METRIC.calculateDistancesPairwise(structuralMotif.getLeafSubstructures().stream().map(Node::getPosition).collect(Collectors.toList())).getElements());
        labeledDistances.setRowLabels(structuralMotif.getLeafSubstructures());
        return labeledDistances;
    }

    public static <T extends StructuralEntity<T>> LabeledSymmetricMatrix<T> calculateDistanceMatrix(List<T> structuralEntities) {
        LabeledSymmetricMatrix labeledDistances = new LabeledSymmetricMatrix(VectorMetricProvider.EUCLIDEAN_METRIC.calculateDistancesPairwise(structuralEntities.stream().map(Node::getPosition).collect(Collectors.toList())).getElements());
        labeledDistances.setRowLabels(structuralEntities);
        return labeledDistances;
    }

    public static <T extends StructuralEntity<T>> LabeledSymmetricMatrix<T> calculateSquaredDistanceMatrix(List<T> structuralEntities) {
        LabeledSymmetricMatrix labeledDistances = new LabeledSymmetricMatrix(VectorMetricProvider.SQUARED_EUCLIDEAN_METRIC.calculateDistancesPairwise(structuralEntities.stream().map(Node::getPosition).collect(Collectors.toList())).getElements());
        labeledDistances.setRowLabels(structuralEntities);
        return labeledDistances;
    }
}

