/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.algorithms.structure;

import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.branches.BranchSubstructure;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntity;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.metrics.model.VectorMetricProvider;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.mathematics.vectors.Vectors3D;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Gyration {
    private final List<Atom> atoms;
    private double radius;
    private Vector3D centroid;

    private Gyration(List<Atom> atoms) {
        this.atoms = atoms;
        this.calculateRadius();
    }

    public static Gyration of(StructuralEntity<?, ?> structuralEntity) {
        ArrayList<Atom> allAtoms = new ArrayList<Atom>();
        if (structuralEntity instanceof Atom) {
            allAtoms.add((Atom)structuralEntity);
        } else if (structuralEntity instanceof LeafSubstructure) {
            allAtoms.addAll(((LeafSubstructure)structuralEntity).getAllAtoms());
        } else if (structuralEntity instanceof BranchSubstructure) {
            allAtoms.addAll(((BranchSubstructure)structuralEntity).getAllAtoms());
        }
        return new Gyration(allAtoms);
    }

    public List<Atom> getAtoms() {
        return this.atoms;
    }

    public Vector3D getCentroid() {
        return this.centroid;
    }

    public double getRadius() {
        return this.radius;
    }

    private void calculateRadius() {
        List positions = this.atoms.stream().map(Node::getPosition).collect(Collectors.toList());
        this.centroid = Vectors3D.getCentroid(positions);
        double sumOfSquaredDistances = 0.0;
        double sumOfMolecularMass = 0.0;
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = this.atoms.get(i);
            sumOfSquaredDistances += atom.getElement().getAtomicMass().getValue().doubleValue() * VectorMetricProvider.SQUARED_EUCLIDEAN_METRIC.calculateDistance(atom.getPosition(), (Vector)this.centroid);
            sumOfMolecularMass += atom.getElement().getAtomicMass().getValue().doubleValue();
        }
        this.radius = Math.sqrt(sumOfSquaredDistances / sumOfMolecularMass);
    }
}

