/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.algorithms.superimposition.affinity;

import de.bioforscher.singa.chemistry.algorithms.superimposition.SubstructureSuperimposer;
import de.bioforscher.singa.chemistry.algorithms.superimposition.SubstructureSuperimposition;
import de.bioforscher.singa.chemistry.parser.pdb.structures.StructureWriter;
import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.atoms.representations.RepresentationScheme;
import de.bioforscher.singa.chemistry.physical.atoms.representations.RepresentationSchemeFactory;
import de.bioforscher.singa.chemistry.physical.atoms.representations.RepresentationSchemeType;
import de.bioforscher.singa.chemistry.physical.branches.BranchSubstructure;
import de.bioforscher.singa.chemistry.physical.branches.StructuralMotif;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntityFilter;
import de.bioforscher.singa.mathematics.algorithms.clustering.AffinityPropagation;
import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import de.bioforscher.singa.mathematics.vectors.RegularVector;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vectors;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffinityAlignment {
    private static final Logger logger = LoggerFactory.getLogger(AffinityAlignment.class);
    private static final int MAXIMAL_EPOCHS = 1000;
    private static final double LAMBDA = 0.5;
    private final List<StructuralMotif> input;
    private final boolean idealSuperimposition;
    private final Predicate<Atom> atomFilter;
    private RepresentationScheme representationScheme;
    private LabeledSymmetricMatrix<StructuralMotif> distanceMatrix;
    private double selfDissimilarity;
    private Map<StructuralMotif, List<StructuralMotif>> clusters;
    private double silhouetteCoefficient;

    private AffinityAlignment(Builder builder) {
        this.input = builder.structuralMotifs.stream().map(StructuralMotif::getCopy).collect(Collectors.toList());
        RepresentationSchemeType representationSchemeType = builder.representationSchemeType;
        if (representationSchemeType != null) {
            logger.info("using representation scheme {}", (Object)representationSchemeType);
            this.representationScheme = RepresentationSchemeFactory.createRepresentationScheme(representationSchemeType);
        }
        this.idealSuperimposition = builder.idealSuperimposition;
        this.atomFilter = builder.atomFilter;
        logger.info("affinity alignment initialized with {} input structures", (Object)this.input.size());
        if (this.input.stream().map(BranchSubstructure::getLeafSubstructures).map(List::size).collect(Collectors.toSet()).size() != 1) {
            throw new IllegalArgumentException("all substructures must contain the same number of leaf structures to calculate a consensus alignment");
        }
        this.calculateInitialAlignments();
        this.determineSelfSimilarity();
        this.computeClustering();
        if (builder.alignWithinClusters) {
            this.alignWithinClusters();
        }
    }

    public static InputStep create() {
        return new Builder();
    }

    public LabeledSymmetricMatrix<StructuralMotif> getDistanceMatrix() {
        return this.distanceMatrix;
    }

    public double getSelfDissimilarity() {
        return this.selfDissimilarity;
    }

    public double getSilhouetteCoefficient() {
        return this.silhouetteCoefficient;
    }

    public Map<StructuralMotif, List<StructuralMotif>> getClusters() {
        return this.clusters;
    }

    private void alignWithinClusters() {
        for (Map.Entry<StructuralMotif, List<StructuralMotif>> entry : this.clusters.entrySet()) {
            ArrayList<StructuralMotif> alignedCluster = new ArrayList<StructuralMotif>();
            StructuralMotif reference = entry.getKey();
            for (StructuralMotif structuralMotif : entry.getValue()) {
                SubstructureSuperimposition superimposition = this.representationScheme == null ? (this.idealSuperimposition ? SubstructureSuperimposer.calculateIdealSubstructureSuperimposition((BranchSubstructure)reference, (BranchSubstructure)structuralMotif, this.atomFilter) : SubstructureSuperimposer.calculateSubstructureSuperimposition(reference.getOrderedLeafSubstructures(), structuralMotif.getOrderedLeafSubstructures(), this.atomFilter)) : (this.idealSuperimposition ? SubstructureSuperimposer.calculateIdealSubstructureSuperimposition((BranchSubstructure)reference, (BranchSubstructure)structuralMotif, this.representationScheme) : SubstructureSuperimposer.calculateSubstructureSuperimposition(reference.getOrderedLeafSubstructures(), structuralMotif.getOrderedLeafSubstructures(), this.representationScheme));
                alignedCluster.add(StructuralMotif.fromLeafSubstructures(superimposition.getMappedFullCandidate()));
            }
            entry.setValue(alignedCluster);
        }
    }

    private void determineSelfSimilarity() {
        this.selfDissimilarity = Vectors.getMedian((Vector)new RegularVector(this.distanceMatrix.streamElements().toArray()));
        logger.info("self-dissimilarity of input structures (median of RMSD values) is {}", (Object)this.selfDissimilarity);
    }

    private void computeClustering() {
        AffinityPropagation affinityPropagation = AffinityPropagation.create().dataPoints(this.input).matrix(this.distanceMatrix).isDistance(true).selfSimilarity(this.selfDissimilarity).maximalEpochs(1000).lambda(0.5).run();
        this.silhouetteCoefficient = affinityPropagation.getSilhouetteCoefficient();
        this.clusters = affinityPropagation.getClusters();
        logger.info("found {} clusters", (Object)this.clusters.size());
    }

    private void calculateInitialAlignments() {
        double[][] temporaryDistanceMatrix = new double[this.input.size()][this.input.size()];
        for (int i = 0; i < this.input.size() - 1; ++i) {
            for (int j = i + 1; j < this.input.size(); ++j) {
                StructuralMotif reference = this.input.get(i);
                StructuralMotif candidate = this.input.get(j);
                SubstructureSuperimposition superimposition = this.representationScheme == null ? (this.idealSuperimposition ? SubstructureSuperimposer.calculateIdealSubstructureSuperimposition((BranchSubstructure)reference, (BranchSubstructure)candidate, this.atomFilter) : SubstructureSuperimposer.calculateSubstructureSuperimposition(reference.getOrderedLeafSubstructures(), candidate.getOrderedLeafSubstructures(), this.atomFilter)) : (this.idealSuperimposition ? SubstructureSuperimposer.calculateIdealSubstructureSuperimposition((BranchSubstructure)reference, (BranchSubstructure)candidate, this.representationScheme) : SubstructureSuperimposer.calculateSubstructureSuperimposition(reference.getOrderedLeafSubstructures(), candidate.getOrderedLeafSubstructures(), this.representationScheme));
                temporaryDistanceMatrix[i][j] = superimposition.getRmsd();
                temporaryDistanceMatrix[j][i] = superimposition.getRmsd();
            }
        }
        this.distanceMatrix = new LabeledSymmetricMatrix(temporaryDistanceMatrix);
        this.distanceMatrix.setRowLabels(this.input);
    }

    public void writeClusters(Path outputPath) throws IOException {
        logger.info("writing {} clusters to {}", (Object)this.clusters.size(), (Object)outputPath);
        Files.createDirectories(outputPath, new FileAttribute[0]);
        int clusterCounter = 0;
        for (Map.Entry<StructuralMotif, List<StructuralMotif>> entry : this.clusters.entrySet()) {
            String clusterBaseLocation = "cluster_" + (clusterCounter + 1) + "/";
            StructureWriter.writeLeafSubstructures(entry.getKey().getLeafSubstructures(), outputPath.resolve(clusterBaseLocation + "exemplar_" + (clusterCounter + 1) + "_" + entry.getKey() + ".pdb"));
            for (StructuralMotif structuralMotif : entry.getValue()) {
                StructureWriter.writeLeafSubstructures(structuralMotif.getLeafSubstructures(), outputPath.resolve(clusterBaseLocation + structuralMotif + ".pdb"));
            }
            ++clusterCounter;
        }
    }

    public static class Builder
    implements InputStep,
    AtomStep,
    ParameterStep {
        private static final boolean DEFAULT_ALIGN_WITHIN_CLUSTERS = true;
        private static final Predicate<Atom> DEFAULT_ATOM_FILTER = StructuralEntityFilter.AtomFilter.isArbitrary();
        private static final RepresentationSchemeType DEFAULT_REPRESENTATION_SCHEME_TYPE = null;
        private static final boolean DEFAULT_IDEAL_SUPERIMPOSITION = false;
        RepresentationSchemeType representationSchemeType = DEFAULT_REPRESENTATION_SCHEME_TYPE;
        Predicate<Atom> atomFilter = DEFAULT_ATOM_FILTER;
        boolean idealSuperimposition = false;
        boolean alignWithinClusters = true;
        private List<StructuralMotif> structuralMotifs;

        private Builder() {
        }

        @Override
        public AtomStep inputStructuralMotifs(List<StructuralMotif> structuralMotifs) {
            this.structuralMotifs = structuralMotifs;
            return this;
        }

        @Override
        public ParameterStep representationSchemeType(RepresentationSchemeType representationSchemeType) {
            this.representationSchemeType = representationSchemeType;
            return this;
        }

        @Override
        public ParameterStep atomFilter(Predicate<Atom> atomFilter) {
            this.atomFilter = atomFilter;
            return this;
        }

        @Override
        public AffinityAlignment run() {
            return new AffinityAlignment(this);
        }

        @Override
        public ParameterStep idealSuperimposition(boolean idealSuperimposition) {
            this.idealSuperimposition = idealSuperimposition;
            return this;
        }

        @Override
        public ParameterStep alignWithinClusters(boolean alignWithinClusters) {
            this.alignWithinClusters = alignWithinClusters;
            return this;
        }
    }

    public static interface AtomStep {
        public ParameterStep representationSchemeType(RepresentationSchemeType var1);

        public ParameterStep atomFilter(Predicate<Atom> var1);

        public AffinityAlignment run();
    }

    public static interface ParameterStep {
        public ParameterStep idealSuperimposition(boolean var1);

        public ParameterStep alignWithinClusters(boolean var1);

        public AffinityAlignment run();
    }

    public static interface InputStep {
        public AtomStep inputStructuralMotifs(List<StructuralMotif> var1);
    }
}

