/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.algorithms.superimposition.consensus;

import de.bioforscher.singa.chemistry.algorithms.superimposition.SubstructureSuperimposition;
import de.bioforscher.singa.chemistry.physical.branches.StructuralMotif;
import de.bioforscher.singa.mathematics.graphs.trees.BinaryTree;

public class ConsensusContainer {
    private StructuralMotif structuralMotif;
    private double consensusDistance;
    private BinaryTree<ConsensusContainer> consensusTree;
    private SubstructureSuperimposition superimposition;
    private boolean consensus;

    public ConsensusContainer(StructuralMotif structuralMotif, boolean consensus) {
        this.structuralMotif = structuralMotif;
        this.consensus = consensus;
        this.consensusDistance = 0.0;
    }

    public boolean isConsensus() {
        return this.consensus;
    }

    public SubstructureSuperimposition getSuperimposition() {
        return this.superimposition;
    }

    public void setSuperimposition(SubstructureSuperimposition superimposition) {
        this.superimposition = superimposition;
    }

    public String toString() {
        return this.structuralMotif.toString() + "_" + this.consensusDistance;
    }

    public StructuralMotif getStructuralMotif() {
        return this.structuralMotif;
    }

    public BinaryTree<ConsensusContainer> getConsensusTree() {
        return this.consensusTree;
    }

    public void setConsensusTree(BinaryTree<ConsensusContainer> consensusTree) {
        this.consensusTree = consensusTree;
    }

    public void addToConsensusDistance(double delta) {
        this.consensusDistance += delta;
    }

    public double getConsensusDistance() {
        return this.consensusDistance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsensusContainer that = (ConsensusContainer)o;
        return this.structuralMotif != null ? this.structuralMotif.equals(that.structuralMotif) : that.structuralMotif == null;
    }

    public int hashCode() {
        return this.structuralMotif != null ? this.structuralMotif.hashCode() : 0;
    }
}

